/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.common.world.badge;

import com.cobblemon.mod.common.api.text.TextKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.harmex.cobblebadges.common.CobbleBadges;
import fr.harmex.cobblebadges.common.core.registries.CobbleBadgesRegistries;
import fr.harmex.cobblebadges.common.utils.MiscUtilsKt;
import fr.harmex.cobblebadges.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobblebadges.common.world.badge.AttributeBadge;
import fr.harmex.cobblebadges.common.world.badge.Badge;
import fr.harmex.cobblebadges.common.world.badge.Badges;
import fr.harmex.cobblebadges.common.world.badge.MobEffectBadge;
import fr.harmex.cobblebadges.common.world.badge.MobEffectImmuneBadge;
import fr.harmex.cobblebadges.common.world.badge.PlayerBadge;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u001d\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b \u0010!J\u001a\u0010#\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010'R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010!\"\u0004\b\u0017\u0010*R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010+\u001a\u0004\b\u0007\u0010,\"\u0004\b-\u0010.R\u0011\u00102\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00104\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b3\u00101\u00a8\u00066"}, d2={"Lfr/harmex/cobblebadges/common/world/badge/PlayerBadge;", "", "Lfr/harmex/cobblebadges/common/world/badge/Badge;", "badge", "", "tier", "", "isActive", "<init>", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;IZ)V", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "Lnet/minecraft/nbt/Tag;", "save", "(Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/nbt/Tag;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "tick", "(Lnet/minecraft/world/entity/player/Player;)V", "updateBadgeEffects", "tierUp", "tierDown", "setTier", "(ILnet/minecraft/world/entity/player/Player;)V", "state", "activate", "(ZLnet/minecraft/world/entity/player/Player;)V", "", "Lnet/minecraft/network/chat/Component;", "createTooltipComponents", "(Lnet/minecraft/world/entity/player/Player;)Ljava/util/List;", "hashCode", "()I", "other", "equals", "(Ljava/lang/Object;)Z", "Lfr/harmex/cobblebadges/common/world/badge/Badge;", "getBadge", "()Lfr/harmex/cobblebadges/common/world/badge/Badge;", "I", "getTier", "(I)V", "Z", "()Z", "setActive", "(Z)V", "Lnet/minecraft/network/chat/MutableComponent;", "getHoverName", "()Lnet/minecraft/network/chat/MutableComponent;", "hoverName", "getDisplayName", "displayName", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerBadge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerBadge.kt\nfr/harmex/cobblebadges/common/world/badge/PlayerBadge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1863#2,2:157\n1863#2,2:159\n1863#2,2:161\n1863#2,2:163\n*S KotlinDebug\n*F\n+ 1 PlayerBadge.kt\nfr/harmex/cobblebadges/common/world/badge/PlayerBadge\n*L\n110#1:157,2\n118#1:159,2\n126#1:161,2\n132#1:163,2\n*E\n"})
public final class PlayerBadge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Badge badge;
    private int tier;
    private boolean isActive;
    @NotNull
    private static final Codec<PlayerBadge> CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, PlayerBadge> STREAM_CODEC;

    public PlayerBadge(@NotNull Badge badge, int tier, boolean isActive) {
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        this.badge = badge;
        this.tier = tier;
        this.isActive = isActive;
    }

    @NotNull
    public final Badge getBadge() {
        return this.badge;
    }

    public final int getTier() {
        return this.tier;
    }

    public final void setTier(int n) {
        this.tier = n;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final void setActive(boolean bl) {
        this.isActive = bl;
    }

    @NotNull
    public final MutableComponent getHoverName() {
        Object[] objectArray = new Object[]{MiscUtilsKt.cobbleBadgesTier(this.tier), this.badge.getName()};
        MutableComponent mutableComponent = MiscUtilsKt.cobbleBadgesBadge(objectArray).withColor(this.badge.getColor());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withColor(...)");
        return mutableComponent;
    }

    @NotNull
    public final MutableComponent getDisplayName() {
        MutableComponent mutableComponent = ComponentUtils.wrapInSquareBrackets((Component)((Component)this.getHoverName()));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"wrapInSquareBrackets(...)");
        return mutableComponent;
    }

    @NotNull
    public final Tag save(@NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Object object = CODEC.encodeStart((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(...)");
        return (Tag)object;
    }

    public final void tick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.badge instanceof MobEffectImmuneBadge) {
            ((MobEffectImmuneBadge)this.badge).tick(player, this.tier, this.isActive);
        } else if (this.tier > 0 && this.isActive) {
            this.badge.tick(player);
        }
    }

    public final void updateBadgeEffects(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.badge instanceof AttributeBadge) {
            ((AttributeBadge)this.badge).updateAttributes(player, this.tier, this.isActive);
        }
        if (this.badge instanceof MobEffectBadge) {
            ((MobEffectBadge)this.badge).applyEffects(player, this.tier, this.isActive);
        }
    }

    public final void tierUp(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.tier < this.badge.getMaxTier()) {
            int n = this.tier;
            this.tier = n + 1;
            this.updateBadgeEffects(player);
        }
    }

    public final void tierDown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.tier > 0) {
            int n = this.tier;
            this.tier = n + -1;
            this.updateBadgeEffects(player);
        }
    }

    public final void setTier(int tier, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.tier = RangesKt.coerceAtMost((int)tier, (int)this.badge.getMaxTier());
        this.updateBadgeEffects(player);
    }

    public final void activate(boolean state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.isActive = state;
        this.updateBadgeEffects(player);
    }

    @NotNull
    public final List<Component> createTooltipComponents(@NotNull Player player) {
        Component it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List tooltipComponents = new ArrayList();
        MutableComponent mutableComponent = this.getHoverName().append((Component)TextKt.gray((String)(" (" + PlayerExtensionKt.getPoints(player, this.badge.getPointsToTierUp().get(0)) + ")")));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
        tooltipComponents.add(mutableComponent);
        if (this.badge instanceof AttributeBadge && this.tier != 0) {
            $this$forEach$iv = ((AttributeBadge)this.badge).getAttributesTooltip(this.tier);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Component)element$iv;
                boolean bl = false;
                tooltipComponents.add(it);
            }
        }
        if (this.badge instanceof MobEffectBadge && this.tier != 0) {
            $this$forEach$iv = ((MobEffectBadge)this.badge).getMobEffectsTooltip(this.tier);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Component)element$iv;
                boolean bl = false;
                tooltipComponents.add(it);
            }
        }
        if (this.badge instanceof MobEffectImmuneBadge && this.tier != 0) {
            $this$forEach$iv = ((MobEffectImmuneBadge)this.badge).getMobEffectsImmunityTooltip(this.tier);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Component)element$iv;
                boolean bl = false;
                tooltipComponents.add(it);
            }
        }
        $this$forEach$iv = this.badge.getCustomEffectTooltip(this.tier);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Component)element$iv;
            boolean bl = false;
            tooltipComponents.add(it);
        }
        return tooltipComponents;
    }

    public int hashCode() {
        int result = this.badge.hashCode();
        result = 31 * result + this.tier;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type fr.harmex.cobblebadges.common.world.badge.PlayerBadge");
        PlayerBadge cfr_ignored_0 = (PlayerBadge)other;
        if (!Intrinsics.areEqual((Object)this.badge, (Object)((PlayerBadge)other).badge)) {
            return false;
        }
        return this.tier == ((PlayerBadge)other).tier;
    }

    private static final Badge CODEC$lambda$8$lambda$7$lambda$4(KProperty1 $tmp0, PlayerBadge p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Badge)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$8$lambda$7$lambda$5(KMutableProperty1 $tmp0, PlayerBadge p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean CODEC$lambda$8$lambda$7$lambda$6(KMutableProperty1 $tmp0, PlayerBadge p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$8$lambda$7(RecordCodecBuilder.Instance instance) {
        return instance.group((App)CobbleBadgesRegistries.INSTANCE.getBADGE().byNameCodec().fieldOf("id").forGetter(arg_0 -> PlayerBadge.CODEC$lambda$8$lambda$7$lambda$4((KProperty1)Companion.CODEC.1.1.1.INSTANCE, arg_0)), (App)ExtraCodecs.intRange((int)0, (int)5).fieldOf("tier").orElse((Object)0).forGetter(arg_0 -> PlayerBadge.CODEC$lambda$8$lambda$7$lambda$5((KMutableProperty1)Companion.CODEC.1.1.2.INSTANCE, arg_0)), (App)Codec.BOOL.fieldOf("isActive").orElse((Object)true).forGetter(arg_0 -> PlayerBadge.CODEC$lambda$8$lambda$7$lambda$6((KMutableProperty1)Companion.CODEC.1.1.3.INSTANCE, arg_0))).apply((Applicative)instance, PlayerBadge::new);
    }

    private static final Codec CODEC$lambda$8() {
        return RecordCodecBuilder.create(PlayerBadge::CODEC$lambda$8$lambda$7);
    }

    static {
        Codec codec = Codec.lazyInitialized(PlayerBadge::CODEC$lambda$8);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"lazyInitialized(...)");
        CODEC = codec;
        STREAM_CODEC = (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, PlayerBadge>(){
            private final StreamCodec<RegistryFriendlyByteBuf, Badge> BADGE_STREAM_CODEC;
            {
                this.BADGE_STREAM_CODEC = ByteBufCodecs.registry(Badges.INSTANCE.getResourceKey());
            }

            public final StreamCodec<RegistryFriendlyByteBuf, Badge> getBADGE_STREAM_CODEC() {
                return this.BADGE_STREAM_CODEC;
            }

            public PlayerBadge decode(RegistryFriendlyByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Badge badge = (Badge)this.BADGE_STREAM_CODEC.decode((Object)buf);
                int tier = buf.readVarInt();
                boolean isActive = buf.readBoolean();
                Intrinsics.checkNotNull((Object)badge);
                return new PlayerBadge(badge, tier, isActive);
            }

            public void encode(RegistryFriendlyByteBuf buf, PlayerBadge playerBadge) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)playerBadge, (String)"playerBadge");
                this.BADGE_STREAM_CODEC.encode((Object)buf, (Object)playerBadge.getBadge());
                buf.writeVarInt(playerBadge.getTier());
                buf.writeBoolean(playerBadge.isActive());
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bR\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lfr/harmex/cobblebadges/common/world/badge/PlayerBadge$Companion;", "", "<init>", "()V", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "Lnet/minecraft/nbt/Tag;", "tag", "Ljava/util/Optional;", "Lfr/harmex/cobblebadges/common/world/badge/PlayerBadge;", "parse", "(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/nbt/Tag;)Ljava/util/Optional;", "Lcom/mojang/serialization/Codec;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<PlayerBadge> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, PlayerBadge> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @NotNull
        public final Optional<PlayerBadge> parse(@NotNull RegistryAccess registryAccess, @NotNull Tag tag) {
            Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Optional optional = this.getCODEC().parse((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(Companion::parse$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"resultOrPartial(...)");
            return optional;
        }

        private static final void parse$lambda$0(String string) {
            CobbleBadges.INSTANCE.getLOGGER().error("Tried to load invalid badge: '{}'", (Object)string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

