/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.common.world.badge.badges;

import fr.harmex.cobblebadges.common.utils.MiscUtilsKt;
import fr.harmex.cobblebadges.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobblebadges.common.world.badge.Badge;
import fr.harmex.cobblebadges.common.world.badge.Point;
import fr.harmex.cobblebadges.common.world.badge.Points;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\t8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lfr/harmex/cobblebadges/common/world/badge/badges/CaptureBadge;", "Lfr/harmex/cobblebadges/common/world/badge/Badge;", "<init>", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "canTierUp", "(Lnet/minecraft/world/entity/player/Player;)Z", "", "tier", "", "Lnet/minecraft/network/chat/Component;", "getCustomEffectTooltip", "(I)Ljava/util/List;", "getMaxTier", "()I", "maxTier", "Lfr/harmex/cobblebadges/common/world/badge/Point;", "getPointsToTierUp", "()Ljava/util/List;", "pointsToTierUp", "color", "I", "getColor", "common"})
public final class CaptureBadge
implements Badge {
    private final int color;

    public CaptureBadge() {
        this.color = 12498638;
    }

    @Override
    public int getMaxTier() {
        return 5;
    }

    @Override
    @NotNull
    public List<Point> getPointsToTierUp() {
        Object[] objectArray = new Point[]{Points.INSTANCE.getCAPTURE(), Points.INSTANCE.getSHINY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean canTierUp(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return PlayerExtensionKt.getBadgeTier(player, this) < 4 ? Badge.DefaultImpls.canTierUp(this, player) : Badge.DefaultImpls.canTierUp(this, player) && PlayerExtensionKt.getPoints(player, Points.INSTANCE.getSHINY()) >= 10;
    }

    @Override
    @NotNull
    public List<Component> getCustomEffectTooltip(int tier) {
        List customEffectsTooltip = new ArrayList();
        if (tier >= 1) {
            int catchRateMultiplier = switch (tier) {
                case 1 -> 25;
                case 2 -> 50;
                case 3 -> 75;
                default -> 100;
            };
            Object[] objectArray = new Object[]{catchRateMultiplier};
            MutableComponent mutableComponent = MiscUtilsKt.lineStart().append((Component)Component.translatable((String)"badge.cobblebadges.catch_rate_multiplier", (Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
            customEffectsTooltip.add(mutableComponent);
        }
        if (tier >= 4) {
            MutableComponent mutableComponent = MiscUtilsKt.lineStart().append((Component)Component.translatable((String)"badge.cobblebadges.recalculate_capture"));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
            customEffectsTooltip.add(mutableComponent);
        }
        if (tier >= 5) {
            MutableComponent mutableComponent = MiscUtilsKt.lineStart().append((Component)Component.translatable((String)"badge.cobblebadges.shiny_chance"));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
            customEffectsTooltip.add(mutableComponent);
        }
        return customEffectsTooltip;
    }

    @Override
    @NotNull
    public String getDescriptionId() {
        return Badge.DefaultImpls.getDescriptionId(this);
    }

    @Override
    @NotNull
    public MutableComponent getName() {
        return Badge.DefaultImpls.getName(this);
    }

    @Override
    @NotNull
    public MutableComponent getHoverName() {
        return Badge.DefaultImpls.getHoverName(this);
    }

    @Override
    @NotNull
    public MutableComponent getDisplayName() {
        return Badge.DefaultImpls.getDisplayName(this);
    }

    @Override
    public void tick(@NotNull Player player) {
        Badge.DefaultImpls.tick(this, player);
    }

    @Override
    public boolean canTierDown(@NotNull Player player) {
        return Badge.DefaultImpls.canTierDown(this, player);
    }

    @Override
    public void onPlayerAttackLivingEntity(@NotNull Player player, @NotNull LivingEntity livingEntity, int tier, boolean isBadgeActive) {
        Badge.DefaultImpls.onPlayerAttackLivingEntity(this, player, livingEntity, tier, isBadgeActive);
    }
}

