/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.common.world.entity.player;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import fr.harmex.cobblebadges.common.utils.MiscUtilsKt;
import fr.harmex.cobblebadges.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobblebadges.common.world.badge.Badge;
import fr.harmex.cobblebadges.common.world.badge.Badges;
import fr.harmex.cobblebadges.common.world.badge.PlayerBadge;
import fr.harmex.cobblebadges.common.world.badge.Point;
import fr.harmex.cobblebadges.common.world.badge.Points;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001c\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0015\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b!\u0010\"J\u001d\u0010#\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b#\u0010\"J%\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b%\u0010&J%\u0010(\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b(\u0010)J\r\u0010*\u001a\u00020\u0007\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010-\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J'\u00100\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00062\b\b\u0002\u0010/\u001a\u00020\u0007\u00a2\u0006\u0004\b0\u00101J%\u00102\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0007\u00a2\u0006\u0004\b2\u00101R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00103\u001a\u0004\b4\u00105R#\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u00106\u001a\u0004\b-\u00107\u00a8\u00068"}, d2={"Lfr/harmex/cobblebadges/common/world/entity/player/BadgeManager;", "", "", "Lfr/harmex/cobblebadges/common/world/badge/PlayerBadge;", "badges", "", "Lfr/harmex/cobblebadges/common/world/badge/Point;", "", "points", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "()V", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "load", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/RegistryAccess;)Lfr/harmex/cobblebadges/common/world/entity/player/BadgeManager;", "save", "(Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "tick", "(Lnet/minecraft/world/entity/player/Player;)V", "updateBadgesEffects", "Lfr/harmex/cobblebadges/common/world/badge/Badge;", "badge", "", "getIsActive", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;)Z", "getTier", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;)I", "tierUp", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;Lnet/minecraft/world/entity/player/Player;)V", "tierDown", "tier", "setTier", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;ILnet/minecraft/world/entity/player/Player;)V", "state", "activate", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;ZLnet/minecraft/world/entity/player/Player;)V", "getTotalPoints", "()I", "point", "getPoints", "(Lfr/harmex/cobblebadges/common/world/badge/Point;)I", "amount", "addPoints", "(Lnet/minecraft/world/entity/player/Player;Lfr/harmex/cobblebadges/common/world/badge/Point;I)V", "setPoints", "Ljava/util/List;", "getBadges", "()Ljava/util/List;", "Ljava/util/Map;", "()Ljava/util/Map;", "common"})
@SourceDebugExtension(value={"SMAP\nBadgeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BadgeManager.kt\nfr/harmex/cobblebadges/common/world/entity/player/BadgeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1863#2,2:152\n1863#2,2:154\n1863#2,2:156\n1863#2,2:158\n1863#2,2:162\n1863#2,2:164\n295#2,2:166\n295#2,2:168\n295#2,2:170\n295#2,2:173\n295#2,2:175\n295#2,2:177\n230#2,2:181\n230#2,2:183\n216#3,2:160\n216#3,2:179\n1#4:172\n*S KotlinDebug\n*F\n+ 1 BadgeManager.kt\nfr/harmex/cobblebadges/common/world/entity/player/BadgeManager\n*L\n29#1:152,2\n36#1:154,2\n44#1:156,2\n64#1:158,2\n82#1:162,2\n86#1:164,2\n91#1:166,2\n93#1:168,2\n95#1:170,2\n104#1:173,2\n112#1:175,2\n124#1:177,2\n31#1:181,2\n32#1:183,2\n70#1:160,2\n137#1:179,2\n*E\n"})
public final class BadgeManager {
    @NotNull
    private final List<PlayerBadge> badges;
    @NotNull
    private final Map<Point, Integer> points;

    public BadgeManager(@NotNull List<PlayerBadge> badges, @NotNull Map<Point, Integer> points) {
        Intrinsics.checkNotNullParameter(badges, (String)"badges");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.badges = badges;
        this.points = points;
    }

    @NotNull
    public final List<PlayerBadge> getBadges() {
        return this.badges;
    }

    @NotNull
    public final Map<Point, Integer> getPoints() {
        return this.points;
    }

    public BadgeManager() {
        List<PlayerBadge> list = Badges.INSTANCE.getRegistry().stream().map(arg_0 -> BadgeManager._init_$lambda$1(BadgeManager::_init_$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        this(list, new LinkedHashMap());
    }

    @NotNull
    public final BadgeManager load(@NotNull CompoundTag compoundTag, @NotNull RegistryAccess registryAccess) {
        Tag tag;
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        BadgeManager badgeManager = new BadgeManager();
        ListTag listTag = compoundTag.getList("Badges", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag, (String)"getList(...)");
        Iterable $this$forEach$iv = (Iterable)listTag;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            tag = (Tag)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)tag);
            PlayerBadge.Companion.parse(registryAccess, tag).ifPresent(arg_0 -> BadgeManager.load$lambda$6$lambda$5(arg_0 -> BadgeManager.load$lambda$6$lambda$4(badgeManager, arg_0), arg_0));
        }
        ListTag listTag2 = compoundTag.getList("Points", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag2, (String)"getList(...)");
        $this$forEach$iv = (Iterable)listTag2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            tag = (Tag)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            CompoundTag cfr_ignored_0 = (CompoundTag)tag;
            String string = ((CompoundTag)tag).getString("Point");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            Point point = Points.INSTANCE.get(string);
            int amount = ((CompoundTag)tag).getInt("Amount");
            Integer n = amount;
            badgeManager.points.put(point, n);
        }
        ListTag listTag3 = compoundTag.getList("TypePoints", 10);
        Intrinsics.checkNotNullExpressionValue((Object)listTag3, (String)"getList(...)");
        $this$forEach$iv = (Iterable)listTag3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElementalType it;
            tag = (Tag)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            CompoundTag cfr_ignored_1 = (CompoundTag)tag;
            String string = ((CompoundTag)tag).getString("Type");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            ElementalType type = ElementalTypes.INSTANCE.get(string);
            int points = ((CompoundTag)tag).getInt("Points");
            if (type == null) continue;
            boolean bl2 = false;
            Integer n = points;
            badgeManager.points.put(MiscUtilsKt.getBadgePoint(it), n);
        }
        if (compoundTag.contains("CapturePoints")) {
            badgeManager.points.put(Points.INSTANCE.getCAPTURE(), compoundTag.getInt("CapturePoints"));
        }
        if (compoundTag.contains("ShinyPoints")) {
            badgeManager.points.put(Points.INSTANCE.getSHINY(), compoundTag.getInt("ShinyPoints"));
        }
        return badgeManager;
    }

    @NotNull
    public final CompoundTag save(@NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        CompoundTag managerTag = new CompoundTag();
        ListTag badgeTiersTag = new ListTag();
        Iterable $this$forEach$iv = this.badges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerBadge it = (PlayerBadge)element$iv;
            boolean bl = false;
            badgeTiersTag.add((Object)it.save(registryAccess));
        }
        managerTag.put("Badges", (Tag)badgeTiersTag);
        ListTag pointsList = new ListTag();
        Map<Point, Integer> $this$forEach$iv2 = this.points;
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<Point, Integer>> iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Point, Integer> element$iv;
            Map.Entry<Point, Integer> entry = element$iv = iterator.next();
            boolean bl = false;
            Point point = entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            CompoundTag pointsTag = new CompoundTag();
            String string = point.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            pointsTag.putString("Point", string);
            pointsTag.putInt("Amount", amount);
            pointsList.add((Object)pointsTag);
        }
        managerTag.put("Points", (Tag)pointsList);
        return managerTag;
    }

    public final void tick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$forEach$iv = this.badges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerBadge it = (PlayerBadge)element$iv;
            boolean bl = false;
            it.tick(player);
        }
    }

    public final void updateBadgesEffects(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$forEach$iv = this.badges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerBadge it = (PlayerBadge)element$iv;
            boolean bl = false;
            it.updateBadgeEffects(player);
        }
    }

    public final boolean getIsActive(@NotNull Badge badge) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            Iterable $this$firstOrNull$iv = this.badges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerBadge it = (PlayerBadge)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)badge)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PlayerBadge playerBadge = v0;
        return playerBadge != null ? playerBadge.isActive() : false;
    }

    public final int getTier(@NotNull Badge badge) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            Iterable $this$firstOrNull$iv = this.badges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerBadge it = (PlayerBadge)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)badge)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PlayerBadge playerBadge = v0;
        return playerBadge != null ? playerBadge.getTier() : 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void tierUp(@NotNull Badge badge, @NotNull Player player) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$firstOrNull$iv = this.badges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerBadge it = (PlayerBadge)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)badge)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PlayerBadge existingBadge = v0;
        if (existingBadge != null) {
            existingBadge.tierUp(player);
        } else {
            void $this$tierUp_u24lambda_u2417;
            PlayerBadge playerBadge;
            PlayerBadge $i$f$firstOrNull = playerBadge = new PlayerBadge(badge, 0, true);
            List<PlayerBadge> list = this.badges;
            boolean bl = false;
            $this$tierUp_u24lambda_u2417.tierUp(player);
            list.add(playerBadge);
        }
        PlayerExtensionKt.setBadgeManager(player, this);
    }

    public final void tierDown(@NotNull Badge badge, @NotNull Player player) {
        block3: {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Iterable $this$firstOrNull$iv = this.badges;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PlayerBadge it = (PlayerBadge)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)badge)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PlayerBadge playerBadge = v0;
            if (playerBadge == null) break block3;
            PlayerBadge it = playerBadge;
            boolean bl = false;
            if (it.getTier() > 0) {
                it.tierDown(player);
                PlayerExtensionKt.setBadgeManager(player, this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setTier(@NotNull Badge badge, int tier, @NotNull Player player) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$firstOrNull$iv = this.badges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerBadge it = (PlayerBadge)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)badge)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PlayerBadge existingBadge = v0;
        if (existingBadge != null) {
            existingBadge.setTier(tier, player);
        } else {
            void $this$setTier_u24lambda_u2421;
            PlayerBadge playerBadge;
            PlayerBadge $i$f$firstOrNull = playerBadge = new PlayerBadge(badge, 0, true);
            List<PlayerBadge> list = this.badges;
            boolean bl = false;
            $this$setTier_u24lambda_u2421.setTier(tier, player);
            list.add(playerBadge);
        }
        PlayerExtensionKt.setBadgeManager(player, this);
    }

    /*
     * WARNING - void declaration
     */
    public final void activate(@NotNull Badge badge, boolean state, @NotNull Player player) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$firstOrNull$iv = this.badges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerBadge it = (PlayerBadge)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)badge)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PlayerBadge existingBadge = v0;
        if (existingBadge != null) {
            existingBadge.activate(state, player);
        } else {
            void $this$activate_u24lambda_u2423;
            PlayerBadge playerBadge;
            PlayerBadge $i$f$firstOrNull = playerBadge = new PlayerBadge(badge, 0, state);
            List<PlayerBadge> list = this.badges;
            boolean bl = false;
            $this$activate_u24lambda_u2423.activate(state, player);
            list.add(playerBadge);
        }
        PlayerExtensionKt.setBadgeManager(player, this);
    }

    public final int getTotalPoints() {
        int totalPoints = 0;
        Map<Point, Integer> $this$forEach$iv = this.points;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Point, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Point, Integer> element$iv;
            Map.Entry<Point, Integer> entry = element$iv = iterator.next();
            boolean bl = false;
            int amount = ((Number)entry.getValue()).intValue();
            totalPoints += amount;
        }
        return totalPoints;
    }

    public final int getPoints(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Integer n = this.points.get(point);
        return n != null ? n : 0;
    }

    public final void addPoints(@NotNull Player player, @NotNull Point point, int amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.points.put(point, this.getPoints(point) + amount);
        PlayerExtensionKt.setBadgeManager(player, this);
    }

    public static /* synthetic */ void addPoints$default(BadgeManager badgeManager, Player player, Point point, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        badgeManager.addPoints(player, point, n);
    }

    public final void setPoints(@NotNull Player player, @NotNull Point point, int amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Integer n = amount;
        this.points.put(point, n);
        PlayerExtensionKt.setBadgeManager(player, this);
    }

    private static final PlayerBadge _init_$lambda$0(Badge it) {
        Intrinsics.checkNotNull((Object)it);
        return new PlayerBadge(it, 0, true);
    }

    private static final PlayerBadge _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PlayerBadge)$tmp0.invoke(p0);
    }

    private static final Unit load$lambda$6$lambda$4(BadgeManager $badgeManager, PlayerBadge tagBadge) {
        Object element$iv2;
        block3: {
            PlayerBadge it;
            boolean $i$f$first;
            Iterable $this$first$iv;
            block2: {
                Intrinsics.checkNotNullParameter((Object)$badgeManager, (String)"$badgeManager");
                Intrinsics.checkNotNullParameter((Object)tagBadge, (String)"tagBadge");
                $this$first$iv = $badgeManager.badges;
                $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (PlayerBadge)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)tagBadge.getBadge())) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ((PlayerBadge)element$iv2).setTier(tagBadge.getTier());
            $this$first$iv = $badgeManager.badges;
            $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                it = (PlayerBadge)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBadge(), (Object)tagBadge.getBadge())) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        ((PlayerBadge)element$iv2).setActive(tagBadge.isActive());
        return Unit.INSTANCE;
    }

    private static final void load$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

