/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.mixin;

import fr.harmex.cobblebadges.common.event.CobbleBadgesEventsKt;
import fr.harmex.cobblebadges.common.network.serializer.BadgeManagerEntityDataSerializer;
import fr.harmex.cobblebadges.common.world.entity.player.BadgeManager;
import fr.harmex.cobblebadges.common.world.entity.player.CobbleBadgesPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerMixin
implements CobbleBadgesPlayer {
    @Unique
    private static final EntityDataAccessor<BadgeManager> DATA_BADGE_MANAGER_ID = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)BadgeManagerEntityDataSerializer.INSTANCE);

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    private void defineSyncedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(DATA_BADGE_MANAGER_ID, (Object)new BadgeManager());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addShopToNbt(CompoundTag compound, CallbackInfo ci) {
        compound.put("CobbleBadges", (Tag)this.cobbleBadges$getBadgeManager().save(this.cobbleBadges$self().registryAccess()));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readShopFromNbt(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("CobbleBadges")) {
            this.cobbleBadges$setBadgeManager(this.cobbleBadges$getBadgeManager().load(compound.getCompound("CobbleBadges"), this.cobbleBadges$self().registryAccess()));
        }
    }

    @Inject(method={"killedEntity"}, at={@At(value="HEAD")})
    private void killedEntity(ServerLevel level, LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        CobbleBadgesEventsKt.onPlayerKillEntity(this.cobbleBadges$self(), entity);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        this.cobbleBadges$getBadgeManager().tick(this.cobbleBadges$self());
    }

    @Override
    @Unique
    @NotNull
    public BadgeManager cobbleBadges$getBadgeManager() {
        return (BadgeManager)this.cobbleBadges$self().getEntityData().get(DATA_BADGE_MANAGER_ID);
    }

    @Override
    @Unique
    public void cobbleBadges$setBadgeManager(@NotNull BadgeManager badgeManager) {
        this.cobbleBadges$self().getEntityData().set(DATA_BADGE_MANAGER_ID, (Object)badgeManager, true);
    }

    @Unique
    private Player cobbleBadges$self() {
        return (Player)this;
    }
}

