/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.mixin;

import fr.harmex.cobblebadges.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobblebadges.common.world.badge.PlayerBadge;
import fr.harmex.cobblebadges.common.world.entity.player.BadgeManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(method={"restoreFrom"}, at={@At(value="RETURN")})
    private void restoreFrom(ServerPlayer that, boolean keepEverything, CallbackInfo ci) {
        PlayerExtensionKt.setBadgeManager((Player)this.cobbleBadges$self(), PlayerExtensionKt.getBadgeManager((Player)that));
        PlayerExtensionKt.updateBadgeEffects((Player)this.cobbleBadges$self());
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;attack(Lnet/minecraft/world/entity/Entity;)V")})
    private void applyBadgesEffects(Entity target, CallbackInfo ci) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            BadgeManager badgeManager = PlayerExtensionKt.getBadgeManager((Player)this.cobbleBadges$self());
            for (PlayerBadge playerBadge : badgeManager.getBadges()) {
                playerBadge.getBadge().onPlayerAttackLivingEntity((Player)this.cobbleBadges$self(), livingTarget, playerBadge.getTier(), playerBadge.isActive());
            }
        }
    }

    @Unique
    private ServerPlayer cobbleBadges$self() {
        return (ServerPlayer)this;
    }
}

