/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.MimicBlock;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeKnotBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RopeKnotBlockBakedModel
implements CustomBakedModel {
    private final BakedModel knot;
    private final BlockModelShaper blockModelShaper;

    public RopeKnotBlockBakedModel(BakedModel knot, ModelState state) {
        this.knot = knot;
        this.blockModelShaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        BakedModel model;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            BlockState mimic = (BlockState)data.get(ModBlockProperties.MIMIC);
            if (mimic != null && !(mimic.getBlock() instanceof MimicBlock) && !mimic.isAir()) {
                model = this.blockModelShaper.getBlockModel(mimic);
                quads.addAll(model.getQuads(mimic, side, rand));
            }
        }
        catch (Exception mimic) {
            // empty catch block
        }
        try {
            if (state != null && state.getBlock() instanceof AbstractRopeKnotBlock) {
                BlockState rope = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)ModRegistry.ROPE.get().defaultBlockState().setValue((Property)AbstractRopeKnotBlock.UP, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.UP)))).setValue((Property)AbstractRopeKnotBlock.DOWN, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.DOWN)))).setValue((Property)AbstractRopeKnotBlock.NORTH, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.NORTH)))).setValue((Property)AbstractRopeKnotBlock.SOUTH, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.SOUTH)))).setValue((Property)AbstractRopeKnotBlock.EAST, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.EAST)))).setValue((Property)AbstractRopeKnotBlock.WEST, (Comparable)((Boolean)state.getValue((Property)AbstractRopeKnotBlock.WEST)));
                model = this.blockModelShaper.getBlockModel(rope);
                quads.addAll(model.getQuads(rope, side, rand));
                quads.addAll(this.knot.getQuads(state, side, rand));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        BlockState mimic = (BlockState)data.get(ModBlockProperties.MIMIC);
        if (mimic != null && !mimic.isAir()) {
            BakedModel model = this.blockModelShaper.getBlockModel(mimic);
            try {
                return model.getParticleIcon();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.knot.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

