/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CannonChargeHud
implements LayeredDraw.Layer {
    public static final CannonChargeHud INSTANCE = new CannonChargeHud();
    protected final Minecraft mc = Minecraft.getInstance();

    protected CannonChargeHud() {
    }

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (this.mc.options.hideGui) {
            return;
        }
        if (CannonController.isActive()) {
            CannonBlockTile cannon = CannonController.access.getInternalCannon();
            this.setupOverlayRenderState();
            int screenWidth = graphics.guiWidth();
            int screenHeight = graphics.guiHeight();
            this.renderHotBar(graphics, screenWidth, screenHeight, cannon);
            CannonChargeHud.renderCrossHair(graphics, screenWidth, screenHeight);
            this.renderBar(graphics, screenWidth, screenHeight, cannon, deltaTracker.getGameTimeDeltaPartialTick(false));
            CannonChargeHud.renderTrajectoryIcons(graphics, screenWidth, screenHeight);
        } else {
            Entity cannon = this.mc.player.getVehicle();
            if (cannon instanceof CannonAccess) {
                CannonAccess be = (CannonAccess)cannon;
                this.setupOverlayRenderState();
                int screenWidth = graphics.guiWidth();
                int screenHeight = graphics.guiHeight();
                this.renderBar(graphics, screenWidth, screenHeight, be.getInternalCannon(), deltaTracker.getGameTimeDeltaPartialTick(false));
            }
        }
    }

    private static void renderTrajectoryIcons(GuiGraphics graphics, int screenWidth, int screenHeight) {
        int iconLeft = screenWidth / 2 + 96;
        int iconTop = screenHeight - 22;
        int iconW = 14;
        ResourceLocation tr = switch (CannonController.shootingMode.ordinal()) {
            case 0 -> ModTextures.CANNON_TRAJECTORY_0_SPRITE;
            case 1 -> ModTextures.CANNON_TRAJECTORY_1_SPRITE;
            default -> ModTextures.CANNON_TRAJECTORY_2_SPRITE;
        };
        graphics.blitSprite(tr, iconLeft, iconTop, iconW, iconW);
        iconLeft = screenWidth / 2 - 110;
        ResourceLocation tr2 = CannonController.showsTrajectory ? ModTextures.CANNON_TRAJECTORY_SHOWN_SPRITE : ModTextures.CANNON_TRAJECTORY_HIDDEN_SPRITE;
        graphics.blitSprite(tr2, iconLeft, iconTop, iconW, iconW);
    }

    private void renderHotBar(GuiGraphics graphics, int screenWidth, int screenHeight, CannonBlockTile cannon) {
        int left = screenWidth / 2 - 91;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, -90.0f);
        graphics.blitSprite(ModTextures.CANNON_HOTBAR_SPRITE, left, screenHeight - 22, 182, 22);
        graphics.pose().popPose();
        LocalPlayer player = Minecraft.getInstance().player;
        int yPos = screenHeight - 16 - 3;
        this.renderSlot(graphics, left + 1 + 47 + 2, yPos, (Player)player, cannon.getProjectile(), 1);
        this.renderSlot(graphics, left + 1 + 113 + 2, yPos, (Player)player, cannon.getFuel(), 1);
    }

    private void renderBar(GuiGraphics graphics, int screenWidth, int screenHeight, CannonBlockTile cannon, float partialTicks) {
        int xpBarLeft = screenWidth / 2 - 91;
        float c = 1.0f - cannon.getCooldownAnimation(partialTicks);
        int k = (int)(c * 183.0f);
        int xpBarTop = screenHeight - 32 + 3;
        graphics.blitSprite(ModTextures.CANNON_CHARGE_BACKGROUND_SPRITE, xpBarLeft, xpBarTop, 182, 5);
        float f = cannon.getFiringAnimation(partialTicks);
        float min = 0.7f;
        if (f > 0.0f) {
            f = 1.0f - f;
            float red = Math.min(f * 0.4f + min, 1.0f);
            float green = Math.min(min - f * 0.4f * min, 1.0f);
            float blue = min;
            RenderSystem.setShaderColor((float)red, (float)green, (float)(min - f * blue), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)min, (float)min, (float)min, (float)1.0f);
        }
        graphics.blitSprite(ModTextures.CANNON_CHARGE_PROGRESS_SPRITE, 183, 5, 0, 0, xpBarLeft, xpBarTop, k, 5);
        byte power = cannon.getPowerLevel();
        int color = switch (power) {
            case 2 -> 0xFFAA00;
            case 3 -> 0xFF8800;
            case 4 -> 0xFF6600;
            default -> 0xFFCC00;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String s = String.valueOf(power);
        int i1 = (screenWidth - this.mc.font.width(s)) / 2;
        int j1 = screenHeight - 31 - 4;
        graphics.drawString(this.mc.font, s, i1 + 1, j1, 0, false);
        graphics.drawString(this.mc.font, s, i1 - 1, j1, 0, false);
        graphics.drawString(this.mc.font, s, i1, j1 + 1, 0, false);
        graphics.drawString(this.mc.font, s, i1, j1 - 1, 0, false);
        graphics.drawString(this.mc.font, s, i1, j1, color, false);
    }

    private static void renderCrossHair(GuiGraphics graphics, int screenWidth, int screenHeight) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, -90.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int w = 9;
        ResourceLocation hitType = CannonController.shootingMode == ShootingMode.STRAIGHT ? ModTextures.CANNON_CROSSHAIR_AIM_SPRITE : (CannonController.trajectory == null || CannonController.trajectory.miss() ? ModTextures.CANNON_CROSSHAIR_MISS_SPRITE : ModTextures.CANNON_CROSSHAIR_HIT_SPRITE);
        graphics.blitSprite(hitType, (screenWidth - w) / 2, (screenHeight - w) / 2, w, w);
        RenderSystem.defaultBlendFunc();
        graphics.pose().popPose();
    }

    public void setupOverlayRenderState() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    private void renderSlot(GuiGraphics guiGraphics, int x, int y, Player player, ItemStack itemStack, int seed) {
        if (!itemStack.isEmpty()) {
            guiGraphics.renderItem((LivingEntity)player, itemStack, x, y, seed);
            guiGraphics.renderItemDecorations(this.mc.font, itemStack, x, y);
        }
    }
}

