/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.mehvahdjukaar.supplementaries.client.renderers.items.CageItemRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.JarBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.items.components.SoftFluidTankView;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class JarItemRenderer
extends CageItemRenderer {
    private static final RandomSource RAND = RandomSource.createNewThreadLocalInstance();

    @Override
    public void renderContent(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ItemContainerContents content;
        int count;
        super.renderContent(stack, transformType, poseStack, buffer, light, overlay);
        SoftFluidTankView fluidContent = (SoftFluidTankView)stack.get(ModComponents.SOFT_FLUID_CONTENT.get());
        if (fluidContent != null && !fluidContent.isEmpty() && (count = fluidContent.getCount()) != 0) {
            int color = fluidContent.getFlowingColor((Level)Minecraft.getInstance().level);
            JarBlockTileRenderer.renderFluid(JarItemRenderer.getVisualHeight(count, 1.0f), color, 0, fluidContent.getFluid().getStillTexture(), poseStack, buffer, light, overlay);
        }
        if ((content = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) != null) {
            RAND.setSeed(420L);
            Iterator items = content.nonEmptyItems().iterator();
            JarBlockTileRenderer.renderCookies(Minecraft.getInstance().getItemRenderer(), poseStack, buffer, RAND, light, overlay, () -> items.hasNext() ? (ItemStack)items.next() : ItemStack.EMPTY);
        }
    }

    private static float getVisualHeight(float count, float maxHeight) {
        return maxHeight * count / (float)CommonConfigs.Functional.JAR_CAPACITY.get().intValue();
    }
}

