/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.supplementaries.client.TextUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestMapDataPacket;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class NoticeBoardBlockTileRenderer
implements BlockEntityRenderer<NoticeBoardBlockTile> {
    private final ItemRenderer itemRenderer;
    private final MapRenderer mapRenderer;
    private final Font font;
    private final Camera camera;
    private static final float PAPER_X_MARGIN = 0.1875f;
    private static final float PAPER_Y_MARGIN = 0.125f;

    public NoticeBoardBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.getInstance();
        this.itemRenderer = minecraft.getItemRenderer();
        this.mapRenderer = minecraft.gameRenderer.getMapRenderer();
        this.font = context.getFont();
        this.camera = minecraft.gameRenderer.getMainCamera();
    }

    public int getFrontLight(Level world, BlockPos pos, Direction dir) {
        return LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)pos.relative(dir));
    }

    public void render(NoticeBoardBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int overlay) {
        if (!tile.shouldSkipTileRenderer()) {
            Level level = tile.getLevel();
            if (level == null) {
                return;
            }
            ItemStack stack = tile.getDisplayedItem();
            if (stack.isEmpty()) {
                return;
            }
            Direction dir = tile.getDirection();
            float yaw = -dir.toYRot();
            BlockPos pos = tile.getBlockPos();
            LOD lod = LOD.at((BlockEntity)tile);
            if (lod.isPlaneCulled(dir, 0.0f, 0.0f)) {
                return;
            }
            int frontLight = this.getFrontLight(level, pos, dir);
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(RotHlpr.rot((int)((int)yaw)));
            poseStack.translate(0.0, 0.0, 0.5);
            NoticeBoardBlockTileRenderer.renderNoticeBoardContent(this.mapRenderer, this.font, this.itemRenderer, tile, poseStack, buffer, frontLight, overlay, stack, dir, lod);
            poseStack.popPose();
        }
    }

    public static void renderNoticeBoardContent(MapRenderer mapRenderer, Font font, ItemRenderer itemRenderer, NoticeBoardBlockTile tile, PoseStack poseStack, MultiBufferSource buffer, int frontLight, int overlay, ItemStack stack, Direction dir, LOD lod) {
        if (tile.isGlowing()) {
            frontLight = 0xF000F0;
        }
        if (stack.getItem() instanceof ComplexItem) {
            MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
            MapItemSavedData mapData = MapItem.getSavedData((MapId)mapId, (Level)tile.getLevel());
            if (mapData != null) {
                poseStack.pushPose();
                poseStack.translate(0.0, 0.0, 0.008);
                poseStack.scale(0.0078125f, -0.0078125f, -0.0078125f);
                poseStack.translate(-64.0, -64.0, 0.0);
                mapRenderer.render(poseStack, buffer, mapId, mapData, true, frontLight);
                poseStack.popPose();
            } else {
                LocalPlayer player = Minecraft.getInstance().player;
                NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundRequestMapDataPacket(tile.getBlockPos(), player.getUUID()));
            }
            return;
        }
        Filterable<String> text = tile.getText();
        if (text != null) {
            String page = (String)text.get(Minecraft.getInstance().isTextFilteringEnabled());
            if (!lod.isNearMed()) {
                return;
            }
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, 0.008);
            if (MiscUtils.FESTIVITY.isAprilsFool()) {
                float d0 = ColorUtils.getShading((Vector3f)dir.step());
                TextUtils.renderBeeMovie(poseStack, buffer, frontLight, font, d0);
                poseStack.popPose();
                return;
            }
            String bookName = tile.getItem(0).getHoverName().getString().toLowerCase(Locale.ROOT);
            if (bookName.equals("credits")) {
                float d0 = ColorUtils.getShading((Vector3f)dir.step());
                TextUtils.renderCredits(poseStack, buffer, frontLight, font, d0);
                poseStack.popPose();
                return;
            }
            TextUtil.RenderProperties textProperties = tile.getTextHolder().computeRenderProperties(frontLight, dir.step(), () -> ((LOD)lod).isVeryNear());
            if (tile.needsVisualUpdate()) {
                NoticeBoardBlockTileRenderer.updateAndCacheLines(font, tile, page, textProperties);
            }
            List<FormattedCharSequence> rendererLines = tile.getCachedLines();
            float scale = tile.getFontScale();
            poseStack.scale(scale, -scale, scale);
            int numberOfLines = rendererLines.size();
            boolean centered = ClientConfigs.Blocks.NOTICE_BOARD_CENTERED_TEXT.get();
            boolean missingno = bookName.equals("missingno");
            for (int lin = 0; lin < numberOfLines; ++lin) {
                FormattedCharSequence str = rendererLines.get(lin);
                float dx = centered ? (float)(-font.width(str)) / 2.0f + 0.5f : -0.3125f / scale;
                float dy = (1.0f / scale - (float)(8 * numberOfLines)) / 2.0f + 0.5f;
                Matrix4f pose = poseStack.last().pose();
                if (missingno) {
                    font.drawInBatch("\u00a7ka", dx, dy + (float)(8 * lin), textProperties.textColor(), false, pose, buffer, Font.DisplayMode.NORMAL, 0, frontLight);
                    continue;
                }
                if (textProperties.outline()) {
                    font.drawInBatch8xOutline(str, dx, dy + (float)(8 * lin), textProperties.textColor(), textProperties.darkenedColor(), pose, buffer, textProperties.light());
                    continue;
                }
                font.drawInBatch(str, dx, dy + (float)(8 * lin), textProperties.darkenedColor(), false, pose, buffer, Font.DisplayMode.NORMAL, 0, textProperties.light());
            }
            poseStack.popPose();
            return;
        }
        Material pattern = tile.getCachedPattern();
        if (pattern != null) {
            VertexConsumer builder = pattern.buffer(buffer, RenderType::entityNoOutline);
            int i = tile.getDyeColor().getTextColor();
            float scale = 0.5f;
            int b = (int)(scale * (float)FastColor.ARGB32.blue((int)i));
            int g = (int)(scale * (float)FastColor.ARGB32.green((int)i));
            int r = (int)(scale * (float)FastColor.ARGB32.red((int)i));
            int lu = VertexUtil.lightU((int)frontLight);
            int lv = VertexUtil.lightV((int)frontLight);
            poseStack.translate(0.0f, 0.0f, 0.008f);
            VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)-0.4375f, (float)-0.4375f, (float)0.4375f, (float)0.4375f, (float)0.15625f, (float)0.0625f, (float)0.59375f, (float)0.9375f, (int)r, (int)g, (int)b, (int)255, (int)lu, (int)lv);
        } else if (!tile.isNormalItem()) {
            BakedModel model = itemRenderer.getModel(stack, tile.getLevel(), null, 0);
            poseStack.translate(0.0, 0.0, 0.015675);
            poseStack.scale(-0.5f, 0.5f, -0.5f);
            itemRenderer.render(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, frontLight, overlay, model);
        }
    }

    private static void updateAndCacheLines(Font font, NoticeBoardBlockTile tile, String page, TextUtil.RenderProperties textProperties) {
        float paperWidth = 0.625f;
        float paperHeight = 0.75f;
        FormattedText text = TextUtil.parseText((String)page, (HolderLookup.Provider)tile.getLevel().registryAccess());
        if (text instanceof MutableComponent) {
            MutableComponent mc = (MutableComponent)text;
            text = mc.setStyle(textProperties.style());
        } else {
            text = Component.literal((String)page).setStyle(textProperties.style());
        }
        Pair p = TextUtil.fitLinesToBox((Font)font, (FormattedText)text, (float)paperWidth, (float)paperHeight);
        tile.setFontScale(((Float)p.getSecond()).floatValue());
        tile.setCachedPageLines((List)p.getFirst());
    }
}

