/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.OpenableContainerBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.SafeContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.components.SafeOwner;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SafeBlockTile
extends OpenableContainerBlockTile
implements IOwnerProtected,
IKeyLockable {
    @Nullable
    private String password = null;
    private String ownerName = null;
    private UUID owner = null;

    public SafeBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SAFE_TILE.get(), pos, state, 27);
    }

    public boolean handleAction(Player player, ItemStack stack) {
        Item item = stack.getItem();
        boolean cleared = false;
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if ((item == Items.TRIPWIRE_HOOK || stack.is(ModTags.KEYS)) && (this.isOwnedBy(player) || this.isNotOwnedBy(player) && player.isCreative())) {
                cleared = true;
            }
        } else if (player.isShiftKeyDown() && (player.isCreative() || this.getKeyStatus(stack).isCorrect())) {
            cleared = true;
        }
        if (cleared) {
            this.clearPassword();
            this.onPasswordCleared(player, this.worldPosition);
            return true;
        }
        BlockPos frontPos = this.worldPosition.relative((Direction)this.getBlockState().getValue((Property)SafeBlock.FACING));
        if (!this.level.getBlockState(frontPos).isRedstoneConductor((BlockGetter)this.level, frontPos)) {
            if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
                UUID owner = this.getOwner();
                if (owner == null) {
                    owner = player.getUUID();
                    this.setOwner(owner);
                }
                if (!owner.equals(player.getUUID())) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}), true);
                    if (!player.isCreative()) {
                        return true;
                    }
                }
            } else {
                String key = this.getPassword();
                if (key == null) {
                    String newKey = IKeyLockable.getKeyPassword(stack);
                    if (newKey != null) {
                        this.setPassword(newKey);
                        this.onKeyAssigned(this.level, this.worldPosition, player, newKey);
                        return true;
                    }
                } else if (!this.canPlayerOpen(player, true) && !player.isCreative()) {
                    return true;
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PlatHelper.openCustomMenu((ServerPlayer)sp, (BlockEntity)this);
            }
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return true;
    }

    @Override
    public IKeyLockable.KeyStatus getKeyInInventoryStatus(Player player) {
        if (player.isCreative()) {
            return IKeyLockable.KeyStatus.CORRECT_KEY;
        }
        return IKeyLockable.super.getKeyInInventoryStatus(player);
    }

    public boolean canPlayerOpen(Player player, boolean feedbackMessage) {
        if (player == null || player.isCreative()) {
            return true;
        }
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.isNotOwnedBy(player)) {
                if (feedbackMessage) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}), true);
                }
                return false;
            }
        } else {
            IKeyLockable.KeyStatus status = this.getKeyInInventoryStatus(player);
            if (feedbackMessage) {
                status.sendMessage(player, feedbackMessage ? "safe" : null);
            }
            return status.isCorrect();
        }
        return true;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void clearPassword() {
        this.ownerName = null;
        this.owner = null;
        this.password = null;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        if (this.level != null) {
            if (owner != null) {
                Player p = this.level.getPlayerByUUID(owner);
                if (p != null) {
                    this.ownerName = p.getName().getString();
                }
                this.owner = owner;
            }
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean canOpen(Player player) {
        if (!super.canOpen(player)) {
            return false;
        }
        return this.canPlayerOpen(player, false);
    }

    public Component getDisplayName() {
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.ownerName != null && this.shouldShowPassword()) {
                return Component.translatable((String)"gui.supplementaries.safe.name", (Object[])new Object[]{this.ownerName, super.getDisplayName()});
            }
        } else if (this.password != null && this.shouldShowPassword()) {
            return Component.translatable((String)"gui.supplementaries.safe.password", (Object[])new Object[]{this.password, super.getDisplayName()});
        }
        return super.getDisplayName();
    }

    protected void playOpenSound(BlockState state) {
        Vec3i vec3i = ((Direction)state.getValue((Property)SafeBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.65f);
    }

    protected void playCloseSound(BlockState state) {
        Vec3i vec3i = ((Direction)state.getValue((Property)SafeBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.65f);
    }

    protected void updateBlockState(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)SafeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.owner = tag.contains("Owner") ? tag.getUUID("Owner") : null;
        if (tag.contains("OwnerName")) {
            this.ownerName = tag.getString("OwnerName");
        } else {
            this.owner = null;
        }
        this.password = tag.contains("Password") ? tag.getString("Password") : null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveOwner(tag);
        if (this.ownerName != null) {
            tag.putString("OwnerName", this.ownerName);
        }
        if (this.password != null) {
            tag.putString("Password", this.password);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        SafeOwner safeOwner = SafeOwner.of(this.owner, this.ownerName, this.password);
        if (safeOwner != null) {
            components.set(ModComponents.SAFE_OWNER.get(), (Object)safeOwner);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        SafeOwner safeOwner = (SafeOwner)componentInput.get(ModComponents.SAFE_OWNER.get());
        if (safeOwner != null) {
            this.owner = safeOwner.owner();
            this.ownerName = safeOwner.ownerName();
            this.password = safeOwner.password();
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("Owner");
        tag.remove("OwnerName");
        tag.remove("Password");
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return MiscUtils.isAllowedInShulker(stack, this.getLevel()) && !this.getKeyStatus(stack).isCorrect();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv) {
        if (inv.player.isSpectator()) {
            return null;
        }
        return new SafeContainerMenu(id, inv, this);
    }
}

