/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeKnotBlock;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.common.utils.RopeHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RopeArrowEntity
extends AbstractArrow {
    private BlockPos prevPlacedPos = null;

    public RopeArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public RopeArrowEntity(double x, double y, double z, Level level, ItemStack projectile, @Nullable ItemStack weapon) {
        super(ModEntities.ROPE_ARROW.get(), x, y, z, level, projectile, weapon);
    }

    public RopeArrowEntity(LivingEntity livingEntity, Level level, ItemStack projectile, @Nullable ItemStack weapon) {
        super(ModEntities.ROPE_ARROW.get(), livingEntity, level, projectile, weapon);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return PlatHelper.getEntitySpawnPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public int getCharges() {
        return (Integer)this.getPickupItemStackOrigin().getOrDefault(ModComponents.CHARGES.get(), (Object)0);
    }

    private void removeCharges(int amount) {
        int newCharges = this.getCharges() - amount;
        this.getPickupItemStackOrigin().set(ModComponents.CHARGES.get(), (Object)newCharges);
        this.level().playSound(null, this.prevPlacedPos, SoundEvents.LEASH_KNOT_PLACE, SoundSource.BLOCKS, 0.2f, 1.7f);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.prevPlacedPos != null) {
            compound.put("PrevPlacedPos", NbtUtils.writeBlockPos((BlockPos)this.prevPlacedPos));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("PrevPlacedPos")) {
            this.prevPlacedPos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"PrevPlacedPos").orElse(null);
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return ModRegistry.ROPE_ARROW_ITEM.get().getDefaultInstance();
    }

    protected void onHitBlock(BlockHitResult rayTraceResult) {
        super.onHitBlock(rayTraceResult);
        Block ropeBlock = CommonConfigs.getSelectedRope();
        if (ropeBlock == null) {
            return;
        }
        if (this.getCharges() <= 0) {
            return;
        }
        Level level = this.level();
        if (!level.isClientSide) {
            this.prevPlacedPos = null;
            Entity entity = this.getOwner();
            Player player = null;
            if (!(entity instanceof Mob) || PlatHelper.isMobGriefingOn((Level)level, (Entity)this)) {
                BlockState state;
                BlockState knotState;
                ModBlockProperties.PostType knotType;
                BlockPos hitPos = rayTraceResult.getBlockPos();
                if (entity instanceof Player) {
                    Player pl;
                    player = pl = (Player)entity;
                    if (CompatHandler.FLAN && !FlanCompat.canPlace(pl, hitPos)) {
                        return;
                    }
                }
                BlockState hitState = level.getBlockState(hitPos);
                Block hitBlock = hitState.getBlock();
                if (ropeBlock == ModRegistry.ROPE.get() && (knotType = ModBlockProperties.PostType.get(hitState)) != null && (knotState = AbstractRopeKnotBlock.convertToRopeKnot(knotType, hitState, level, hitPos)) != null) {
                    this.prevPlacedPos = ((Direction.Axis)knotState.getValue(AbstractRopeKnotBlock.AXIS)).isVertical() ? hitPos.relative(rayTraceResult.getDirection()).above() : hitPos;
                    this.removeCharges(1);
                    return;
                }
                if (hitBlock == ropeBlock && RopeHelper.addRopeDown(hitPos, level, player, InteractionHand.MAIN_HAND, ropeBlock)) {
                    this.prevPlacedPos = hitPos;
                    this.removeCharges(1);
                    return;
                }
                hitBlock = level.getBlockState(hitPos = hitPos.relative(rayTraceResult.getDirection())).getBlock();
                if (hitBlock == ropeBlock && RopeHelper.addRopeDown(hitPos, level, player, InteractionHand.MAIN_HAND, ropeBlock)) {
                    this.prevPlacedPos = hitPos;
                    this.removeCharges(1);
                    return;
                }
                ItemStack ropes = new ItemStack((ItemLike)ropeBlock);
                BlockPlaceContext context = new BlockPlaceContext(level, player, InteractionHand.MAIN_HAND, ropes, rayTraceResult);
                if (context.canPlace() && (state = ItemsUtil.getPlacementState(context, ropeBlock)) != null) {
                    level.setBlock(context.getClickedPos(), state, 11);
                    this.prevPlacedPos = context.getClickedPos();
                    this.removeCharges(1);
                }
            }
        }
    }

    private void continueUnwindingRope() {
        BlockPos hitPos;
        Player player1;
        Block ropeBlock = CommonConfigs.getSelectedRope();
        if (ropeBlock == null) {
            return;
        }
        Player player = null;
        Entity entity = this.getOwner();
        if (entity instanceof Player && (player1 = (Player)entity).mayBuild()) {
            player = player1;
        }
        if (RopeHelper.addRopeDown((hitPos = this.prevPlacedPos).below(), this.level(), player, InteractionHand.MAIN_HAND, ropeBlock)) {
            this.prevPlacedPos = hitPos.below();
            this.removeCharges(1);
        } else {
            this.prevPlacedPos = null;
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.getCharges() != 0 && this.prevPlacedPos != null) {
            this.continueUnwindingRope();
        }
    }
}

