/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class AbandonShipGoal
extends Goal {
    private final Mob mob;
    private final int ticksToDismount;
    private int tickOnEdge = 0;

    public AbandonShipGoal(Mob mob, int ticksToDismount) {
        this.mob = mob;
        this.ticksToDismount = ticksToDismount;
    }

    public AbandonShipGoal(Mob mob) {
        this(mob, 15);
    }

    public boolean canUse() {
        Entity vehicle = this.mob.getVehicle();
        if (vehicle != null && vehicle.getType().is(ModTags.CAN_DISMOUNT_FROM)) {
            LivingEntity captain = vehicle.getControllingPassenger();
            if (captain != null && captain != this.mob && captain.getType().is(ModTags.CAN_STEER_BOAT)) {
                return false;
            }
            if (!vehicle.isInWater()) {
                return true;
            }
            if (vehicle.onGround()) {
                return true;
            }
            PathNavigation nav = this.mob.getNavigation();
            return nav.isStuck() || !nav.isDone() && nav.getPath().getNextNode().type != PathType.WATER;
        }
        return false;
    }

    public void start() {
        this.tickOnEdge = 0;
    }

    public void stop() {
        this.tickOnEdge = 0;
    }

    public void tick() {
        if (this.tickOnEdge++ >= this.ticksToDismount) {
            this.doStopRiding();
        }
    }

    protected void doStopRiding() {
        EnderMan em;
        Level level;
        Vec3 oldPos = this.mob.position();
        this.mob.stopRiding();
        Mob mob = this.mob;
        if (mob instanceof EnderMan && !(level = (em = (EnderMan)mob).level()).isClientSide() && em.isAlive()) {
            em.setPos(oldPos);
            RandomSource random = em.getRandom();
            double x = em.getX() + (random.nextDouble() - 0.5) * 64.0;
            double y = em.getY() + (double)(random.nextInt(64) - 32);
            double z = em.getZ() + (random.nextDouble() - 0.5) * 64.0;
            boolean bl3 = em.randomTeleport(x, y, z, true);
            if (bl3) {
                level.gameEvent((Holder)GameEvent.TELEPORT, oldPos, GameEvent.Context.of((Entity)em));
                if (!em.isSilent()) {
                    level.playSound(null, em.xo, em.yo, em.zo, SoundEvents.ENDERMAN_TELEPORT, em.getSoundSource(), 1.0f, 1.0f);
                    em.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
        }
    }
}

