/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import java.util.EnumSet;
import java.util.stream.Stream;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.goals.PlundererAICommon;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class UseCannonBlockGoal
extends MoveToBlockGoal {
    private final int minCannonRange;
    private final int maxStayTime;
    private final int maxGoToTime;
    private final int maxTimeWithoutShooting;
    private final int goalInterval;
    private final int shootingCooldownMin;
    private final int shootingCooldownMax;
    private final int searchRange;
    private int igniteCannonCooldown = 0;
    private int atCannonTicks = 0;
    private int ticksSinceShot = 0;
    private CannonBlockTile lastTile = null;

    public UseCannonBlockGoal(PathfinderMob mob, double speedModifier, int searchRange, int maxTimeWithoutShooting, int minCannonRange, int maxStayTime, int maxGoToTime, int shootingCooldownMax, int shootingCooldownMin, int goalInterval) {
        super(mob, speedModifier, searchRange);
        this.searchRange = searchRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.minCannonRange = minCannonRange;
        this.maxStayTime = maxStayTime;
        this.maxGoToTime = maxGoToTime;
        this.maxTimeWithoutShooting = maxTimeWithoutShooting;
        this.goalInterval = goalInterval;
        this.shootingCooldownMin = shootingCooldownMin;
        this.shootingCooldownMax = shootingCooldownMax;
    }

    public UseCannonBlockGoal(PathfinderMob mob, double speedModifier, int searchRange) {
        this(mob, speedModifier, searchRange, 300, 16, 1000, 1200, 90, 80, 50);
    }

    public double acceptedDistance() {
        return 1.75;
    }

    protected BlockPos getMoveToTarget() {
        return this.blockPos;
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.lastTile != null) {
            this.lastTile.setCurrentUser(null);
            this.lastTile = null;
        }
    }

    public boolean canContinueToUse() {
        if (this.mob.isPassenger() || !PlundererAICommon.hasValidTargetInCannonRange((Mob)this.mob, this.minCannonRange)) {
            return false;
        }
        if (this.isReachedTarget() && this.ticksSinceShot > this.maxTimeWithoutShooting) {
            return false;
        }
        return this.atCannonTicks <= this.maxStayTime && this.tryTicks <= this.maxGoToTime && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos);
    }

    public boolean canUse() {
        if (this.mob.isPassenger() || !PlundererAICommon.hasValidTargetInCannonRange((Mob)this.mob, this.minCannonRange)) {
            return false;
        }
        return super.canUse();
    }

    protected int nextStartTick(PathfinderMob creature) {
        return UseCannonBlockGoal.reducedTickDelay((int)this.goalInterval);
    }

    protected boolean findNearestBlock() {
        PoiManager poiManager = ((ServerLevel)this.mob.level()).getPoiManager();
        Stream stream = poiManager.getInRange(holder -> holder.value() == ModEntities.USABLE_CANNON.get(), this.mob.blockPosition(), this.searchRange, PoiManager.Occupancy.ANY);
        for (PoiRecord p : stream.toList()) {
            BlockPos pos = p.getPos();
            if (!this.mob.isWithinRestriction(pos) || !this.isValidTarget((LevelReader)this.mob.level(), pos)) continue;
            this.blockPos = pos;
            return true;
        }
        return false;
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        CannonBlockTile cb;
        BlockEntity be = level.getBlockEntity(pos);
        return be instanceof CannonBlockTile && (cb = (CannonBlockTile)be).canBeUsedBy(pos, (Entity)this.mob) && cb.hasSomeFuelAndProjectiles();
    }

    protected void moveMobToBlock() {
        BlockPos actualTarget = this.getMoveToTarget();
        this.mob.getNavigation().moveTo((double)actualTarget.getX() + 0.5, (double)actualTarget.getY(), (double)actualTarget.getZ() + 0.5, this.speedModifier);
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            boolean between;
            CannonBlockTile cannonTile;
            Level level = this.mob.level();
            this.lastTile = cannonTile = (CannonBlockTile)level.getBlockEntity(this.blockPos);
            this.lastTile.setCurrentUser(this.mob.getUUID());
            ++this.atCannonTicks;
            ++this.ticksSinceShot;
            if (this.igniteCannonCooldown > 0) {
                --this.igniteCannonCooldown;
            }
            boolean canShoot = this.igniteCannonCooldown <= 0;
            Vec3 center = Vec3.atCenterOf((Vec3i)cannonTile.getBlockPos());
            Vec3 targetPos = this.mob.getTarget().position();
            Vec3 myPos = this.mob.position();
            Vec3 toTarget = targetPos.subtract(center);
            Vec3 toMe = myPos.subtract(center);
            double dot = toTarget.normalize().dot(toMe.normalize());
            double t = toMe.dot(toTarget.normalize());
            boolean bl = between = t > 0.0 && t < toTarget.length();
            if (!this.mob.getNavigation().isDone()) {
                // empty if block
            }
            if (dot > 0.6 && between) {
                Direction wantedDir = Direction.getNearest((double)(-toTarget.x), (double)(-toTarget.y), (double)(-toTarget.z));
                this.moveAroundCannon(wantedDir);
                return;
            }
            this.mob.getLookControl().setLookAt((Entity)this.mob.getTarget());
            if (PlundererAICommon.aimCannonAndShoot(cannonTile.selfAccess, (Mob)this.mob, this.mob.getTarget(), canShoot)) {
                this.igniteCannonCooldown = this.shootCooldown();
                this.ticksSinceShot = 0;
            }
        }
    }

    protected void moveAroundCannon(Direction wantedDir) {
        BlockPos cannonPos = this.getMoveToTarget();
        BlockPos targetPos = cannonPos.relative(wantedDir);
        this.mob.getNavigation().moveTo((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5, this.speedModifier);
    }

    private int shootCooldown() {
        return Mth.randomBetweenInclusive((RandomSource)this.mob.getRandom(), (int)this.shootingCooldownMin, (int)this.shootingCooldownMax);
    }
}

