/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FiniteLiquidBlock
extends Block
implements BucketPickup,
LiquidBlockContainer {
    public static final VoxelShape STABLE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final IntegerProperty MISSING_LEVELS = BlockStateProperties.LEVEL;
    private final List<FluidState> stateCache;
    private final FiniteFluid fluid;
    public final int maxLevel;
    private boolean fluidStateCacheInitialized = false;

    public FiniteLiquidBlock(Supplier<? extends FiniteFluid> supplier, BlockBehaviour.Properties arg) {
        super(arg);
        this.fluid = supplier.get();
        this.maxLevel = this.fluid.maxLayers;
        assert (this.maxLevel <= 16);
        this.stateCache = Lists.newArrayList();
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MISSING_LEVELS, (Comparable)Integer.valueOf(0)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
    }

    public FluidState getFluidState(BlockState state) {
        int i = (Integer)state.getValue((Property)MISSING_LEVELS);
        if (!this.fluidStateCacheInitialized) {
            this.initFluidStateCache();
        }
        return this.stateCache.get(Math.min(i, this.maxLevel));
    }

    protected synchronized void initFluidStateCache() {
        if (!this.fluidStateCacheInitialized) {
            this.stateCache.add(this.fluid.makeState(this.maxLevel));
            for (int i = 1; i < this.maxLevel; ++i) {
                this.stateCache.add(this.fluid.makeState(this.maxLevel - i));
            }
            this.fluidStateCacheInitialized = true;
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return context.isAbove(STABLE_SHAPE, pos, true) && (Integer)state.getValue((Property)MISSING_LEVELS) == 0 && context.canStandOnFluid(level.getFluidState(pos.above()), state.getFluidState()) ? STABLE_SHAPE : Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getFluidState().isRandomlyTicking();
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        state.getFluidState().randomTick((Level)level, pos, random);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction direction) {
        return adjacentBlockState.getFluidState().getType().isSame((Fluid)this.fluid);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public List<ItemStack> getDrops(BlockState arg, LootParams.Builder arg2) {
        return Collections.emptyList();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, state.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)level));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (state.getFluidState().isSource() || neighborState.getFluidState().isSource()) {
            level.scheduleTick(currentPos, state.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        level.scheduleTick(pos, state.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)level));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MISSING_LEVELS});
    }

    public ItemStack pickupBlock(Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        AtomicInteger currentLevel = new AtomicInteger(state.getFluidState().getAmount());
        HashMap<BlockPos, Integer> posList = new HashMap<BlockPos, Integer>();
        posList.put(pos, 0);
        this.findConnectedFluids(level, pos, posList, currentLevel);
        if (currentLevel.get() < this.maxLevel) {
            return ItemStack.EMPTY;
        }
        for (Map.Entry entry : posList.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value == 0) {
                level.setBlock(p, Blocks.AIR.defaultBlockState(), 11);
                continue;
            }
            level.setBlock(p, this.fluid.makeState(value).createLegacyBlock(), 11);
        }
        return new ItemStack((ItemLike)this.fluid.getBucket());
    }

    private void findConnectedFluids(LevelAccessor level, BlockPos pos, Map<BlockPos, Integer> remainders, AtomicInteger currentLevel) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.offer(pos);
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                int l;
                BlockState state;
                if (currentLevel.get() >= this.maxLevel) {
                    return;
                }
                BlockPos newPos = currentPos.relative(direction);
                if (remainders.containsKey(newPos) || !((state = level.getBlockState(newPos)).getBlock() instanceof FiniteLiquidBlock) || (l = state.getFluidState().getAmount()) <= 0) continue;
                currentLevel.addAndGet(l);
                remainders.put(newPos, Math.max(0, currentLevel.get() - this.maxLevel));
                queue.offer(newPos);
            }
        }
    }

    public Optional<SoundEvent> getPickupSound() {
        return this.fluid.getPickupSound();
    }

    public boolean canPlaceLiquid(Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return fluid == this.fluid;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        int currentLevel = (Integer)state.getValue((Property)MISSING_LEVELS);
        level.setBlock(pos, (BlockState)state.setValue((Property)MISSING_LEVELS, (Comparable)((Integer)fluidState.createLegacyBlock().getValue((Property)MISSING_LEVELS))), 3);
        return false;
    }
}

