/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteLiquidBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.SoulFiredCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FlammableLiquidBlock
extends FiniteLiquidBlock
implements ILightable {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public final VoxelShape[] interactionShapes = (VoxelShape[])IntStream.range(0, 16).mapToObj(i -> FlammableLiquidBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)Math.max(0.0f, 15.0f * (1.0f - (float)i / (float)this.maxLevel)), (double)16.0)).toArray(VoxelShape[]::new);

    public FlammableLiquidBlock(Supplier<? extends FiniteFluid> supplier, BlockBehaviour.Properties arg, int baseLight) {
        super(supplier, arg.lightLevel(state -> (Integer)state.getValue((Property)AGE) > baseLight ? 15 : 0));
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE});
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return FireStage.fromAge((Integer)state.getValue((Property)AGE)).isBurning() ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
    }

    @Override
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(state, world, pos, oldState, moving);
        if (!oldState.is(state.getBlock()) && world instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)world;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
    }

    protected int getReactToFireDelay() {
        return 2;
    }

    protected int getFireTickDelay(RandomSource random) {
        return 30 + random.nextInt(10);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.lightableInteractWithPlayerItem(state, level, pos, player, hand, stack);
    }

    public boolean tryLightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor level, ILightable.FireSoundType fireSourceType) {
        if (FlammableLiquidBlock.shouldNotHaveFire(state, pos, level)) {
            return false;
        }
        boolean success = super.tryLightUp(player, state, pos, level, fireSourceType);
        if (success && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            MiscUtils.scheduleTickOverridingExisting(sl, pos, this, this.getReactToFireDelay());
        }
        return success;
    }

    public static boolean shouldNotHaveFire(BlockState state, BlockPos pos, LevelAccessor levelAccessor) {
        return levelAccessor.getFluidState(pos.above()).is(state.getFluidState().getType());
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState newShape = super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        if (this.isLitUp(state, (BlockGetter)level, currentPos) && FlammableLiquidBlock.shouldNotHaveFire(newShape, currentPos, level)) {
            return (BlockState)newShape.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
        }
        return newShape;
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        return FireStage.fromAge((Integer)state.getValue((Property)AGE)).isBurning();
    }

    public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, @Nullable Entity e, boolean lit) {
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(lit ? 1 : 0)), 3);
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.isLitUp(state, level, pos) ? this.interactionShapes[(Integer)state.getValue((Property)MISSING_LEVELS)] : super.getShape(state, level, pos, context);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.interactionShapes[(Integer)state.getValue((Property)MISSING_LEVELS)];
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult pHit, Projectile projectile) {
        BlockPos pos = pHit.getBlockPos();
        this.lightableInteractWithEntity(level, state, (Entity)projectile, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        boolean shouldBeOnFire = false;
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!GunpowderBlock.canBlockLightMeOnFire((LevelAccessor)level, pos.relative(direction))) continue;
            shouldBeOnFire = true;
            break;
        }
        return (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(shouldBeOnFire ? 1 : 0));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            this.lightableInteractWithEntity(level, state, (Entity)projectile, pos);
        }
        if (this.isLitUp(state, (BlockGetter)level, pos)) {
            if (!entity.fireImmune()) {
                if (CompatHandler.SOUL_FIRED) {
                    SoulFiredCompat.setOnFire(entity, 8);
                } else {
                    entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 1);
                    if (entity.getRemainingFireTicks() == 0) {
                        entity.setRemainingFireTicks(8);
                    }
                }
            }
            entity.hurt(level.damageSources().inFire(), 1.0f);
        } else if (entity.isOnFire()) {
            this.tryLightUp(entity, state, pos, (LevelAccessor)level, ILightable.FireSoundType.FLAMING_ARROW);
        }
        Integer duration = CommonConfigs.Functional.FLAMMABLE_FROM_LUMISENE.get();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (duration > 0) {
                le.addEffect(new MobEffectInstance(ModRegistry.FLAMMABLE.getHolder(), duration.intValue(), 0, false, false));
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide() && this.isLitUp(state, (BlockGetter)level, pos)) {
            level.levelEvent(null, 1009, pos, 0);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.isLitUp(state, (BlockGetter)level, pos)) {
            return;
        }
        if (random.nextInt(24) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
        int age = (Integer)state.getValue((Property)AGE);
        double baseY = (float)Math.max((age + 1) / 5, 1) * 0.5f;
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble() * 0.25 + baseY;
            double z = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!SuppPlatformStuff.canCatchFire(level, pos.relative(direction), direction)) continue;
            for (int i = 0; i < 2; ++i) {
                Vector3f step = direction.step();
                double x = (double)pos.getX() + 0.5 + (double)step.x * 0.5 + (step.x == 0.0f ? random.nextDouble() - 0.5 : (double)(-step.x) * random.nextDouble() * 0.1);
                double y = (double)pos.getY() + 0.5 + (double)step.y * 0.5 + (step.y == 0.0f ? random.nextDouble() - 0.5 : (double)(-step.y) * random.nextDouble() * 0.1);
                double z = (double)pos.getZ() + 0.5 + (double)step.z * 0.5 + (step.z == 0.0f ? random.nextDouble() - 0.5 : (double)(-step.z) * random.nextDouble() * 0.1);
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        FireStage stage = FireStage.fromAge(age);
        boolean fireTickOn = level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK);
        if (stage == FireStage.OFF) {
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN || !GunpowderBlock.canBlockLightMeOnFire((LevelAccessor)level, pos.relative(dir))) continue;
                this.tryLightUp(null, state, pos, (LevelAccessor)level, ILightable.FireSoundType.FLAMING_ARROW);
                return;
            }
            return;
        }
        if (stage == FireStage.RISING) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            MiscUtils.scheduleTickOverridingExisting(level, pos, this, this.getReactToFireDelay());
            return;
        }
        if (stage == FireStage.DYING) {
            int missingLayers = (Integer)state.getValue((Property)MISSING_LEVELS);
            if (missingLayers == 15) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                if (SuppPlatformStuff.canCatchFire((Level)level, pos.below(), Direction.UP) && fireTickOn) {
                    int newAge = random.nextInt(8);
                    level.setBlock(pos, FlammableLiquidBlock.getFireDelegate().getStateWithAge((LevelAccessor)level, pos, newAge), 3);
                }
                return;
            }
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)MISSING_LEVELS, (Comparable)Integer.valueOf(missingLayers + 1))).setValue((Property)AGE, (Comparable)Integer.valueOf(4)));
            level.scheduleTick(pos, (Block)this, this.getFireTickDelay(level.random));
            return;
        }
        if (stage == FireStage.RAGING && fireTickOn) {
            level.scheduleTick(pos, (Block)this, this.getFireTickDelay(level.random));
            int ageAdd = random.nextInt(3) / 2;
            int ageIncrease = Math.min(15, age + ageAdd);
            if (age != ageIncrease) {
                state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(ageIncrease));
                level.setBlock(pos, state, 4);
            }
            FlammableLiquidBlock.burnStuffAroundLikeFire(state, level, pos, random, age);
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isLitUp(state, level, pos) ? 0 : 60;
    }

    private static void burnStuffAroundLikeFire(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int age) {
        boolean increaseFireBurnout = level.getBiome(pos).is(BiomeTags.INCREASED_FIRE_BURNOUT);
        int extraChance = increaseFireBurnout ? -50 : 0;
        SuppPlatformStuff.tryBurningByFire(level, pos.east(), 300 + extraChance, random, age, Direction.WEST);
        SuppPlatformStuff.tryBurningByFire(level, pos.west(), 300 + extraChance, random, age, Direction.EAST);
        SuppPlatformStuff.tryBurningByFire(level, pos.above(), 250 + extraChance, random, age, Direction.DOWN);
        SuppPlatformStuff.tryBurningByFire(level, pos.north(), 300 + extraChance, random, age, Direction.SOUTH);
        SuppPlatformStuff.tryBurningByFire(level, pos.south(), 300 + extraChance, random, age, Direction.NORTH);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 4; ++dy) {
                    Block block;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    int chance = 100;
                    if (dy > 1) {
                        chance += (dy - 1) * 100;
                    }
                    mutableBlockPos.setWithOffset((Vec3i)pos, dx, dy, dz);
                    FireBlock fireBlock = FlammableLiquidBlock.getFireDelegate();
                    int igniteOdds = fireBlock.getIgniteOdds((LevelReader)level, (BlockPos)mutableBlockPos);
                    boolean isLumisene = false;
                    if (igniteOdds == 0 && (dy != 0 || dx != 0 && dz != 0)) {
                        BlockState nextState = level.getBlockState(pos);
                        if (state.getBlock() instanceof FlammableLiquidBlock) {
                            igniteOdds = PlatHelper.getFireSpreadSpeed((BlockState)nextState, (BlockGetter)level, (BlockPos)pos, (Direction)Direction.UP);
                            isLumisene = true;
                        }
                    }
                    if (igniteOdds <= 0) continue;
                    int i2 = (igniteOdds + 40 + level.getDifficulty().getId() * 7) / (age + 30);
                    if (increaseFireBurnout) {
                        i2 /= 2;
                    }
                    if (i2 <= 0 || random.nextInt(chance) > i2 || level.isRaining() && fireBlock.isNearRain((Level)level, (BlockPos)mutableBlockPos)) continue;
                    int newAge = Math.min(15, age + random.nextInt(5) / 4);
                    if (isLumisene && (block = level.getBlockState(pos).getBlock()) instanceof FlammableLiquidBlock) {
                        FlammableLiquidBlock fl = (FlammableLiquidBlock)block;
                        fl.tryLightUp(null, state, pos, (LevelAccessor)level, ILightable.FireSoundType.FLAMING_ARROW);
                        continue;
                    }
                    level.setBlock((BlockPos)mutableBlockPos, fireBlock.getStateWithAge((LevelAccessor)level, (BlockPos)mutableBlockPos, newAge), 3);
                }
            }
        }
    }

    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        if (this.isLitUp(state, level, pos)) {
            return PathType.DAMAGE_FIRE;
        }
        return null;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        if (this.isLitUp(state, level, pos)) {
            return PathType.DAMAGE_FIRE;
        }
        return null;
    }

    @NotNull
    private static FireBlock getFireDelegate() {
        return (FireBlock)Blocks.FIRE;
    }

    public static enum FireStage {
        OFF,
        RISING,
        RAGING,
        DYING;


        public boolean isBurning() {
            return this != OFF;
        }

        public static FireStage fromAge(int age) {
            if (age == 0) {
                return OFF;
            }
            if (age == 15) {
                return DYING;
            }
            if (age < 4) {
                return RISING;
            }
            return RAGING;
        }
    }
}

