/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.Nullable;

public class ConfettiColors
implements TooltipProvider {
    protected static final HashBiMap<DyeColor, Integer> COLOR_TO_DIFFUSE = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), ConfettiColors::dyeToRGB, (color, color2) -> color2, HashBiMap::create));
    public static final Codec<ConfettiColors> CODEC = Codec.INT.listOf().xmap(list -> new ConfettiColors(list.stream().mapToInt(i -> i).toArray()), colors -> colors.colors);
    public static final StreamCodec<RegistryFriendlyByteBuf, ConfettiColors> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), v -> v.colors, ConfettiColors::new);
    public static final ConfettiColors EMPTY = new ConfettiColors(new int[0]);
    private final IntList colors;

    private static int dyeToRGB(DyeColor dyeColor) {
        return ColorHelper.prettyfyColor(new RGBColor(dyeColor.getTextColor()).asHSL()).asRGB().toInt();
    }

    public static ConfettiColors of(int ... colors) {
        return new ConfettiColors(colors);
    }

    public static ConfettiColors of(DyeColor ... colors) {
        IntList list = IntList.of();
        for (DyeColor c : colors) {
            list.add(ConfettiColors.dyeToRGB(c));
        }
        return new ConfettiColors(list.toIntArray());
    }

    @Nullable
    public static Integer getRgbColor(ItemStack stack) {
        DyedItemColor colorComp;
        if (CompatObjects.DYE_BOTTLE.is((Object)stack.getItem()) && (colorComp = (DyedItemColor)stack.get(DataComponents.DYED_COLOR)) != null) {
            return colorComp.rgb();
        }
        DyeColor c = ForgeHelper.getColor((ItemStack)stack);
        if (c != null) {
            return ConfettiColors.dyeToRGB(c);
        }
        return null;
    }

    ConfettiColors(List<Integer> colors) {
        this(colors.stream().mapToInt(i -> i).toArray());
    }

    ConfettiColors(int ... colors) {
        this.colors = IntList.of((int[])colors);
    }

    public Collection<Integer> getColors() {
        return this.colors;
    }

    public ConfettiColors withAddedColor(int color) {
        IntArrayList newColors = new IntArrayList();
        newColors.addAll(this.colors);
        newColors.add(color);
        return new ConfettiColors(newColors.toIntArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfettiColors)) {
            return false;
        }
        ConfettiColors that = (ConfettiColors)object;
        return Objects.equals(this.colors, that.colors);
    }

    public int hashCode() {
        return Objects.hashCode(this.colors);
    }

    public int size() {
        return this.colors.size();
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        IntListIterator intListIterator = this.colors.iterator();
        while (intListIterator.hasNext()) {
            int colorInt = (Integer)intListIterator.next();
            DyeColor dye = (DyeColor)COLOR_TO_DIFFUSE.inverse().get((Object)colorInt);
            if (dye != null) {
                tooltipAdder.accept((Component)Component.translatable((String)("color.minecraft." + dye.getName())).withStyle(ChatFormatting.GRAY));
                continue;
            }
            if (tooltipFlag.isAdvanced()) {
                tooltipAdder.accept((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", colorInt)}).withStyle(ChatFormatting.GRAY));
                continue;
            }
            tooltipAdder.accept((Component)Component.translatable((String)"item.dyed").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }
}

