/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class BarnaclesMultifaceGrowthFeature
extends Feature<Config> {
    public BarnaclesMultifaceGrowthFeature() {
        super(Config.CODEC);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        WorldGenLevel worldGenLevel = context.level();
        BlockPos startPos = context.origin();
        RandomSource randomSource = context.random();
        Config config = (Config)context.config();
        BlockState startState = worldGenLevel.getBlockState(startPos);
        if (startState.is((Block)config.placeBlock)) {
            config.placeBlock.getSpreader().spreadFromRandomFaceTowardRandomDirection(startState, (LevelAccessor)worldGenLevel, startPos, randomSource);
            return true;
        }
        if (!BarnaclesMultifaceGrowthFeature.isAirOrWater(startState)) {
            return false;
        }
        Collection<Direction> allDirs = config.getShuffledDirections(randomSource);
        if (BarnaclesMultifaceGrowthFeature.placeGrowthIfPossible(worldGenLevel, startPos, worldGenLevel.getBlockState(startPos), config, randomSource, allDirs)) {
            return true;
        }
        BlockPos.MutableBlockPos mutableBlockPos = startPos.mutable();
        boolean placed = false;
        block0: for (Direction direction : allDirs) {
            mutableBlockPos.set((Vec3i)startPos);
            List<Direction> list2 = config.getShuffledDirectionsExcept(randomSource, direction.getOpposite());
            for (int i = 0; i < config.searchRange; ++i) {
                mutableBlockPos.setWithOffset((Vec3i)startPos, direction);
                BlockState blockState = worldGenLevel.getBlockState((BlockPos)mutableBlockPos);
                if (!BarnaclesMultifaceGrowthFeature.isAirOrWater(blockState) && !blockState.is((Block)config.placeBlock)) continue block0;
                if (!BarnaclesMultifaceGrowthFeature.placeGrowthIfPossible(worldGenLevel, (BlockPos)mutableBlockPos, blockState, config, randomSource, list2)) continue;
                placed = true;
                return true;
            }
        }
        return placed;
    }

    public static boolean placeGrowthIfPossible(WorldGenLevel level, BlockPos pos, BlockState state, Config config, RandomSource random, Collection<Direction> directions) {
        Direction direction;
        BlockState blockState;
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        Iterator<Direction> sides = directions.iterator();
        do {
            if (sides.hasNext()) continue;
            return false;
        } while (BarnaclesMultifaceGrowthFeature.cantBePlacedOn(blockState = level.getBlockState((BlockPos)mutableBlockPos.setWithOffset((Vec3i)pos, direction = sides.next())), config));
        BlockState blockState2 = config.placeBlock.getStateForPlacement(state, (BlockGetter)level, pos, direction);
        if (blockState2 == null) {
            return false;
        }
        level.setBlock(pos, blockState2, 3);
        if (random.nextFloat() < config.chanceOfSpreading) {
            config.placeBlock.getSpreader().spreadFromFaceTowardRandomDirection(blockState2, (LevelAccessor)level, pos, direction, random, false);
        }
        return true;
    }

    private static boolean cantBePlacedOn(BlockState state, Config config) {
        return state.is(config.cantBePlacedOn) || BarnaclesMultifaceGrowthFeature.isAirOrWater(state);
    }

    private static boolean isAirOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }

    private static boolean isCliffFace(BlockPos pos, Level leve, Direction myFace) {
        if (myFace.getAxis().isVertical()) {
            return false;
        }
        BlockState onBlock = leve.getBlockState(pos.relative(myFace.getOpposite()));
        return false;
    }

    public record Config(MultifaceBlock placeBlock, int searchRange, PlacementEnvironment environment, boolean requiresWater, float chanceOfSpreading, HolderSet<Block> cantBePlacedOn) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").flatXmap(Config::validate, DataResult::success).orElse((Object)((MultifaceBlock)Blocks.GLOW_LICHEN)).forGetter(c -> c.placeBlock), (App)Codec.intRange((int)1, (int)64).optionalFieldOf("search_range", (Object)10).forGetter(c -> c.searchRange), (App)PlacementEnvironment.CODEC.optionalFieldOf("placement_environment", (Object)PlacementEnvironment.ANY).forGetter(c -> c.environment), (App)Codec.BOOL.optionalFieldOf("requires_water", (Object)false).forGetter(c -> c.requiresWater), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance_of_spreading", (Object)Float.valueOf(0.5f)).forGetter(c -> Float.valueOf(c.chanceOfSpreading)), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("cant_be_placed_on").forGetter(c -> c.cantBePlacedOn)).apply((Applicative)instance, Config::new));

        private static DataResult<MultifaceBlock> validate(Block block) {
            if (block instanceof MultifaceBlock) {
                MultifaceBlock multifaceBlock = (MultifaceBlock)block;
                return DataResult.success((Object)multifaceBlock);
            }
            return DataResult.error(() -> "Growth block should be a multiface block");
        }

        public List<Direction> getShuffledDirectionsExcept(RandomSource random, Direction direction) {
            return Util.toShuffledList(Stream.of(Direction.values()).filter(direction2 -> direction2 != direction), (RandomSource)random);
        }

        public Collection<Direction> getShuffledDirections(RandomSource random) {
            return Direction.allShuffled((RandomSource)random);
        }
    }

    private static enum PlacementEnvironment implements StringRepresentable
    {
        ANY,
        CLIFFS;

        public static final Codec<PlacementEnvironment> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(PlacementEnvironment::values);
        }
    }
}

