/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class FairRingIterator
implements Iterator<Ring>,
Iterable<Ring> {
    private final PriorityQueue<GridRing> pq;

    public FairRingIterator(List<Integer> gridSizes, long maxRadius, boolean inclusive) {
        if (gridSizes == null) {
            throw new IllegalArgumentException("gridSizes must not be null");
        }
        this.pq = new PriorityQueue<GridRing>(Comparator.comparingLong(GridRing::radius).thenComparingInt(r -> r.gridIndex));
        for (int i = 0; i < gridSizes.size(); ++i) {
            int s = gridSizes.get(i);
            if (s <= 0) continue;
            int kMax = inclusive ? (int)Math.ceil((double)maxRadius / (double)s) : (int)(maxRadius / (long)s);
            this.pq.add(new GridRing(i, s, 0, kMax));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.pq.isEmpty();
    }

    private int commonIterations() {
        return this.pq.stream().mapToInt(r -> r.iterations).min().orElse(0);
    }

    @Override
    public Ring next() {
        int commonIterations;
        if (this.pq.isEmpty()) {
            throw new NoSuchElementException();
        }
        GridRing gr = this.pq.poll();
        int snapped = gr.radius();
        if (gr.k < gr.kMax) {
            ++gr.k;
            this.pq.add(gr);
        }
        if (gr.iterations <= (commonIterations = this.commonIterations())) {
            ++gr.iterations;
            commonIterations = this.commonIterations();
        }
        return new Ring(gr.gridSize, snapped, commonIterations);
    }

    @Override
    public Iterator<Ring> iterator() {
        return this;
    }

    private static class GridRing {
        final int gridIndex;
        final int gridSize;
        final int kMax;
        int k;
        int iterations = 0;

        GridRing(int gridIndex, int gridSize, int k, int kMax) {
            this.gridIndex = gridIndex;
            this.gridSize = gridSize;
            this.k = k;
            this.kMax = kMax;
        }

        int radius() {
            return this.k * this.gridSize;
        }
    }

    public record Ring(int gridSize, int radius, int commonIterationsIndex) {
    }
}

