/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.blockentity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.ApiStatus;

public class LinearProcessExecutor<T> {
    public static final int CANCEL_EVENT_INDEX = -1;
    public static final int FINISH_EVENT_INDEX = -2;
    private final T target;
    private final int processLength;
    private final Predicate<LinearProcessExecutor<T>> condition;
    private Int2ObjectMap<BiConsumer<LinearProcessExecutor<T>, T>> eventTable;
    private Int2ObjectMap<ProcessStep<T>> processStepTable;
    private final Set<ProcessStep.Info<T>> activeSteps = new HashSet<ProcessStep.Info<T>>();
    private int processTick = 0;

    protected LinearProcessExecutor(T target, int processLength, Predicate<LinearProcessExecutor<T>> condition, Int2ObjectMap<ProcessStep<T>> serverStepTable) {
        this.target = target;
        this.processLength = processLength;
        this.condition = condition;
        this.eventTable = null;
        this.processStepTable = serverStepTable;
    }

    protected void configure(Int2ObjectMap<BiConsumer<LinearProcessExecutor<T>, T>> eventTable, Int2ObjectMap<ProcessStep<T>> processStepTable) {
        this.eventTable = eventTable;
        this.processStepTable = processStepTable;
    }

    public void tick() {
        if (this.eventTable == null) {
            throw new IllegalStateException("Illegal attempt to tick unconfigured executor");
        }
        if (!this.running()) {
            return;
        }
        if (this.cancelIfAppropriate()) {
            return;
        }
        if (this.finishIfAppropriate()) {
            return;
        }
        int tableIndex = this.processTick - 1;
        if (this.eventTable.containsKey(tableIndex)) {
            ((BiConsumer)this.eventTable.get(tableIndex)).accept(this, this.target);
        }
        if (this.processStepTable.containsKey(tableIndex)) {
            this.activeSteps.add(((ProcessStep)this.processStepTable.get(tableIndex)).createInfo(tableIndex));
        }
        this.activeSteps.removeIf(stepInfo -> !stepInfo.tick(this));
        ++this.processTick;
    }

    public boolean begin() {
        if (this.processTick != 0) {
            return false;
        }
        this.processTick = 1;
        return true;
    }

    public boolean running() {
        return this.processTick > 0;
    }

    public int getProcessTick() {
        return this.processTick;
    }

    public T getTarget() {
        return this.target;
    }

    public boolean cancel() {
        if (!this.running()) {
            return false;
        }
        this.processTick = 0;
        this.activeSteps.clear();
        if (this.eventTable.containsKey(-1)) {
            ((BiConsumer)this.eventTable.get(-1)).accept(this, this.target);
        }
        return true;
    }

    private boolean finishIfAppropriate() {
        if (!this.running()) {
            return false;
        }
        if (this.processTick < this.processLength) {
            return false;
        }
        if (this.eventTable.containsKey(-2)) {
            ((BiConsumer)this.eventTable.get(-2)).accept(this, this.target);
        }
        this.processTick = 0;
        this.activeSteps.clear();
        return true;
    }

    private boolean cancelIfAppropriate() {
        if (this.condition.test(this)) {
            return false;
        }
        this.cancel();
        return true;
    }

    public void writeState(CompoundTag targetTag) {
        targetTag.putInt("ProcessTick", this.processTick);
    }

    public void readState(CompoundTag targetTag) {
        this.processTick = targetTag.getInt("ProcessTick");
        this.activeSteps.clear();
        this.processStepTable.forEach((index, step) -> {
            if (this.processTick >= index && this.processTick <= index + step.length) {
                this.activeSteps.add(step.createInfo((int)index, this.processTick - index));
            }
        });
    }

    @ApiStatus.Internal
    public record ProcessStep<T>(int length, BiConsumer<LinearProcessExecutor<T>, T> executor) {
        public Info<T> createInfo(int index) {
            return new Info(index, this);
        }

        public Info<T> createInfo(int index, int tick) {
            return new Info(index, tick, this);
        }

        public static final class Info<T> {
            private final ProcessStep<T> step;
            private final int index;
            private int tick = 0;

            public Info(int index, ProcessStep<T> step) {
                this.index = index;
                this.step = step;
            }

            public Info(int index, int tick, ProcessStep<T> step) {
                this.index = index;
                this.tick = tick;
                this.step = step;
            }

            public boolean tick(LinearProcessExecutor<T> target) {
                ++this.tick;
                if (this.tick == this.step.length) {
                    return false;
                }
                this.step.executor.accept((LinearProcessExecutor<LinearProcessExecutor<T>>)target, (LinearProcessExecutor<T>)target.getTarget());
                return true;
            }
        }
    }
}

