/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config.ui.component;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Expanded;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.UISounds;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ListOptionContainer<T>
extends CollapsibleContainer
implements OptionValueProvider {
    protected final Option<List<T>> backingOption;
    protected final List<T> backingList;
    protected final Button resetButton;

    public ListOptionContainer(Option<List<T>> option) {
        super(Sizing.fill(100), Sizing.content(), (Component)Component.translatable((String)("text.config." + option.configName() + ".option." + option.key().asString())), option.backingField().field().isAnnotationPresent(Expanded.class));
        this.backingOption = option;
        this.backingList = new ArrayList<T>((Collection)option.value());
        this.padding(((Insets)this.padding.get()).add(0, 5, 0, 0));
        this.titleLayout.horizontalSizing(Sizing.fill(100));
        this.titleLayout.verticalSizing(Sizing.fixed(30));
        this.titleLayout.verticalAlignment(VerticalAlignment.CENTER);
        if (!option.detached()) {
            this.titleLayout.child(Components.label((Component)Component.translatable((String)"text.owo.config.list.add_entry").withStyle(ChatFormatting.GRAY)).configure(label -> {
                label.cursorStyle(CursorStyle.HAND);
                label.mouseEnter().subscribe(() -> label.text((Component)label.text().copy().withStyle(style -> style.withColor(ChatFormatting.YELLOW))));
                label.mouseLeave().subscribe(() -> label.text((Component)label.text().copy().withStyle(style -> style.withColor(ChatFormatting.GRAY))));
                label.mouseDown().subscribe((mouseX, mouseY, button) -> {
                    UISounds.playInteractionSound();
                    this.backingList.add("");
                    if (!this.expanded) {
                        this.toggleExpansion();
                    }
                    this.refreshOptions();
                    ParentComponent lastEntry = (ParentComponent)this.collapsibleChildren.get(this.collapsibleChildren.size() - 1);
                    this.focusHandler().focus(lastEntry.children().get(lastEntry.children().size() - 1), Component.FocusSource.MOUSE_CLICK);
                    return true;
                });
            }));
        }
        this.resetButton = Components.button((Component)Component.literal((String)"\u21c4"), button -> {
            this.backingList.clear();
            this.backingList.addAll((Collection)option.defaultValue());
            this.refreshOptions();
            button.active = false;
        });
        this.resetButton.margins(Insets.right(10));
        this.resetButton.positioning(Positioning.relative(100, 50));
        this.titleLayout.child((io.wispforest.owo.ui.core.Component)this.resetButton);
        this.refreshResetButton();
        this.refreshOptions();
        this.titleLayout.child(new SearchAnchorComponent(this.titleLayout, option.key(), () -> I18n.get((String)("text.config." + option.configName() + ".option." + option.key().asString()), (Object[])new Object[0]), () -> this.backingList.stream().map(Objects::toString).collect(Collectors.joining())));
    }

    protected void refreshOptions() {
        this.collapsibleChildren.clear();
        Class<?> listType = ReflectionUtils.getTypeArgument(this.backingOption.backingField().field().getGenericType(), 0);
        for (int i = 0; i < this.backingList.size(); ++i) {
            FlowLayout container = Containers.horizontalFlow(Sizing.fill(100), Sizing.content());
            container.verticalAlignment(VerticalAlignment.CENTER);
            int optionIndex = i;
            LabelComponent label = Components.label((Component)TextOps.withFormatting("- ", ChatFormatting.GRAY));
            label.margins(Insets.left(10));
            if (!this.backingOption.detached()) {
                label.cursorStyle(CursorStyle.HAND);
                label.mouseEnter().subscribe(() -> label.text((Component)TextOps.withFormatting("x ", ChatFormatting.GRAY)));
                label.mouseLeave().subscribe(() -> label.text((Component)TextOps.withFormatting("- ", ChatFormatting.GRAY)));
                label.mouseDown().subscribe((mouseX, mouseY, button) -> {
                    this.backingList.remove(optionIndex);
                    this.refreshResetButton();
                    this.refreshOptions();
                    UISounds.playInteractionSound();
                    return true;
                });
            }
            container.child(label);
            ConfigTextBox box = new ConfigTextBox();
            box.setValue(this.backingList.get(i).toString());
            box.moveCursorToStart(false);
            box.setBordered(false);
            box.margins(Insets.vertical(2));
            box.horizontalSizing(Sizing.fill(95));
            box.verticalSizing(Sizing.fixed(8));
            if (!this.backingOption.detached()) {
                box.onChanged().subscribe(s -> {
                    if (!box.isValid()) {
                        return;
                    }
                    this.backingList.set(optionIndex, box.parsedValue());
                    this.refreshResetButton();
                });
            } else {
                box.active = false;
            }
            if (NumberReflection.isNumberType(listType)) {
                box.configureForNumber(listType);
            }
            container.child((io.wispforest.owo.ui.core.Component)((Object)box));
            this.collapsibleChildren.add(container);
        }
        this.contentLayout.configure(layout -> {
            layout.clearChildren();
            if (this.expanded) {
                layout.children(this.collapsibleChildren);
            }
        });
        this.refreshResetButton();
    }

    protected void refreshResetButton() {
        this.resetButton.active = !this.backingOption.detached() && !this.backingList.equals(this.backingOption.defaultValue());
    }

    @Override
    public boolean shouldDrawTooltip(double mouseX, double mouseY) {
        return mouseY - (double)this.y <= (double)this.titleLayout.height() && super.shouldDrawTooltip(mouseX, mouseY);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Object parsedValue() {
        return this.backingList;
    }
}

