/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.advancements.predicate.CameraPredicate;
import io.github.mortuusars.exposure.advancements.predicate.FramePredicate;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class FrameExposedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, CameraHolder cameraHolder, ItemStack cameraStack, Frame frame, List<BlockPos> locationsInFrame, List<LivingEntity> entitiesInFrame) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(player, cameraHolder, cameraStack, frame, locationsInFrame, entitiesInFrame));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<CameraPredicate> camera, Optional<FramePredicate> frame, Optional<LocationPredicate> locationInFrame, Optional<List<ContextAwarePredicate>> entitiesInFrame) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)CameraPredicate.CODEC.optionalFieldOf("camera").forGetter(TriggerInstance::camera), (App)FramePredicate.CODEC.optionalFieldOf("frame").forGetter(TriggerInstance::frame), (App)LocationPredicate.CODEC.optionalFieldOf("location_in_frame").forGetter(TriggerInstance::locationInFrame), (App)EntityPredicate.ADVANCEMENT_CODEC.listOf().optionalFieldOf("entities_in_frame").forGetter(TriggerInstance::entitiesInFrame)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, CameraHolder cameraHolder, ItemStack cameraStack, Frame frame, List<BlockPos> locationsInFrame, List<LivingEntity> entitiesInFrame) {
            return !(!this.camera.isEmpty() && !this.camera.get().matches(player.serverLevel(), cameraStack, cameraHolder.asHolderEntity().position()) || !this.frame.isEmpty() && !this.frame.get().matches(frame) || !this.locationsMatch(player, locationsInFrame) || !this.entitiesInFrameMatch(player, cameraHolder, entitiesInFrame));
        }

        private boolean locationsMatch(ServerPlayer player, List<BlockPos> locationsInFrame) {
            return this.locationInFrame.isEmpty() || locationsInFrame.stream().anyMatch(pos -> this.locationInFrame.get().matches(player.serverLevel(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5));
        }

        private boolean entitiesInFrameMatch(ServerPlayer player, CameraHolder cameraHolder, List<LivingEntity> entitiesInFrame) {
            return this.entitiesInFrame.isEmpty() || this.entitiesInFrame.get().stream().allMatch(predicate -> entitiesInFrame.stream().anyMatch(entity -> {
                LootContext context = TriggerInstance.createContextForHolder(player.serverLevel(), cameraHolder, (Entity)entity);
                return predicate.matches(context);
            }));
        }

        public static LootContext createContextForHolder(ServerLevel level, CameraHolder holder, Entity entity) {
            LootParams lootParams = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)holder.asHolderEntity().position()).create(LootContextParamSets.ADVANCEMENT_ENTITY);
            return new LootContext.Builder(lootParams).create(Optional.empty());
        }
    }
}

