/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.camera.button;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.gui.component.CycleButton;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

public class ShutterSpeedButton
extends CycleButton<ShutterSpeed> {
    protected final int secondaryFontColor;
    protected final int mainFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_MAIN_COLOR);

    public ShutterSpeedButton(int x, int y, int width, int height, List<ShutterSpeed> values, @NotNull ShutterSpeed startingValue, Function<ShutterSpeed, WidgetSprites> spritesFunc, CycleButton.OnCycle<ShutterSpeed> onCycle) {
        super(x, y, width, height, values, startingValue, spritesFunc, onCycle);
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    public ShutterSpeedButton(int x, int y, int width, int height, List<ShutterSpeed> values, @NotNull ShutterSpeed startingValue, Function<ShutterSpeed, WidgetSprites> spritesFunc) {
        super(x, y, width, height, values, startingValue, spritesFunc, (CycleButton<T> button, T newValue) -> {});
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (this.clickSound != null) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.clickSound, (float)(ThreadLocalRandom.current().nextFloat() * 0.05f + 0.9f + (float)this.currentIndex * 0.01f), (float)0.7f));
        }
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        ShutterSpeed shutterSpeed = (ShutterSpeed)this.getCurrentValue();
        Object text = shutterSpeed.getNotation().replace("1/", "");
        if (shutterSpeed.equals(ShutterSpeed.DEFAULT)) {
            text = (String)text + "\u2022";
        }
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((String)text);
        int xPos = this.width / 2 - textWidth / 2 + 1;
        guiGraphics.drawString(font, (String)text, this.getX() + xPos, this.getY() + 4, this.secondaryFontColor, false);
        guiGraphics.drawString(font, (String)text, this.getX() + xPos, this.getY() + 3, this.mainFontColor, false);
    }
}

