/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class BlackAndWhiteEffect
implements PixelEffect {
    protected final float rWeight;
    protected final float gWeight;
    protected final float bWeight;
    protected String identifier;

    public BlackAndWhiteEffect(float rWeight, float gWeight, float bWeight) {
        this.rWeight = rWeight;
        this.gWeight = gWeight;
        this.bWeight = bWeight;
        this.identifier = "bw-" + rWeight + "-" + gWeight + "-" + bWeight;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int modify(int colorARGB) {
        int alpha = FastColor.ARGB32.alpha((int)colorARGB);
        int red = FastColor.ARGB32.red((int)colorARGB);
        int green = FastColor.ARGB32.green((int)colorARGB);
        int blue = FastColor.ARGB32.blue((int)colorARGB);
        int value = Mth.clamp((int)((int)(this.rWeight * (float)red + this.gWeight * (float)green + this.bWeight * (float)blue)), (int)0, (int)255);
        return FastColor.ARGB32.color((int)alpha, (int)value, (int)value, (int)value);
    }

    public String toString() {
        return "BlackAndWhiteProcessor{weights:%s,%s,%s}".formatted(Float.valueOf(this.rWeight), Float.valueOf(this.gWeight), Float.valueOf(this.bWeight));
    }
}

