/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.cycles.task;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.TranslatableError;
import io.github.mortuusars.exposure.util.cycles.task.Result;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import java.util.concurrent.CompletableFuture;

public class FallbackTask<T>
extends Task<Result<T>> {
    private final Task<Result<T>> main;
    private final Task<Result<T>> fallback;

    public FallbackTask(Task<Result<T>> main, Task<Result<T>> fallback) {
        this.main = main;
        this.fallback = fallback;
    }

    @Override
    public CompletableFuture<Result<T>> execute() {
        return this.main.execute().handle((mainResult, mainException) -> {
            if (mainResult != null && mainResult.isSuccessful()) {
                return mainResult;
            }
            if (mainException != null) {
                Exposure.LOGGER.error("Main CaptureTask is failed: ", mainException);
            } else if (mainResult != null && mainResult.isError()) {
                Exposure.LOGGER.error("Main CaptureTask is failed: {}", (Object)mainResult.getError().technical().getString());
            }
            return this.captureFallback();
        });
    }

    private Result<T> captureFallback() {
        return (Result)((CompletableFuture)this.fallback.execute().handle((fallbackResult, fallbackException) -> {
            if (fallbackException != null) {
                Exposure.LOGGER.error("Both Main and Fallback tasks are failed! Fallback error: ", fallbackException);
                return Result.error(TranslatableError.GENERIC);
            }
            return fallbackResult;
        })).join();
    }

    @Override
    public void tick() {
        this.main.tick();
        this.fallback.tick();
    }

    @Override
    public boolean isDone() {
        return this.main.isDone() && this.fallback.isDone();
    }

    @Override
    public boolean isStarted() {
        return this.main.isStarted() || this.fallback.isStarted();
    }
}

