/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.block.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.world.block.LightroomBlock;
import io.github.mortuusars.exposure.world.block.entity.Lightroom;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.inventory.LightroomMenu;
import io.github.mortuusars.exposure.world.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.world.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.LevelUtil;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.lightroom.PrintingMode;
import io.github.mortuusars.exposure.world.lightroom.PrintingProcess;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final int CONTAINER_DATA_SIZE = 3;
    public static final int CONTAINER_DATA_PROGRESS_ID = 0;
    public static final int CONTAINER_DATA_PRINT_TIME_ID = 1;
    public static final int CONTAINER_DATA_SELECTED_FRAME_ID = 2;
    protected final ContainerData containerData = new ContainerData(){

        public int get(int id) {
            return switch (id) {
                case 0 -> LightroomBlockEntity.this.progress;
                case 1 -> LightroomBlockEntity.this.printTime;
                case 2 -> LightroomBlockEntity.this.getSelectedFrameIndex();
                default -> 0;
            };
        }

        public void set(int id, int value) {
            if (id == 0) {
                LightroomBlockEntity.this.progress = value;
            } else if (id == 1) {
                LightroomBlockEntity.this.printTime = value;
            } else if (id == 2) {
                LightroomBlockEntity.this.setSelectedFrameIndex(value);
            }
            LightroomBlockEntity.this.setChanged();
        }

        public int getCount() {
            return 3;
        }
    };
    public static final Map<DyeColor, Integer> DYE_SLOTS = Map.of(DyeColor.CYAN, 2, DyeColor.MAGENTA, 3, DyeColor.YELLOW, 4, DyeColor.BLACK, 5);
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
    protected UUID lastPlayerId = Util.NIL_UUID;
    protected int selectedFrameIndex;
    protected int progress;
    protected int printTime;
    protected int storedExperience;
    protected boolean advanceFrame;
    protected PrintingMode printingMode = PrintingMode.REGULAR;
    @Nullable
    protected Frame selectedFrame;

    public LightroomBlockEntity(BlockPos pos, BlockState blockState) {
        super(Exposure.BlockEntityTypes.LIGHTROOM.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void serverTick(Level ignoredLevel, BlockPos ignoredBlockPos, BlockState ignoredBlockState, T blockEntity) {
        if (blockEntity instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            lightroomBlockEntity.tick();
        }
    }

    protected void tick() {
        if (this.printTime <= 0 || !this.canPrint()) {
            this.stopPrintingProcess();
            return;
        }
        if (this.progress < this.printTime) {
            ++this.progress;
            if (this.progress % 55 == 0 && this.printTime - this.progress > 12) {
                this.playPrintingSound();
            }
            return;
        }
        @Nullable Frame frame = this.getSelectedFrame();
        Preconditions.checkState((frame != null ? 1 : 0) != 0, (Object)"Frame cannot be null here because of 'canPrint' check. If it is - something went wrong.");
        PrintingProcess process = this.getPrintingProcess(frame);
        this.printFrame(frame, process, true);
        this.stopPrintingProcess();
    }

    public void setLastPlayer(Player player) {
        this.lastPlayerId = player.getUUID();
    }

    public float getProgressPercentage() {
        if (this.progress < 1 || this.printTime < 1) {
            return 0.0f;
        }
        return (float)this.progress / (float)this.printTime;
    }

    public boolean isPrinting() {
        return this.level != null && (Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)LightroomBlock.PRINTING) != false;
    }

    public boolean isAdvancingFrameOnPrint() {
        return this.advanceFrame;
    }

    protected boolean canEjectFilm() {
        Direction facing;
        if (this.level == null || this.level.isClientSide || this.getItem(0).isEmpty()) {
            return false;
        }
        BlockPos pos = this.getBlockPos();
        return !this.level.getBlockState(pos.relative(facing = (Direction)this.level.getBlockState(pos).getValue((Property)LightroomBlock.FACING))).canOcclude();
    }

    protected void ejectFilm() {
        if (this.level == null || this.level.isClientSide || this.getItem(0).isEmpty()) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        Direction facing = (Direction)this.level.getBlockState(pos).getValue((Property)LightroomBlock.FACING);
        ItemStack filmStack = this.removeItem(0, 1);
        Vec3i normal = facing.getNormal();
        Vec3 point = Vec3.atCenterOf((Vec3i)pos).add((double)((float)normal.getX() * 0.75f), (double)((float)normal.getY() * 0.75f), (double)((float)normal.getZ() * 0.75f));
        ItemEntity itemEntity = new ItemEntity(this.level, point.x, point.y, point.z, filmStack);
        itemEntity.setDeltaMovement((double)((float)normal.getX() * 0.05f), (double)((float)normal.getY() * 0.05f + 0.15f), (double)((float)normal.getZ() * 0.05f));
        itemEntity.setDefaultPickUpDelay();
        this.level.addFreshEntity((Entity)itemEntity);
        this.inventoryContentsChanged(0);
    }

    public int getSelectedFrameIndex() {
        return this.selectedFrameIndex;
    }

    public void setSelectedFrameIndex(int index) {
        DevelopedFilmItem developedFilm;
        ItemStack filmStack;
        Item item;
        if (this.selectedFrameIndex != index) {
            this.selectedFrameIndex = index;
            this.stopPrintingProcess();
        }
        this.selectedFrame = (item = (filmStack = this.getItem(0)).getItem()) instanceof DevelopedFilmItem && (developedFilm = (DevelopedFilmItem)item).hasFrameAt(filmStack, this.getSelectedFrameIndex()) ? (Frame)developedFilm.getStoredFrames(filmStack).get(this.getSelectedFrameIndex()) : null;
    }

    public PrintingMode getActualPrintingMode() {
        return this.isRefracted() ? this.printingMode : PrintingMode.REGULAR;
    }

    public PrintingMode getPrintingMode() {
        return this.printingMode;
    }

    public void setPrintMode(PrintingMode printingMode) {
        this.printingMode = printingMode;
        this.stopPrintingProcess();
        this.setChanged();
    }

    @Nullable
    public Frame getSelectedFrame() {
        return this.selectedFrame;
    }

    public boolean isRefracted() {
        return this.level != null && (Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)LightroomBlock.REFRACTED) != false;
    }

    public void startPrintingProcess(boolean advanceFrameOnFinish) {
        BlockState state;
        if (!this.canPrint()) {
            return;
        }
        @Nullable Frame frame = this.getSelectedFrame();
        Preconditions.checkState((frame != null ? 1 : 0) != 0, (Object)"Frame cannot be null here because of 'canPrint' check. If it is - something went wrong.");
        PrintingProcess process = this.getPrintingProcess(frame);
        int time = process.getPrintTime();
        this.printTime = this.isRefracted() && process.isRegular() ? time * 3 : time;
        this.advanceFrame = advanceFrameOnFinish;
        if (this.level != null && (state = this.level.getBlockState(this.getBlockPos())).getBlock() instanceof LightroomBlock && !((Boolean)state.getValue((Property)LightroomBlock.PRINTING)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)LightroomBlock.PRINTING, (Comparable)Boolean.valueOf(true)), 2);
            this.playPrintingStartedSound();
        }
    }

    public void stopPrintingProcess() {
        BlockState state;
        this.progress = 0;
        this.printTime = 0;
        this.advanceFrame = false;
        if (this.level != null && (state = this.level.getBlockState(this.getBlockPos())).getBlock() instanceof LightroomBlock && ((Boolean)state.getValue((Property)LightroomBlock.PRINTING)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)LightroomBlock.PRINTING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean canPrint() {
        @Nullable Frame frame = this.getSelectedFrame();
        if (frame == null) {
            return false;
        }
        ItemStack paperStack = this.getItem(1);
        if (paperStack.isEmpty()) {
            return false;
        }
        PrintingProcess process = this.getPrintingProcess(frame);
        return this.isPaperValidForPrint(frame, process) && this.canOutputToResultSlot(frame, process) && this.hasDyesForPrint(frame, process) && this.hasSufficientLightLevel();
    }

    public boolean hasSufficientLightLevel() {
        if (this.level == null) {
            return false;
        }
        int requiredLightLevel = (Integer)Config.Server.LIGHTROOM_LIGHT_REQUIREMENT.get();
        BlockPos above = this.getBlockPos().above();
        if (this.isRefracted()) {
            return LevelUtil.getLightLevelAt(this.level, above.above()) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.level, above.relative(Direction.NORTH)) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.level, above.relative(Direction.EAST)) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.level, above.relative(Direction.SOUTH)) >= requiredLightLevel || LevelUtil.getLightLevelAt(this.level, above.relative(Direction.WEST)) >= requiredLightLevel;
        }
        return LevelUtil.getLightLevelAt(this.level, above) >= requiredLightLevel;
    }

    public boolean canPrintInCreativeMode() {
        @Nullable Frame frame = this.getSelectedFrame();
        if (frame == null) {
            return false;
        }
        PrintingProcess process = this.getPrintingProcess(frame);
        return this.canOutputToResultSlot(frame, process);
    }

    protected PrintingProcess getPrintingProcess(@NotNull Frame frame) {
        return switch (this.getActualPrintingMode()) {
            default -> throw new MatchException(null, null);
            case PrintingMode.REGULAR -> PrintingProcess.fromExposureType(frame.type());
            case PrintingMode.CHROMATIC -> PrintingProcess.fromChromaticStep(this.getChromaticStep(this.getItem(1)));
        };
    }

    protected boolean isPaperValidForPrint(Frame frame, PrintingProcess process) {
        ItemStack paperStack = this.getItem(1);
        if (paperStack.isEmpty()) {
            return false;
        }
        if (process.isChromatic()) {
            ChromaticSheetItem chromaticSheet;
            Item item;
            return paperStack.is(Exposure.Tags.Items.PHOTO_PAPERS) || (item = paperStack.getItem()) instanceof ChromaticSheetItem && !(chromaticSheet = (ChromaticSheetItem)item).canCombine(paperStack);
        }
        return paperStack.is(Exposure.Tags.Items.PHOTO_PAPERS);
    }

    protected boolean hasDyesForPrint(Frame frame, PrintingProcess process) {
        for (DyeColor requiredDye : process.getRequiredDyes()) {
            int slotIndex = DYE_SLOTS.get(requiredDye);
            if (!this.getItem(slotIndex).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean canOutputToResultSlot(Frame frame, PrintingProcess process) {
        StackedPhotographsItem stackedPhotographsItem;
        Item item;
        ItemStack resultStack = this.getItem(6);
        if (process.isChromatic()) {
            return resultStack.isEmpty();
        }
        return resultStack.isEmpty() || resultStack.getItem() instanceof PhotographItem || (item = resultStack.getItem()) instanceof StackedPhotographsItem && (stackedPhotographsItem = (StackedPhotographsItem)item).canAddPhotograph(resultStack);
    }

    protected int getChromaticStep(ItemStack paper) {
        Item item = paper.getItem();
        if (!(item instanceof ChromaticSheetItem)) {
            return 0;
        }
        ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)item;
        return chromaticSheet.getLayers(paper).size();
    }

    protected void printFrame(Frame frame, PrintingProcess process, boolean consumeIngredients) {
        ItemStack printResult = this.createPrintResult(frame, process);
        this.putPrintResultInOutputSlot(printResult);
        if (consumeIngredients) {
            this.consumePrintIngredients(frame, process);
            this.awardExperienceForPrint(frame, process, printResult);
        }
        this.onFramePrinted(frame, process, printResult);
    }

    public void printFrameInCreative() {
        @Nullable Frame frame = this.getSelectedFrame();
        if (frame == null) {
            Exposure.LOGGER.error("Cannot creatively print a frame: No frame is selected.");
            return;
        }
        PrintingProcess process = this.getPrintingProcess(frame);
        this.printFrame(frame, process, false);
        if (this.getItem(1).getItem() instanceof ChromaticSheetItem) {
            this.getItem(1).shrink(1);
            this.setChanged();
        }
    }

    protected ItemStack createPrintResult(Frame frame, PrintingProcess process) {
        if (process.isChromatic()) {
            ItemStack paperStack = this.getItem(1);
            ItemStack chromaticStack = paperStack.getItem() instanceof ChromaticSheetItem ? paperStack.copy() : new ItemStack((ItemLike)Exposure.Items.CHROMATIC_SHEET.get());
            ChromaticSheetItem chromaticItem = (ChromaticSheetItem)chromaticStack.getItem();
            chromaticItem.addLayer(chromaticStack, frame);
            @Nullable ServerPlayer player = this.getLastOrClosestPlayer();
            if (chromaticItem.canCombine(chromaticStack)) {
                if (player != null) {
                    return chromaticItem.combineIntoPhotograph(player, chromaticStack, true);
                }
                CompoundTag tag = new CompoundTag();
                tag.putBoolean("printed", true);
                chromaticStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            return chromaticStack;
        }
        ItemStack photographStack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
        photographStack.set(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
        photographStack.set(Exposure.DataComponents.PHOTOGRAPH_TYPE, (Object)frame.type());
        return photographStack;
    }

    @Nullable
    protected ServerPlayer getLastOrClosestPlayer() {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = serverLevel.getPlayerByUUID(this.lastPlayerId);
        if (player instanceof ServerPlayer) {
            ServerPlayer lastPlayer = (ServerPlayer)player;
            return lastPlayer;
        }
        BlockPos pos = this.getBlockPos();
        return serverLevel.players().stream().min(Comparator.comparingDouble(pl -> pl.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))).orElse(null);
    }

    protected void putPrintResultInOutputSlot(ItemStack printResult) {
        ItemStack resultStack = this.getItem(6);
        if (resultStack.isEmpty()) {
            resultStack = printResult;
        } else if (resultStack.getItem() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            ItemStack newStackedPhotographs = new ItemStack((ItemLike)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, resultStack);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, printResult);
            resultStack = newStackedPhotographs;
        } else {
            Item item = resultStack.getItem();
            if (item instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)item;
                stackedPhotographsItem.addPhotographOnTop(resultStack, printResult);
            } else {
                Exposure.LOGGER.error("Unexpected item in result slot: {}", (Object)resultStack);
                return;
            }
        }
        this.setItem(6, resultStack);
    }

    protected void consumePrintIngredients(Frame frame, PrintingProcess process) {
        this.getItem(1).shrink(1);
        process.getRequiredDyes().forEach(dye -> this.getItem(DYE_SLOTS.get(dye)).shrink(1));
        this.setChanged();
    }

    protected void awardExperienceForPrint(Frame frame, PrintingProcess process, ItemStack result) {
        int xp = process.getExperiencePerPrint();
        if (xp > 0) {
            float variability = ThreadLocalRandom.current().nextFloat() * 0.3f + 1.0f;
            int variableXp = (int)Math.max(1.0, Math.ceil((float)xp * variability));
            this.storedExperience += variableXp;
        }
    }

    protected void onFramePrinted(Frame frame, PrintingProcess process, ItemStack result) {
        ServerPlayer serverPlayer;
        if (process.isRegular()) {
            frame.identifier().ifId(id -> ExposureServer.exposureRepository().update((String)id, exposure -> exposure.withTag((Function<ExposureData.Tag, ExposureData.Tag>)((Function)ExposureData.Tag::setPrinted))));
        }
        if ((serverPlayer = this.getLastOrClosestPlayer()) instanceof ServerPlayer) {
            ServerPlayer player = serverPlayer;
            Exposure.CriteriaTriggers.FRAME_PRINTED.get().trigger(player, this.getBlockPos(), frame, result);
        }
        if (this.advanceFrame) {
            this.advanceFrame();
        }
        this.playPrintingFinishedSound();
    }

    protected void advanceFrame() {
        ItemAndStack film = new ItemAndStack(this.getItem(0));
        int frames = ((DevelopedFilmItem)film.getItem()).getStoredFramesCount(film.getItemStack());
        if (this.getSelectedFrameIndex() >= frames - 1) {
            if (this.canEjectFilm()) {
                this.ejectFilm();
            }
        } else {
            this.setSelectedFrameIndex(this.getSelectedFrameIndex() + 1);
            this.setChanged();
        }
    }

    public void dropStoredExperience(@Nullable Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.storedExperience > 0) {
                ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)Vec3.atCenterOf((Vec3i)this.getBlockPos()), (int)this.storedExperience);
                this.storedExperience = 0;
                this.setChanged();
            }
        }
    }

    protected void playPrintingStartedSound() {
        if (this.level != null) {
            this.level.playSound(null, this.getBlockPos(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), SoundSource.BLOCKS, 1.0f, this.level.getRandom().nextFloat() * 0.3f + 1.0f);
        }
    }

    protected void playPrintingSound() {
        if (this.level != null) {
            this.level.playSound(null, this.getBlockPos(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), SoundSource.BLOCKS, 1.0f, this.level.getRandom().nextFloat() * 0.3f + 1.0f);
        }
    }

    protected void playPrintingFinishedSound() {
        if (this.level != null) {
            this.level.playSound(null, this.getBlockPos(), Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        }
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.exposure.lightroom");
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new LightroomMenu(containerId, inventory, this, this.containerData);
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.getItem() instanceof DevelopedFilmItem;
        }
        if (slot == 2) {
            return stack.is(Exposure.Tags.Items.CYAN_PRINTING_DYES);
        }
        if (slot == 3) {
            return stack.is(Exposure.Tags.Items.MAGENTA_PRINTING_DYES);
        }
        if (slot == 4) {
            return stack.is(Exposure.Tags.Items.YELLOW_PRINTING_DYES);
        }
        if (slot == 5) {
            return stack.is(Exposure.Tags.Items.BLACK_PRINTING_DYES);
        }
        if (slot == 1) {
            ChromaticSheetItem chromatic;
            Item item;
            return stack.is(Exposure.Tags.Items.PHOTO_PAPERS) || (item = stack.getItem()) instanceof ChromaticSheetItem && (chromatic = (ChromaticSheetItem)item).getLayers(stack).size() < 3;
        }
        if (slot == 6) {
            return stack.getItem() instanceof PhotographItem || stack.getItem() instanceof StackedPhotographsItem || stack.getItem() instanceof ChromaticSheetItem;
        }
        return false;
    }

    protected void inventoryContentsChanged(int slot) {
        if (slot == 0) {
            this.setSelectedFrameIndex(0);
        }
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return this.level != null && this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction face) {
        return Lightroom.ALL_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (direction == Direction.DOWN) {
            return false;
        }
        return this.canPlaceItem(index, itemStack);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 6 && this.isItemValidForSlot(index, stack) && super.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack pStack, @NotNull Direction direction) {
        for (int outputSlot : Lightroom.OUTPUT_SLOTS) {
            if (index != outputSlot) continue;
            return true;
        }
        return false;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (tag.contains("Inventory", 10)) {
            CompoundTag inventory = tag.getCompound("Inventory");
            ListTag itemsList = inventory.getList("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTag = itemsList.getCompound(i);
                int slot = itemTag.getInt("Slot");
                if (slot < 0 || slot >= this.items.size()) continue;
                ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemTag).ifPresent(stack -> this.items.set(slot, stack));
            }
        }
        this.setSelectedFrameIndex(tag.getInt("SelectedFrame"));
        this.progress = tag.getInt("Progress");
        this.printTime = tag.getInt("PrintTime");
        this.storedExperience = tag.getInt("PrintedPhotographsCount");
        this.advanceFrame = tag.getBoolean("AdvanceFrame");
        this.printingMode = PrintingMode.fromStringOrDefault(tag.getString("PrintMode"), PrintingMode.REGULAR);
        if (tag.contains("LastPlayerId", 11)) {
            this.lastPlayerId = tag.getUUID("LastPlayerId");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (this.getSelectedFrameIndex() > 0) {
            tag.putInt("SelectedFrame", this.getSelectedFrameIndex());
        }
        if (this.progress > 0) {
            tag.putInt("Progress", this.progress);
        }
        if (this.printTime > 0) {
            tag.putInt("PrintTime", this.printTime);
        }
        if (this.storedExperience > 0) {
            tag.putInt("PrintedPhotographsCount", this.storedExperience);
        }
        if (this.advanceFrame) {
            tag.putBoolean("AdvanceFrame", true);
        }
        if (this.printingMode != PrintingMode.REGULAR) {
            tag.putString("PrintMode", this.printingMode.getSerializedName());
        }
        if (!this.lastPlayerId.equals(Util.NIL_UUID)) {
            tag.putUUID("LastPlayerId", this.lastPlayerId);
        }
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public int getContainerSize() {
        return 7;
    }

    public boolean isEmpty() {
        return this.getItems().stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.inventoryContentsChanged(slot);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.inventoryContentsChanged(slot);
    }

    public void clearContent() {
        this.getItems().clear();
        this.inventoryContentsChanged(-1);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

