/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.frame;

import io.github.mortuusars.exposure.util.Fov;
import io.github.mortuusars.exposure.util.PointOfView;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitiesInFrame {
    public static List<LivingEntity> get(CameraHolder cameraHolder, PointOfView pov, double fov) {
        return EntitiesInFrame.get(cameraHolder.asHolderEntity(), pov, fov);
    }

    public static List<LivingEntity> get(Entity cameraHolder, PointOfView pov, double fov) {
        double focalLength = Fov.fovToFocalLength(fov *= 0.95);
        AABB area = new AABB(cameraHolder.blockPosition()).inflate(128.0);
        List entities = cameraHolder.level().getEntities(null, area);
        FrustumCheck frustum = FrustumCheck.createFromCamera(pov.pos(), pov.dir(), (float)Math.toRadians(fov));
        entities.sort((entity, entity2) -> {
            double dist2;
            double dist1 = pov.pos().distanceTo(entity.position());
            if (dist1 == (dist2 = pov.pos().distanceTo(entity2.position()))) {
                return 0;
            }
            return dist1 > dist2 ? 1 : -1;
        });
        ArrayList<LivingEntity> entitiesInFrame = new ArrayList<LivingEntity>();
        for (Entity entity3 : entities) {
            LivingEntity livingEntity;
            if (!(entity3 instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity3).isAlive() || !frustum.contains(entity3.getEyePosition()) || EntitiesInFrame.calculateVisibleDistance(pov.pos(), entity3) > focalLength || !EntitiesInFrame.hasLineOfSight(pov.pos(), entity3)) continue;
            entitiesInFrame.add(livingEntity);
        }
        return entitiesInFrame;
    }

    public static double calculateVisibleDistance(Vec3 cameraPos, Entity entity) {
        double distanceInBlocks = Math.sqrt(entity.distanceToSqr(cameraPos));
        AABB boundingBox = entity.getBoundingBoxForCulling();
        double size = boundingBox.getSize();
        if (Double.isNaN(size) || size == 0.0) {
            size = 0.1;
        }
        double sizeInfluence = (size - 1.0) * 0.6 + 1.0;
        double feelsRightInfluence = 1.15;
        return distanceInBlocks / sizeInfluence * feelsRightInfluence;
    }

    public static boolean hasLineOfSight(Vec3 cameraPos, Entity entity) {
        return entity.level().clip(new ClipContext(cameraPos, entity.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS;
    }

    public static class FrustumCheck {
        private final Vec3 cameraPos;
        private final Vec3 forward;
        private final Vec3 right;
        private final Vec3 up;
        private final float fovRadians;

        public FrustumCheck(Vec3 cameraPos, Vec3 forward, Vec3 right, Vec3 up, float fovRadians) {
            this.cameraPos = cameraPos;
            this.forward = forward.normalize();
            this.right = right.normalize();
            this.up = up.normalize();
            this.fovRadians = fovRadians;
        }

        public boolean contains(Vec3 pos) {
            Vec3 toEntity = pos.subtract(this.cameraPos);
            double depth = toEntity.dot(this.forward);
            if (depth <= 0.0) {
                return false;
            }
            double horizontalOffset = toEntity.dot(this.right);
            double verticalOffset = toEntity.dot(this.up);
            double halfSize = depth * Math.tan(this.fovRadians / 2.0f);
            return Math.abs(horizontalOffset) <= halfSize && Math.abs(verticalOffset) <= halfSize;
        }

        public static FrustumCheck createFromCamera(Vec3 cameraPos, Vec3 lookVec, float fov) {
            Vec3 forward = lookVec.normalize();
            Vec3 worldUp = new Vec3(0.0, 1.0, 0.0);
            Vec3 right = forward.cross(worldUp).normalize();
            Vec3 up = right.cross(forward).normalize();
            return new FrustumCheck(cameraPos, forward, right, up, fov);
        }
    }
}

