/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.capture.DitherMode;
import io.github.mortuusars.exposure.world.camera.capture.Projection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class InterplanarProjectorItem
extends Item {
    public InterplanarProjectorItem(Item.Properties properties) {
        super(properties);
    }

    public DitherMode getMode(ItemStack stack) {
        return (DitherMode)((Object)stack.getOrDefault(Exposure.DataComponents.INTERPLANAR_PROJECTOR_MODE, (Object)DitherMode.DITHERED));
    }

    public void setMode(ItemStack stack, DitherMode mode) {
        stack.set(Exposure.DataComponents.INTERPLANAR_PROJECTOR_MODE, (Object)mode);
    }

    public boolean isConsumable(ItemStack stack) {
        return this.isAllowed();
    }

    protected boolean isAllowed() {
        return (Boolean)Config.Server.CAN_PROJECT.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        if (!this.isAllowed()) {
            components.add((Component)Component.translatable((String)"item.exposure.interplanar_projector.tooltip.disabled"));
        }
        if (this.getProjection(stack).isPresent()) {
            components.add(this.getMode(stack).translate());
        }
        if (Screen.hasShiftDown()) {
            if (this.isConsumable(stack)) {
                components.add((Component)Component.translatable((String)"item.exposure.interplanar_projector.tooltip.consumed_info"));
            }
            components.add((Component)Component.translatable((String)"item.exposure.interplanar_projector.tooltip.info"));
            if (this.getProjection(stack).isPresent()) {
                components.add((Component)Component.translatable((String)"item.exposure.interplanar_projector.tooltip.change_mode_info"));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltip.exposure.hold_for_details"));
        }
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (other.isEmpty() && action == ClickAction.SECONDARY && this.getProjection(stack).isPresent()) {
            this.setMode(stack, this.getMode(stack).cycle());
            slot.setChanged();
            if (player.level().isClientSide) {
                player.playSound(Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), 0.6f, 1.0f);
            }
            return true;
        }
        return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    public Optional<String> getPath(ItemStack stack) {
        @Nullable Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
        return customName != null ? Optional.of(customName.getString()) : Optional.empty();
    }

    public Optional<Projection> getProjection(ItemStack stack) {
        return this.isAllowed() ? this.getPath(stack).map(filepath -> new Projection((String)filepath, this.getMode(stack))) : Optional.empty();
    }
}

