/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.gui.entries.AbstractListListEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class NestedListListEntry<T, INNER extends AbstractConfigListEntry<T>>
extends AbstractListListEntry<T, NestedListCell<T, INNER>, NestedListListEntry<T, INNER>> {
    private final List<ReferenceProvider<?>> referencableEntries = Lists.newArrayList();

    @ApiStatus.Internal
    public NestedListListEntry(Component fieldName, List<T> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<T>> saveConsumer, Supplier<List<T>> defaultValue, Component resetButtonKey, boolean deleteButtonEnabled, boolean insertInFront, BiFunction<T, NestedListListEntry<T, INNER>, INNER> createNewCell) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false, deleteButtonEnabled, insertInFront, (t, nestedListListEntry) -> new NestedListCell<Object, AbstractConfigListEntry>(t, (NestedListListEntry<Object, AbstractConfigListEntry>)nestedListListEntry, (AbstractConfigListEntry)createNewCell.apply((Object)t, (NestedListListEntry)nestedListListEntry)));
        for (NestedListCell cell : this.cells) {
            this.referencableEntries.add((ReferenceProvider<?>)cell.nestedEntry);
        }
        this.setReferenceProviderEntries(this.referencableEntries);
    }

    @Override
    public Iterator<String> getSearchTags() {
        return Iterators.concat(super.getSearchTags(), (Iterator)Iterators.concat(this.cells.stream().map(cell -> ((AbstractConfigEntry)cell.nestedEntry).getSearchTags()).iterator()));
    }

    @Override
    public NestedListListEntry<T, INNER> self() {
        return this;
    }

    public static class NestedListCell<T, INNER extends AbstractConfigListEntry<T>>
    extends AbstractListListEntry.AbstractListCell<T, NestedListCell<T, INNER>, NestedListListEntry<T, INNER>>
    implements ReferenceProvider<T> {
        private final INNER nestedEntry;

        @ApiStatus.Internal
        public NestedListCell(@Nullable T value, NestedListListEntry<T, INNER> listListEntry, INNER nestedEntry) {
            super(value, listListEntry);
            this.nestedEntry = nestedEntry;
        }

        @Override
        @NotNull
        public AbstractConfigEntry<T> provideReferenceEntry() {
            return this.nestedEntry;
        }

        @Override
        public T getValue() {
            return (T)this.nestedEntry.getValue();
        }

        @Override
        public Optional<Component> getError() {
            return ((AbstractConfigEntry)this.nestedEntry).getError();
        }

        @Override
        public int getCellHeight() {
            return ((AbstractConfigEntry)this.nestedEntry).getItemHeight();
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            ((DynamicEntryListWidget.Entry)this.nestedEntry).setParent(((NestedListListEntry)this.listListEntry).getParent());
            ((AbstractConfigEntry)this.nestedEntry).setScreen(((NestedListListEntry)this.listListEntry).getConfigScreen());
            ((AbstractConfigListEntry)this.nestedEntry).render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.nestedEntry);
        }

        @Override
        public boolean isRequiresRestart() {
            return ((AbstractConfigListEntry)this.nestedEntry).isRequiresRestart();
        }

        @Override
        public void updateSelected(boolean isSelected) {
            ((AbstractConfigEntry)this.nestedEntry).updateSelected(isSelected);
        }

        @Override
        public boolean isEdited() {
            return super.isEdited() || ((AbstractConfigEntry)this.nestedEntry).isEdited();
        }

        @Override
        public void onAdd() {
            super.onAdd();
            ((NestedListListEntry)this.listListEntry).referencableEntries.add((ReferenceProvider<?>)this.nestedEntry);
            ((NestedListListEntry)this.listListEntry).requestReferenceRebuilding();
        }

        @Override
        public void onDelete() {
            super.onDelete();
            ((NestedListListEntry)this.listListEntry).referencableEntries.remove(this.nestedEntry);
            ((NestedListListEntry)this.listListEntry).requestReferenceRebuilding();
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

