/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.lib.util.EnumUtils;

public enum MaterialGrade {
    NONE(0),
    E(1),
    D(2),
    C(3),
    B(4),
    A(5),
    S(10),
    SS(15),
    SSS(25),
    MAX(30);

    public static final Codec<MaterialGrade> CODEC;
    public static final StreamCodec<FriendlyByteBuf, MaterialGrade> STREAM_CODEC;
    public final int bonusPercent;

    private MaterialGrade(int bonusPercent) {
        this.bonusPercent = bonusPercent;
    }

    public static MaterialGrade getMax() {
        return MaterialGrade.values()[MaterialGrade.values().length - 1];
    }

    public static MaterialGrade fromStack(ItemStack stack) {
        MaterialGrade grade = (MaterialGrade)((Object)stack.get(SgDataComponents.MATERIAL_GRADE));
        return grade != null ? grade : NONE;
    }

    public static MaterialGrade fromString(String str) {
        if (!str.isEmpty()) {
            for (MaterialGrade grade : MaterialGrade.values()) {
                if (!grade.name().equalsIgnoreCase(str)) continue;
                return grade;
            }
        }
        return NONE;
    }

    private static Optional<MaterialGrade> byNameOptional(String name) {
        for (MaterialGrade grade : MaterialGrade.values()) {
            if (!grade.name().equalsIgnoreCase(name)) continue;
            return Optional.of(grade);
        }
        return Optional.empty();
    }

    public static MaterialGrade selectWithCatalyst(Random random, @Nonnegative int catalystTier) {
        int ordinal = ((MaterialGrade)((Object)Config.Common.graderMedianGrade.get())).ordinal() + catalystTier - 1;
        MaterialGrade median = (MaterialGrade)EnumUtils.byOrdinal((int)ordinal, (Enum)MaterialGrade.getMax());
        return MaterialGrade.selectRandom(random, median, (Double)Config.Common.graderStandardDeviation.get(), MaterialGrade.getMax());
    }

    public static MaterialGrade selectRandom(Random random, MaterialGrade median, double stdDev, MaterialGrade maxGrade) {
        int val = (int)Math.round(stdDev * random.nextGaussian() + (double)median.ordinal());
        val = Mth.clamp((int)val, (int)1, (int)maxGrade.ordinal());
        return MaterialGrade.values()[val];
    }

    public void setGradeOnStack(@Nonnull ItemStack stack) {
        if (!stack.isEmpty()) {
            stack.set(SgDataComponents.MATERIAL_GRADE, (Object)this);
        }
    }

    public ItemStack copyWithGrade(@Nonnull ItemStack stack) {
        ItemStack ret = stack.copy();
        this.setGradeOnStack(ret);
        return ret;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)("grade.silentgear." + this.name()));
    }

    static {
        CODEC = Codec.STRING.flatXmap(name -> MaterialGrade.byNameOptional(name).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown material grade: " + name)), grade -> Optional.of(grade.name()).map(DataResult::success).get());
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(MaterialGrade.class);
    }

    public static class Range {
        public static final Range OPEN = new Range(NONE, MaterialGrade.getMax());
        private final MaterialGrade min;
        private final MaterialGrade max;

        public Range(MaterialGrade min, MaterialGrade max) {
            this.min = min;
            this.max = max;
            if (this.min.ordinal() > this.max.ordinal()) {
                throw new IllegalArgumentException("min grade is greater than max grade");
            }
        }

        public boolean test(MaterialGrade grade) {
            int o = grade.ordinal();
            return o >= this.min.ordinal() && o <= this.max.ordinal();
        }

        public static Range deserialize(JsonElement json) {
            if (json.isJsonPrimitive()) {
                MaterialGrade grade = MaterialGrade.fromString(json.getAsString());
                return grade != NONE ? new Range(grade, grade) : OPEN;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            String min = GsonHelper.getAsString((JsonObject)jsonObject, (String)"min", (String)"NONE");
            String max = GsonHelper.getAsString((JsonObject)jsonObject, (String)"max", (String)"MAX");
            return new Range(MaterialGrade.fromString(min), MaterialGrade.fromString(max));
        }
    }
}

