/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class ColorUtils {
    public static final Cache<String, Map<PartType, Integer>> GEAR_COLOR_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    private ColorUtils() {
    }

    public static int getBlendedColor(GearItem item, PartInstance part, Collection<? extends MaterialInstance> materials) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (MaterialInstance materialInstance : materials) {
            int color = materialInstance.getColor(item.getGearType(), part.getType());
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = (materials.size() - i) * (materials.size() - i);
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    @Deprecated(forRemoval=true)
    public static int getBlendedColor(CompoundPartItem item, Collection<? extends MaterialInstance> materials) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (MaterialInstance materialInstance : materials) {
            int color = materialInstance.getColor(item.getGearType(), item.getPartType());
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = item.getColorWeight(i, materials.size());
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    public static int getBlendedColorForCompoundMaterial(Collection<? extends MaterialInstance> materials) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        for (MaterialInstance materialInstance : materials) {
            int color = materialInstance.getColor((GearType)GearTypes.ALL.get(), (PartType)PartTypes.MAIN.get());
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            maxColorSum += Math.max(r, Math.max(g, b));
            componentSums[0] = componentSums[0] + r;
            componentSums[1] = componentSums[1] + g;
            componentSums[2] = componentSums[2] + b;
            ++colorCount;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    private static int blendColors(int[] componentSums, float maxColorSum, int colorCount) {
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            return finalColor | 0xFF000000;
        }
        return -1;
    }

    public static int getBlendedColorForPartInGear(ItemStack stack, PartType partType) {
        if (ColorUtils.hasCachedColor(stack, partType, 0)) {
            return ColorUtils.getCachedColor(stack, partType, 0);
        }
        List<PartInstance> list = GearData.getConstruction(stack).parts().getPartsOfType(partType);
        if (!list.isEmpty()) {
            PartInstance part = list.getFirst();
            int color = part.getColor(GearHelper.getType(stack), 0, 0);
            ColorUtils.setCachedColor(stack, partType, 0, color);
            return color;
        }
        return -1;
    }

    public static boolean hasCachedColor(ItemStack stack, PartType partType, int animationFrame) {
        String modelKey = GearData.getModelKey(stack, animationFrame);
        Map map = (Map)GEAR_COLOR_CACHE.getIfPresent((Object)modelKey);
        return map != null && map.containsKey(partType);
    }

    public static int getCachedColor(ItemStack stack, PartType partType, int animationFrame) {
        Map partTypeMap = (Map)GEAR_COLOR_CACHE.getIfPresent((Object)GearData.getModelKey(stack, animationFrame));
        if (partTypeMap != null) {
            return partTypeMap.getOrDefault(partType, -1);
        }
        return -1;
    }

    public static void setCachedColor(ItemStack stack, PartType partType, int animationFrame, int color) {
        String modelKey = GearData.getModelKey(stack, animationFrame);
        HashMap<PartType, Integer> map = (HashMap<PartType, Integer>)GEAR_COLOR_CACHE.getIfPresent((Object)modelKey);
        if (map == null) {
            map = new HashMap<PartType, Integer>();
            GEAR_COLOR_CACHE.put((Object)modelKey, map);
        }
        map.put(partType, color);
    }
}

