/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.util.TextUtil;

public class GearCraftingRecipeCategoryJei
implements IRecipeCategory<CraftingRecipe> {
    public static final int WIDTH = 160;
    public static final int HEIGHT = 132;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public GearCraftingRecipeCategoryJei(IGuiHelper guiHelper) {
        ResourceLocation location = SilentGear.getId("textures/gui/gear_crafting_jei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 160, 132);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)SgItems.BLUEPRINT_PACKAGE.toStack());
        this.localizedName = TextUtil.translate("jei", "group.gearCrafting");
    }

    public int getWidth() {
        return 160;
    }

    public int getHeight() {
        return 132;
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return SGearJeiPlugin.GEAR_CRAFTING_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CraftingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(recipe.getResultItem(null)));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = x + y * 3;
                IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1);
                if (index >= recipe.getIngredients().size()) continue;
                slotBuilder.addIngredients((Ingredient)recipe.getIngredients().get(index));
            }
        }
    }

    public void draw(CraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        NonNullList ingredients = recipe.getIngredients();
        for (int i = 0; i < ingredients.size(); ++i) {
            IGearIngredient gearIngredient;
            Component text;
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            ICustomIngredient iCustomIngredient = ingredient.getCustomIngredient();
            if (!(iCustomIngredient instanceof IGearIngredient) || (text = (Component)(gearIngredient = (IGearIngredient)iCustomIngredient).getJeiHint().orElse(null)) == null) continue;
            String string = i + 1 + ": ";
            lines.add(Component.literal((String)string).append(text));
        }
        guiGraphics.pose().pushPose();
        float scale = lines.size() > 5 ? 0.75f : 1.0f;
        guiGraphics.pose().scale(scale, scale, 1.0f);
        Font font = Minecraft.getInstance().font;
        int y = (int)(56.0f / scale);
        for (Component component : lines) {
            guiGraphics.drawString(font, component.getVisualOrderText(), 0, y, -1, true);
            y += 10;
        }
        guiGraphics.pose().popPose();
    }
}

