/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.loot;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.silentchaos512.gear.loot.condition.HasTraitCondition;
import net.silentchaos512.gear.loot.modifier.BonusDropsTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.FortuneTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.MagmaticTraitLootModifier;
import net.silentchaos512.gear.loot.modifier.SilkTouchTraitLootModifier;
import net.silentchaos512.gear.setup.SgLoot;
import net.silentchaos512.gear.util.Const;

public class ModLootModifierProvider
extends GlobalLootModifierProvider {
    public ModLootModifierProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), "silentgear");
    }

    protected void start() {
        this.add("bonus_drops_trait", (IGlobalLootModifier)new BonusDropsTraitLootModifier(new LootItemCondition[0]), new ICondition[0]);
        this.add("magmatic_smelting", (IGlobalLootModifier)new MagmaticTraitLootModifier(new LootItemCondition[]{HasTraitCondition.builder(Const.Traits.MAGMATIC).build()}), new ICondition[0]);
        this.add("silk_touch_trait", (IGlobalLootModifier)new SilkTouchTraitLootModifier(new LootItemCondition[]{HasTraitCondition.builder(Const.Traits.SILKY).build()}), new ICondition[0]);
        this.add("fortune_trait_1", (IGlobalLootModifier)new FortuneTraitLootModifier(1, new LootItemCondition[]{HasTraitCondition.builder(Const.Traits.FORTUNATE, 1, 1).build()}), new ICondition[0]);
        this.add("fortune_trait_2", (IGlobalLootModifier)new FortuneTraitLootModifier(2, new LootItemCondition[]{HasTraitCondition.builder(Const.Traits.FORTUNATE, 2, 2).build()}), new ICondition[0]);
        this.add("fortune_trait_3", (IGlobalLootModifier)new FortuneTraitLootModifier(3, new LootItemCondition[]{HasTraitCondition.builder(Const.Traits.FORTUNATE, 3, 3).build()}), new ICondition[0]);
        this.add("add_mob_drops/sinew", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{ModLootModifierProvider.anyOfLootTables(List.of(EntityType.COW.getDefaultLootTable(), EntityType.PIG.getDefaultLootTable(), BuiltInLootTables.SHEEP_BLACK, BuiltInLootTables.SHEEP_BLUE, BuiltInLootTables.SHEEP_BROWN, BuiltInLootTables.SHEEP_CYAN, BuiltInLootTables.SHEEP_GRAY, BuiltInLootTables.SHEEP_GREEN, BuiltInLootTables.SHEEP_LIGHT_BLUE, BuiltInLootTables.SHEEP_LIGHT_GRAY, BuiltInLootTables.SHEEP_LIME, BuiltInLootTables.SHEEP_MAGENTA, BuiltInLootTables.SHEEP_ORANGE, BuiltInLootTables.SHEEP_PINK, BuiltInLootTables.SHEEP_PURPLE, BuiltInLootTables.SHEEP_RED, BuiltInLootTables.SHEEP_WHITE, BuiltInLootTables.SHEEP_YELLOW))}, SgLoot.Tables.DROPS_SINEW), new ICondition[0]);
        this.add("add_mob_drops/fine_silk_low", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{ModLootModifierProvider.anyOfLootTables(List.of(EntityType.SPIDER.getDefaultLootTable()))}, SgLoot.Tables.DROPS_FINE_SILK_LOW), new ICondition[0]);
        this.add("add_mob_drops/fine_silk_high", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{ModLootModifierProvider.anyOfLootTables(List.of(EntityType.CAVE_SPIDER.getDefaultLootTable()))}, SgLoot.Tables.DROPS_FINE_SILK_HIGH), new ICondition[0]);
        this.add("add_mob_drops/leather_scraps_low", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{ModLootModifierProvider.anyOfLootTables(List.of(EntityType.HUSK.getDefaultLootTable(), EntityType.ZOMBIE.getDefaultLootTable()))}, SgLoot.Tables.DROPS_LEATHER_SCRAPS_LOW), new ICondition[0]);
        this.add("add_mob_drops/leather_scraps_high", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{ModLootModifierProvider.anyOfLootTables(List.of(EntityType.ZOMBIE_VILLAGER.getDefaultLootTable()))}, SgLoot.Tables.DROPS_LEATHER_SCRAPS_HIGH), new ICondition[0]);
    }

    private static LootItemCondition anyOfLootTables(List<ResourceKey<LootTable>> lootTables) {
        LootTableIdCondition.Builder[] array = (LootTableIdCondition.Builder[])lootTables.stream().map(ResourceKey::location).map(LootTableIdCondition::builder).toArray(LootTableIdCondition.Builder[]::new);
        return AnyOfCondition.anyOf((LootItemCondition.Builder[])array).build();
    }
}

