/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.GearHelper;

public class TargetEffectTraitEffect
extends TraitEffect {
    public static final MapCodec<TargetEffectTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(GearType.CODEC, EffectMap.CODEC).fieldOf("effects_by_level").forGetter(e -> e.effects)).apply((Applicative)instance, TargetEffectTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TargetEffectTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, GearType.STREAM_CODEC, EffectMap.STREAM_CODEC), e -> e.effects, TargetEffectTraitEffect::new);
    private final Map<GearType, EffectMap> effects = new LinkedHashMap<GearType, EffectMap>();

    public TargetEffectTraitEffect(Map<GearType, EffectMap> effects) {
        this.effects.putAll(effects);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.TARGET_EFFECT.get();
    }

    @Override
    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        GearType typeOfGear = GearHelper.getType(context.gear());
        for (GearType gearTypeInMap : this.effects.keySet()) {
            if (!typeOfGear.matches(gearTypeInMap)) continue;
            this.effects.get(gearTypeInMap).applyTo(target, context.traitLevel());
        }
        return super.onAttackEntity(context, target, baseValue);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        this.effects.forEach((type, map) -> {
            ret.add("  - " + String.valueOf(type));
            ret.addAll(map.getWikiLines());
        });
        return ret;
    }

    public static class Builder {
        private final Map<GearType, EffectMap> map = new LinkedHashMap<GearType, EffectMap>();

        public Builder add(Supplier<GearType> gearType, int traitLevel, MobEffectInstance effect) {
            EffectMap effectMap = this.map.computeIfAbsent(gearType.get(), gt -> new EffectMap());
            List effectList = effectMap.effects.computeIfAbsent(traitLevel, lvl -> new ArrayList());
            effectList.add(effect);
            return this;
        }

        public Builder addWithDurationByLevel(Supplier<GearType> gearType, Holder<MobEffect> effect, int maxLevel, float baseDurationInSeconds) {
            int baseDurationInTicks = (int)(baseDurationInSeconds * 20.0f);
            for (int level = 1; level <= maxLevel; ++level) {
                this.add(gearType, level, new MobEffectInstance(effect, baseDurationInTicks * level));
            }
            return this;
        }

        public TargetEffectTraitEffect build() {
            return new TargetEffectTraitEffect(this.map);
        }
    }

    public static class EffectMap {
        private static final Codec<Integer> KEY_CODEC = Codec.STRING.comapFlatMap(str -> {
            try {
                int value = Integer.parseInt(str);
                if (value > 0) {
                    return DataResult.success((Object)value);
                }
                return DataResult.error(() -> "Level key must be positive: " + value);
            }
            catch (NumberFormatException ex) {
                return DataResult.error(() -> "Not a number: " + str);
            }
        }, Object::toString);
        public static final Codec<EffectMap> CODEC = Codec.unboundedMap(KEY_CODEC, (Codec)Codec.list((Codec)MobEffectInstance.CODEC)).xmap(EffectMap::new, effectMap -> effectMap.effects);
        public static final StreamCodec<RegistryFriendlyByteBuf, EffectMap> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.VAR_INT, (StreamCodec)MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list())), map -> map.effects, EffectMap::new);
        private final Map<Integer, List<MobEffectInstance>> effects = new LinkedHashMap<Integer, List<MobEffectInstance>>();

        public EffectMap() {
        }

        public EffectMap(Map<Integer, List<MobEffectInstance>> effects) {
            this.effects.putAll(effects);
        }

        public void applyTo(LivingEntity target, int traitLevel) {
            if (this.effects.containsKey(traitLevel)) {
                for (MobEffectInstance effect : this.effects.get(traitLevel)) {
                    MobEffectInstance copy = new MobEffectInstance(effect);
                    target.addEffect(copy);
                }
            }
        }

        public Collection<String> getWikiLines() {
            ArrayList<String> ret = new ArrayList<String>();
            this.effects.forEach((level, list) -> {
                ret.add("    - Level " + level + ":");
                list.forEach(effect -> ret.add("      - " + String.valueOf(effect)));
            });
            return ret;
        }
    }
}

