/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint.book;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.item.IContainerItem;
import net.silentchaos512.gear.item.ICycleItem;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainerMenu;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

public class BlueprintBookItem
extends Item
implements IBlueprint,
IContainerItem,
ICycleItem {
    public static final int INVENTORY_SIZE = 54;

    public BlueprintBookItem(Item.Properties properties) {
        super(properties);
    }

    private static int clampSelectedSlot(int slot) {
        return Mth.clamp((int)slot, (int)0, (int)53);
    }

    public static int getSelectedSlot(ItemStack book) {
        return BlueprintBookItem.clampSelectedSlot((Integer)book.getOrDefault(SgDataComponents.SELECTED_SLOT, (Object)0));
    }

    public static void setSelectedSlot(ItemStack book, int slot) {
        book.set(SgDataComponents.SELECTED_SLOT, (Object)BlueprintBookItem.clampSelectedSlot(slot));
    }

    private ItemStack getSelectedItem(ItemStack book) {
        return this.getInventory(book).getStackInSlot(BlueprintBookItem.getSelectedSlot(book));
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.isEmpty() && this.canStore(selected)) {
            return ((AbstractBlueprintItem)selected.getItem()).getPartType(selected);
        }
        return (PartType)PartTypes.MISC_UPGRADE.get();
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.isEmpty() && this.canStore(selected)) {
            return ((AbstractBlueprintItem)selected.getItem()).getGearType(selected);
        }
        return (GearType)GearTypes.NONE.get();
    }

    @Override
    public int getInventorySize(ItemStack stack) {
        return 54;
    }

    @Override
    public boolean canStore(ItemStack stack) {
        Item item = stack.getItem();
        return item instanceof AbstractBlueprintItem && !((AbstractBlueprintItem)item).isSingleUse();
    }

    public static void openContainer(ServerPlayer playerIn, ItemStack stack) {
        playerIn.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, z) -> new BlueprintBookContainerMenu(id, inv, stack), (Component)Component.translatable((String)"container.silentgear.blueprint_book")), buf -> ItemStack.STREAM_CODEC.encode(buf, (Object)stack));
    }

    @Override
    public void onCycleKeyPress(ItemStack stack, ICycleItem.Direction direction) {
        int current = BlueprintBookItem.getSelectedSlot(stack);
        ComponentItemHandler inventory = this.getInventory(stack);
        for (int i = 1; i <= inventory.getSlots(); ++i) {
            ItemStack inSlot;
            int index = current + i * direction.scale;
            if (index < 0) {
                index += inventory.getSlots();
            }
            if (index >= inventory.getSlots()) {
                index -= inventory.getSlots();
            }
            if ((inSlot = inventory.getStackInSlot(index)).isEmpty()) continue;
            BlueprintBookItem.setSelectedSlot(stack, index);
            return;
        }
        if (this.getSelectedItem(stack).isEmpty()) {
            BlueprintBookItem.setSelectedSlot(stack, 0);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!worldIn.isClientSide) {
            BlueprintBookItem.openContainer((ServerPlayer)playerIn, stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public ItemStack createdFullyLoadedBook() {
        ItemStack filled = new ItemStack((ItemLike)this);
        ComponentItemHandler inventory = this.getInventory(filled);
        ArrayList<Item> blueprints = new ArrayList<Item>(SgItems.getItems(item -> this.canStore(new ItemStack((ItemLike)item))));
        for (int i = 0; i < blueprints.size() && i < this.getInventorySize(filled); ++i) {
            inventory.insertItem(i, new ItemStack((ItemLike)blueprints.get(i)), false);
        }
        filled.set(DataComponents.CUSTOM_NAME, (Object)TextUtil.translate("item", "blueprint_book.fully_loaded"));
        return filled;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        ItemStack selected = this.getSelectedItem(stack);
        if (!selected.isEmpty()) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.translate("item", "blueprint_book.selected"), Color.SKYBLUE).append((Component)selected.getHoverName().copy().withStyle(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)TextUtil.translate("item", "blueprint_book.keyHint", TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_BACK), Color.AQUAMARINE), TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_NEXT), Color.AQUAMARINE)));
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.copy();
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }
}

