/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.turtleboi.bytebuddies.block.custom.BluestoneOreBlock;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.custom.GeneratorBlock;
import net.turtleboi.bytebuddies.block.custom.SolarPanelBlock;
import net.turtleboi.bytebuddies.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"bytebuddies");
    public static final DeferredBlock<Block> BAUXITE_ORE = ModBlocks.registerBlock("bauxite_ore", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)));
    public static final DeferredBlock<Block> DEEPSLATE_BAUXITE_ORE = ModBlocks.registerBlock("deepslate_bauxite_ore", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)));
    public static final DeferredBlock<Block> ALUMINUM_BLOCK = ModBlocks.registerBlock("aluminum_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> STEEL_BLOCK = ModBlocks.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> CHARGED_STEEL_BLOCK = ModBlocks.registerBlock("charged_steel_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> BLUESTONE_ORE = ModBlocks.registerBlock("bluestone_ore", () -> new BluestoneOreBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().randomTicks().lightLevel(ModBlocks.litBlockEmission(9)).strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> DEEPSLATE_BLUESTONE_ORE = ModBlocks.registerBlock("deepslate_bluestone_ore", () -> new BluestoneOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)BLUESTONE_ORE.get())).mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE)));
    public static final DeferredBlock<Block> BLUESTONE_BLOCK = ModBlocks.registerBlock("bluestone_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_BLOCK)));
    public static final DeferredBlock<Block> DOCKING_STATION = ModBlocks.registerBlock("docking_station", () -> new DockingStationBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> GENERATOR = ModBlocks.registerBlock("generator", () -> new GeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final DeferredBlock<Block> SOLAR_PANEL = ModBlocks.registerBlock("solar_panel", () -> new SolarPanelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }
}

