/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block.entity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.ByteBuddies;
import net.turtleboi.bytebuddies.block.ModBlockEntities;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.custom.BatteryItem;
import net.turtleboi.bytebuddies.item.custom.ClipboardItem;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockingStationBlockEntity
extends BlockEntity
implements IEnergyStorage,
MenuProvider {
    public final int mainInvSize = 27;
    public static final int batterySlot = 0;
    public static final int clipboardSlot = 1;
    public final int totalInvSize = 29;
    private final ItemStackHandler mainInv = new ItemStackHandler(29){

        public boolean isItemValid(int slot, @NotNull ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            if (slot == 0) {
                return InventoryUtil.isBattery(itemStack);
            }
            if (slot == 1) {
                return itemStack.getItem() instanceof ClipboardItem;
            }
            return true;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack itemStack) {
            if (slot == 0 || slot == 1) {
                return 1;
            }
            return 64;
        }

        protected void onContentsChanged(int slot) {
            DockingStationBlockEntity.this.setChanged();
            if (DockingStationBlockEntity.this.level != null && !((DockingStationBlockEntity)DockingStationBlockEntity.this).level.isClientSide) {
                DockingStationBlockEntity.this.level.sendBlockUpdated(DockingStationBlockEntity.this.getBlockPos(), DockingStationBlockEntity.this.getBlockState(), DockingStationBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final Set<UUID> boundBuddies = new HashSet<UUID>();
    public int dockBaseRadius = 4;
    private final EnergyStorage energyStorage = new EnergyStorage(48000, 640, 640);
    private int tickCount = 0;
    private final Map<TaskKey, Reservation> reservations = new HashMap<TaskKey, Reservation>();

    public DockingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlockEntities.DOCKING_STATION_BE.get(), blockPos, blockState);
    }

    public void addBoundBuddy(ByteBuddyEntity byteBuddy) {
        if (this.boundBuddies.add(byteBuddy.getUUID())) {
            ByteBuddies.LOGGER.info("[ByteBuddies] dock {} added bot {}", (Object)this.worldPosition, (Object)byteBuddy.getUUID());
            this.setChanged();
        }
    }

    public void removeBoundBuddy(ByteBuddyEntity byteBuddy) {
        if (this.boundBuddies.remove(byteBuddy.getUUID())) {
            ByteBuddies.LOGGER.info("[ByteBuddies] dock {} removed bot {}", (Object)this.worldPosition, (Object)byteBuddy.getUUID());
            this.setChanged();
        }
    }

    public Set<UUID> getBoundBuddyUUIDs() {
        return Collections.unmodifiableSet(this.boundBuddies);
    }

    public List<Integer> findByteBuddyEntityIds(ServerLevel serverLevel) {
        ArrayList<Integer> byteBuddyIds = new ArrayList<Integer>();
        for (UUID uuid : this.boundBuddies) {
            Entity entity = serverLevel.getEntity(uuid);
            if (!(entity instanceof ByteBuddyEntity)) continue;
            ByteBuddyEntity byteBuddy = (ByteBuddyEntity)entity;
            byteBuddyIds.add(byteBuddy.getId());
        }
        return byteBuddyIds;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (level != null) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.pruneReservations(serverLevel);
            }
            ++this.tickCount;
            if (this.tickCount % 20 == 0) {
                this.consumeEnergy(this.boundBuddies.size() * 25);
                BatteryItem.dockBlockDrainBatteries(this);
            }
            AABB boundingBox = new AABB(blockPos).inflate((double)this.dockBaseRadius);
            for (ByteBuddyEntity byteBuddyEntity : level.getEntitiesOfClass(ByteBuddyEntity.class, boundingBox)) {
            }
        }
    }

    public ItemStackHandler getMainInv() {
        return this.mainInv;
    }

    public ItemStack getBatteryStack() {
        return this.mainInv.getStackInSlot(0);
    }

    public ItemStack getClipboardStack() {
        return this.mainInv.getStackInSlot(1);
    }

    @Nullable
    public BlockPos getFirstPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getFirstPosition(clipboard).orElse(null);
    }

    @Nullable
    public BlockPos getSecondPos() {
        ItemStack clipboard = this.getClipboardStack();
        return ClipboardItem.getSecondPosition(clipboard).orElse(null);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setEnergyUnsafe(int value) {
        try {
            Field storedEnergy = EnergyStorage.class.getDeclaredField("energy");
            storedEnergy.setAccessible(true);
            storedEnergy.setInt(this.energyStorage, Mth.clamp((int)value, (int)0, (int)this.energyStorage.getMaxEnergyStored()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveAdditional(CompoundTag nbtData, HolderLookup.Provider registries) {
        super.saveAdditional(nbtData, registries);
        ListTag dataList = new ListTag();
        for (UUID id : this.boundBuddies) {
            dataList.add((Object)StringTag.valueOf((String)id.toString()));
        }
        nbtData.put("BoundBots", (Tag)dataList);
        nbtData.put("MainInv", (Tag)this.mainInv.serializeNBT(registries));
        nbtData.putInt("Energy", this.energyStorage.getEnergyStored());
    }

    protected void loadAdditional(CompoundTag nbtData, HolderLookup.Provider registries) {
        super.loadAdditional(nbtData, registries);
        this.boundBuddies.clear();
        ListTag dataList = nbtData.getList("BoundBots", 8);
        for (int i = 0; i < dataList.size(); ++i) {
            this.boundBuddies.add(UUID.fromString(dataList.getString(i)));
        }
        if (nbtData.contains("MainInv")) {
            this.mainInv.deserializeNBT(registries, nbtData.getCompound("MainInv"));
        }
        this.setChanged();
        if (nbtData.contains("Energy")) {
            this.setEnergyUnsafe(nbtData.getInt("Energy"));
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.bytebuddies.docking_station");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.mainInv.getSlots());
        for (int i = 0; i < this.mainInv.getSlots(); ++i) {
            inventory.setItem(i, this.mainInv.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    private static long currentTime(ServerLevel serverLevel) {
        return serverLevel.getGameTime();
    }

    private static long reservationTime(long time, int ticks) {
        return time + (long)ticks;
    }

    public void pruneReservations(ServerLevel serverLevel) {
        long time = DockingStationBlockEntity.currentTime(serverLevel);
        this.reservations.entrySet().removeIf(entry -> ((Reservation)entry.getValue()).expiresAt <= time);
    }

    public boolean isReserved(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
        this.pruneReservations(serverLevel);
        return this.reservations.containsKey(new TaskKey(taskType, blockPos));
    }

    public boolean isReservedBy(ServerLevel serverLevel, ByteBuddyEntity.TaskType task, BlockPos blockPos, UUID buddyId) {
        this.pruneReservations(serverLevel);
        Reservation reservation = this.reservations.get(new TaskKey(task, blockPos));
        return reservation != null && reservation.buddyId.equals(buddyId);
    }

    public boolean tryClaim(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, BlockPos blockPos, UUID buddyId, int reservationTicks) {
        this.pruneReservations(serverLevel);
        TaskKey taskKey = new TaskKey(taskType, blockPos);
        Reservation reservation = this.reservations.get(taskKey);
        if (reservation != null && !reservation.buddyId.equals(buddyId)) {
            return false;
        }
        this.reservations.put(taskKey, new Reservation(buddyId, DockingStationBlockEntity.reservationTime(DockingStationBlockEntity.currentTime(serverLevel), reservationTicks)));
        return true;
    }

    public void renewClaim(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, BlockPos blockPos, UUID buddyId, int reservationTicks) {
        TaskKey taskKey = new TaskKey(taskType, blockPos);
        Reservation reservation = this.reservations.get(taskKey);
        if (reservation != null && reservation.buddyId.equals(buddyId)) {
            reservation.expiresAt = DockingStationBlockEntity.reservationTime(DockingStationBlockEntity.currentTime(serverLevel), reservationTicks);
        }
    }

    public void releaseClaim(ByteBuddyEntity.TaskType taskType, BlockPos blockPos, UUID buddyId) {
        TaskKey taskKey = new TaskKey(taskType, blockPos);
        Reservation reservation = this.reservations.get(taskKey);
        if (reservation != null && reservation.buddyId.equals(buddyId)) {
            this.reservations.remove(taskKey);
        }
    }

    public void releaseAllFor(UUID buddyId) {
        this.reservations.entrySet().removeIf(e -> ((Reservation)e.getValue()).buddyId.equals(buddyId));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(toExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public boolean consumeEnergy(int energyCost) {
        if (this.energyStorage.getEnergyStored() >= energyCost) {
            this.energyStorage.extractEnergy(energyCost, false);
            return true;
        }
        return false;
    }

    private record TaskKey(ByteBuddyEntity.TaskType taskType, BlockPos blockPos) {
    }

    private static final class Reservation {
        final UUID buddyId;
        long expiresAt;

        Reservation(UUID buddyId, long expiresAt) {
            this.buddyId = buddyId;
            this.expiresAt = expiresAt;
        }
    }
}

