/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.block.entity;

import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.ModBlockEntities;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.item.custom.BatteryItem;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BlockEntity
implements IEnergyStorage,
MenuProvider {
    private int progress = 0;
    private int maxProgress = 0;
    private final EnergyStorage energyStorage = new EnergyStorage(48000, 640, 640);
    private final ItemStackHandler fuelSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            return AbstractFurnaceBlockEntity.isFuel((ItemStack)itemStack);
        }

        protected int getStackLimit(int slot, @NotNull ItemStack itemStack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.setChanged();
            if (!GeneratorBlockEntity.this.level.isClientSide()) {
                GeneratorBlockEntity.this.level.sendBlockUpdated(GeneratorBlockEntity.this.getBlockPos(), GeneratorBlockEntity.this.getBlockState(), GeneratorBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final ItemStackHandler batterySlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            return InventoryUtil.isBattery(itemStack);
        }

        protected int getStackLimit(int slot, @NotNull ItemStack itemStack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.setChanged();
            if (!GeneratorBlockEntity.this.level.isClientSide()) {
                GeneratorBlockEntity.this.level.sendBlockUpdated(GeneratorBlockEntity.this.getBlockPos(), GeneratorBlockEntity.this.getBlockState(), GeneratorBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private int tickCount = 0;

    public GeneratorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.GENERATOR_BE.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return null;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (level != null) {
            ItemStack fuelItemStack = this.getFuelSlot().getStackInSlot(0);
            if (!fuelItemStack.isEmpty() && this.progress <= 0 && this.maxProgress == 0) {
                this.maxProgress = fuelItemStack.getBurnTime(RecipeType.SMELTING);
                ++this.progress;
                GeneratorBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
                fuelItemStack.shrink(1);
            } else if (this.progress < this.maxProgress) {
                ++this.progress;
                this.generateEnergy(16);
            } else {
                this.resetProgress();
            }
            ++this.tickCount;
            if (this.tickCount % 20 == 0) {
                this.pushEnergyToNeighbors();
                this.giveBatteryEnergy();
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.setChanged();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.batterySlot.getSlots());
        for (int i = 0; i < this.batterySlot.getSlots(); ++i) {
            inventory.setItem(i, this.batterySlot.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public ItemStackHandler getBatterySlot() {
        return this.batterySlot;
    }

    public ItemStackHandler getFuelSlot() {
        return this.fuelSlot;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private void setEnergyUnsafe(int value) {
        try {
            Field storedEnergy = EnergyStorage.class.getDeclaredField("energy");
            storedEnergy.setAccessible(true);
            storedEnergy.setInt(this.energyStorage, Mth.clamp((int)value, (int)0, (int)this.energyStorage.getMaxEnergyStored()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveAdditional(CompoundTag nbtData, HolderLookup.Provider registries) {
        super.saveAdditional(nbtData, registries);
        nbtData.putInt("progress", this.progress);
        nbtData.putInt("maxProgress", this.maxProgress);
        nbtData.put("BatterySlot", (Tag)this.batterySlot.serializeNBT(registries));
        nbtData.put("FuelSlot", (Tag)this.fuelSlot.serializeNBT(registries));
        nbtData.putInt("Energy", this.energyStorage.getEnergyStored());
    }

    protected void loadAdditional(CompoundTag nbtData, HolderLookup.Provider registries) {
        super.loadAdditional(nbtData, registries);
        this.progress = nbtData.getInt("progress");
        this.maxProgress = nbtData.getInt("maxProgress");
        if (nbtData.contains("BatterySlot")) {
            this.batterySlot.deserializeNBT(registries, nbtData.getCompound("BatterySlot"));
        }
        if (nbtData.contains("FuelSlot")) {
            this.fuelSlot.deserializeNBT(registries, nbtData.getCompound("FuelSlot"));
        }
        this.setChanged();
        if (nbtData.contains("Energy")) {
            this.setEnergyUnsafe(nbtData.getInt("Energy"));
        }
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(toReceive, simulate);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(toExtract, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.energyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.energyStorage.canReceive();
    }

    public int generateEnergy(int energyGenerated) {
        int maxEnergy;
        int energyStored = this.energyStorage.getEnergyStored();
        if (energyStored < (maxEnergy = this.energyStorage.getMaxEnergyStored())) {
            int potentialEnergy = maxEnergy - energyStored;
            int energyActuallyGenerated = Math.min(potentialEnergy, Math.max(0, energyGenerated));
            int receivedEnergy = this.energyStorage.receiveEnergy(energyActuallyGenerated, false);
            if (receivedEnergy > 0) {
                this.setChanged();
            }
            return receivedEnergy;
        }
        return 0;
    }

    public int giveBatteryEnergy() {
        Item item;
        int energyMoved = 0;
        if (this.level == null || this.level.isClientSide) {
            return 0;
        }
        IEnergyStorage energySource = this.getEnergyStorage();
        ItemStack batteryInSlot = this.getBatterySlot().getStackInSlot(0);
        if (energySource != null && energySource.getEnergyStored() > 0 && !batteryInSlot.isEmpty() && (item = batteryInSlot.getItem()) instanceof BatteryItem) {
            int energyDrained;
            int acceptedEnergy;
            int canExtract;
            BatteryItem batteryItem = (BatteryItem)item;
            int missingEnergy = batteryItem.getCapacity() - batteryItem.getEnergy(batteryInSlot);
            int requestedEnergy = Math.min(missingEnergy, batteryItem.getIoRate());
            if (missingEnergy > 0 && requestedEnergy > 0 && (canExtract = energySource.extractEnergy(requestedEnergy, true)) > 0 && (acceptedEnergy = batteryItem.receive(batteryInSlot, canExtract, false)) > 0 && (energyDrained = energySource.extractEnergy(acceptedEnergy, false)) > 0) {
                energyMoved = energyDrained;
                this.setChanged();
            }
        }
        return energyMoved;
    }

    private void pushEnergyToNeighbors() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.energyStorage.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            int accepted;
            int canExtract;
            IEnergyStorage neighbor;
            BlockPos neighborPos = this.worldPosition.relative(direction);
            if (this.level.getBlockState(neighborPos).is(ModTags.Blocks.GENERATORS) || (neighbor = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite())) == null || !neighbor.canReceive() || (canExtract = this.energyStorage.extractEnergy(640, true)) <= 0 || (accepted = neighbor.receiveEnergy(canExtract, false)) <= 0) continue;
            this.energyStorage.extractEnergy(accepted, false);
            this.setChanged();
            if (this.energyStorage.getEnergyStored() <= 0) break;
        }
    }
}

