/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.datagen;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.turtleboi.bytebuddies.block.ModBlocks;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.item.ModItems;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BYTEBUDDY_SPAWN_EGG.get())).pattern("ACA").pattern("ASA").pattern("ABA").define(Character.valueOf('A'), (ItemLike)ModItems.ALUMINUM_PLATING.get()).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('B'), Ingredient.of(ModTags.Items.BATTERY)).unlockedBy("has_aluminum_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ALUMINUM_PLATING.get()))).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).unlockedBy("has_battery", ModRecipeProvider.has(ModTags.Items.BATTERY)).save(recipeOutput, "bytebuddies:spawner/byte_buddy_spawner");
        ModRecipeProvider.nineBlockCycle(recipeOutput, (ItemLike)ModItems.ALUMINUM_NUGGET.get(), (ItemLike)ModItems.ALUMINUM_INGOT.get(), (ItemLike)ModBlocks.ALUMINUM_BLOCK.get(), "aluminum/cycle");
        ModRecipeProvider.nineBlockCycle(recipeOutput, (ItemLike)ModItems.STEEL_NUGGET.get(), (ItemLike)ModItems.STEEL_INGOT.get(), (ItemLike)ModBlocks.STEEL_BLOCK.get(), "steel/cycle");
        ModRecipeProvider.nineBlockCycle(recipeOutput, (ItemLike)ModItems.CHARGED_STEEL_NUGGET.get(), (ItemLike)ModItems.CHARGED_STEEL_INGOT.get(), (ItemLike)ModBlocks.CHARGED_STEEL_BLOCK.get(), "charged_steel/cycle");
        ModRecipeProvider.smeltAndBlast(recipeOutput, (ItemLike)ModItems.RAW_BAUXITE.get(), (ItemLike)ModItems.ALUMINUM_INGOT.get(), 0.7f, 200, 100, "aluminum/bauxite_refine");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get())).pattern("BBB").pattern("BBB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)ModItems.BLUESTONE_DUST.get()).unlockedBy("has_bluestone", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.BLUESTONE_DUST.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.BLUESTONE_DUST.get()), (int)9).requires((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.SIMPLE_BATTERY.get())).pattern("PXP").pattern("IBI").pattern("PCP").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('X'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('C'), ModItems.CARBON_PASTE).define(Character.valueOf('P'), (ItemLike)ModItems.COPPER_PLATING.get()).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).unlockedBy("has_copper_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.COPPER_PLATING.get()))).unlockedBy("has_redstone", ModRecipeProvider.has((ItemLike)Items.REDSTONE)).unlockedBy("has_carbon_paste", ModRecipeProvider.has(ModItems.CARBON_PASTE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.ADVANCED_BATTERY.get())).pattern("PXP").pattern("GBG").pattern("PCP").define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('X'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('C'), ModItems.CARBON_PASTE).define(Character.valueOf('P'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ALUMINUM_PLATING.get(), (ItemLike)ModItems.IRON_PLATING.get()})).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).unlockedBy("has_gold", ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).unlockedBy("has_carbon_paste", ModRecipeProvider.has(ModItems.CARBON_PASTE)).unlockedBy("has_plate", ModRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.ALUMINUM_PLATING.get(), (ItemLike)ModItems.IRON_PLATING.get()}).build()})).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.BIOCELL_BATTERY.get())).pattern("PVP").pattern("HBH").pattern("PMP").define(Character.valueOf('V'), (ItemLike)Items.GLASS_BOTTLE).define(Character.valueOf('H'), (ItemLike)Items.HONEYCOMB).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('P'), (ItemLike)ModItems.GOLD_PLATING.get()).define(Character.valueOf('M'), (ItemLike)Blocks.MOSS_BLOCK).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).unlockedBy("has_gold_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.GOLD_PLATING.get()))).unlockedBy("has_honeycomb", ModRecipeProvider.has((ItemLike)Items.HONEYCOMB)).unlockedBy("has_moss", ModRecipeProvider.has((ItemLike)Blocks.MOSS_BLOCK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.REINFORCED_BATTERY.get())).pattern("PQP").pattern("OBO").pattern("PRP").define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_BLOCK).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('P'), (ItemLike)ModItems.STEEL_PLATING.get()).define(Character.valueOf('O'), (ItemLike)Blocks.OBSIDIAN).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).unlockedBy("has_steel_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.STEEL_PLATING.get()))).unlockedBy("has_quartz", ModRecipeProvider.has((ItemLike)Items.QUARTZ)).unlockedBy("has_redstone_block", ModRecipeProvider.has((ItemLike)Blocks.REDSTONE_BLOCK)).unlockedBy("has_obsidian", ModRecipeProvider.has((ItemLike)Blocks.OBSIDIAN)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.SUPER_CHARGED_BATTERY.get())).pattern("PNP").pattern("ZBZ").pattern("PEP").define(Character.valueOf('N'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('P'), (ItemLike)ModItems.CHARGED_STEEL_PLATING.get()).define(Character.valueOf('Z'), (ItemLike)Items.BLAZE_ROD).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).unlockedBy("has_charged_steel_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHARGED_STEEL_PLATING.get()))).unlockedBy("has_nether_star", ModRecipeProvider.has((ItemLike)Items.NETHER_STAR)).unlockedBy("has_ender_pearl", ModRecipeProvider.has((ItemLike)Items.ENDER_PEARL)).unlockedBy("has_blaze_rod", ModRecipeProvider.has((ItemLike)Items.BLAZE_ROD)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.WRENCH.get())).pattern(" I ").pattern(" CI").pattern("C  ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_iron", ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).unlockedBy("has_copper", ModRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.CLIPBOARD.get())).pattern("APA").pattern("ABA").pattern("APA").define(Character.valueOf('A'), ModItems.ALUMINUM_INGOT).define(Character.valueOf('B'), ModItems.BLUESTONE_DUST).define(Character.valueOf('P'), (ItemLike)Items.PAPER).unlockedBy("has_bluestone", ModRecipeProvider.has(ModItems.BLUESTONE_DUST)).unlockedBy("has_aluminum", ModRecipeProvider.has(ModItems.ALUMINUM_INGOT)).unlockedBy("has_paper", ModRecipeProvider.has((ItemLike)Items.PAPER)).save(recipeOutput, "bytebuddies:tools/clipboard");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CHIP.get())).pattern("CGC").pattern("QBQ").pattern("RGR").define(Character.valueOf('C'), ModItems.CARBON_PASTE).define(Character.valueOf('G'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('B'), (ItemLike)ModItems.BLUESTONE_DUST.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).unlockedBy("has_bluestone", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.BLUESTONE_DUST.get()))).unlockedBy("has_copper", ModRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).unlockedBy("has_quartz", ModRecipeProvider.has((ItemLike)Items.QUARTZ)).unlockedBy("has_redstone", ModRecipeProvider.has((ItemLike)Items.REDSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SUPER_CHIP.get())).pattern("GQG").pattern("RCB").pattern("GIG").define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_BLOCK).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('I'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).save(recipeOutput, "bytebuddies:electronics/super_chip");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CARBON_PASTE.get()), (int)2).requires((ItemLike)Items.COAL).requires((ItemLike)Items.CLAY_BALL).unlockedBy("has_coal", ModRecipeProvider.has((ItemLike)Items.COAL)).unlockedBy("has_clay", ModRecipeProvider.has((ItemLike)Items.CLAY_BALL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.COPPER_PLATING.get()), (int)3).pattern("CC").define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_copper", ModRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ALUMINUM_PLATING.get()), (int)3).pattern("AA").define(Character.valueOf('A'), (ItemLike)ModItems.ALUMINUM_INGOT.get()).unlockedBy("has_aluminum_ingot", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ALUMINUM_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.IRON_PLATING.get()), (int)3).pattern("II").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_iron", ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.GOLD_PLATING.get()), (int)3).pattern("GG").define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).unlockedBy("has_gold", ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.STEEL_PLATING.get()), (int)3).pattern("SS").define(Character.valueOf('S'), ModItems.STEEL_INGOT).unlockedBy("has_steel_ingot", ModRecipeProvider.has(ModItems.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CHARGED_STEEL_PLATING.get()), (int)3).pattern("CC").define(Character.valueOf('C'), ModItems.CHARGED_STEEL_INGOT).unlockedBy("has_charged_steel_ingot", ModRecipeProvider.has(ModItems.CHARGED_STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.REINFORCED_IRON_PLATING.get())).pattern(" P ").pattern("PBP").pattern(" P ").define(Character.valueOf('P'), (ItemLike)ModItems.IRON_PLATING.get()).define(Character.valueOf('B'), (ItemLike)Blocks.IRON_BLOCK).unlockedBy("has_iron_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.IRON_PLATING.get()))).save(recipeOutput, "bytebuddies:plating/reinforced_iron");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.REINFORCED_STEEL_PLATING.get())).pattern(" P ").pattern("PBP").pattern(" P ").define(Character.valueOf('P'), (ItemLike)ModItems.STEEL_PLATING.get()).define(Character.valueOf('B'), (ItemLike)ModBlocks.STEEL_BLOCK.get()).unlockedBy("has_steel_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.STEEL_PLATING.get()))).save(recipeOutput, "bytebuddies:plating/reinforced_steel");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.REINFORCED_NETHERITE_PLATING.get())).pattern(" P ").pattern("PIP").pattern(" P ").define(Character.valueOf('P'), (ItemLike)Items.NETHERITE_SCRAP).define(Character.valueOf('I'), (ItemLike)Items.NETHERITE_INGOT).unlockedBy("has_netherite_scrap", ModRecipeProvider.has((ItemLike)Items.NETHERITE_SCRAP)).unlockedBy("has_netherite_ingot", ModRecipeProvider.has((ItemLike)Items.NETHERITE_INGOT)).save(recipeOutput, "bytebuddies:plating/reinforced_netherite");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.REINFORCED_CHARGED_STEEL_PLATING.get())).pattern(" P ").pattern("PBP").pattern(" P ").define(Character.valueOf('P'), (ItemLike)ModItems.CHARGED_STEEL_PLATING.get()).define(Character.valueOf('B'), (ItemLike)ModBlocks.CHARGED_STEEL_BLOCK.get()).unlockedBy("has_charged_steel", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHARGED_STEEL_INGOT.get()))).unlockedBy("has_charged_steel_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.CHARGED_STEEL_BLOCK.get()))).save(recipeOutput, "bytebuddies:plating/reinforced_charged_steel");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CARBON_ALLOY.get())).requires((ItemLike)Items.IRON_INGOT).requires((ItemLike)Items.IRON_INGOT).requires((ItemLike)ModItems.CARBON_PASTE.get()).unlockedBy("has_carbon_paste", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CARBON_PASTE.get()))).unlockedBy("has_iron_ingot", ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CARBON_ALLOY.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (float)3.5f, (int)1000).unlockedBy("has_carbon_alloy", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CARBON_ALLOY.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.BASIC_STORAGE_CELL.get())).pattern("PIP").pattern("SCS").pattern("PRP").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('P'), (ItemLike)ModItems.IRON_PLATING.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), ModItems.BLUESTONE_DUST).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).save(recipeOutput, "bytebuddies:storage/basic_cell");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.ADVANCED_STORAGE_CELL.get())).pattern("PBP").pattern("SCS").pattern("PGP").define(Character.valueOf('P'), (ItemLike)ModItems.GOLD_PLATING.get()).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('S'), (ItemLike)ModItems.BASIC_STORAGE_CELL.get()).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).unlockedBy("has_basic_cell", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.BASIC_STORAGE_CELL.get()))).save(recipeOutput, "bytebuddies:storage/advanced_cell");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.ENDERLINK_STORAGE_CELL.get())).pattern("OEO").pattern("SCS").pattern("ODO").define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('D'), (ItemLike)Blocks.ENDER_CHEST).define(Character.valueOf('O'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('S'), (ItemLike)ModItems.ADVANCED_STORAGE_CELL.get()).define(Character.valueOf('C'), (ItemLike)ModItems.SUPER_CHIP.get()).unlockedBy("has_adv_cell", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ADVANCED_STORAGE_CELL.get()))).save(recipeOutput, "bytebuddies:storage/enderlink_cell");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.PROPELLER_UNIT.get())).pattern(" F ").pattern("AIA").pattern(" F ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('A'), ModItems.ALUMINUM_INGOT).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).unlockedBy("has_aluminum_ingot", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ALUMINUM_INGOT.get()))).save(recipeOutput, "bytebuddies:augment/propeller_unit");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.AQUATIC_MOTOR.get())).pattern(" K ").pattern("AIA").pattern(" K ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('A'), ModItems.ALUMINUM_INGOT).define(Character.valueOf('K'), (ItemLike)Items.KELP).unlockedBy("has_aluminum_ingot", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ALUMINUM_INGOT.get()))).save(recipeOutput, "bytebuddies:augment/aquatic_motor");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.SOLAR_ARRAY.get())).pattern("GGG").pattern("QLQ").pattern("DCD").define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('L'), (ItemLike)Blocks.LAPIS_BLOCK).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('D'), (ItemLike)Items.GLOWSTONE_DUST).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).save(recipeOutput, "bytebuddies:augment/solar_array");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.GYROSCOPIC_STABILIZER.get())).pattern(" G ").pattern("BCB").pattern(" G ").define(Character.valueOf('B'), (ItemLike)ModItems.BLUESTONE_DUST.get()).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).save(recipeOutput, "bytebuddies:augment/gyroscopic_stabilizer");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.ARC_WELDER.get())).pattern("RI ").pattern("DCI").pattern(" B ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('D'), (ItemLike)ModItems.BLUESTONE_DUST.get()).define(Character.valueOf('B'), (ItemLike)ModItems.ADVANCED_BATTERY.get()).unlockedBy("has_battery", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ADVANCED_BATTERY.get()))).save(recipeOutput, "bytebuddies:augment/arc_welder");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.GEOTHERMAL_REGULATOR.get())).pattern("OSO").pattern("SBS").pattern("OLO").define(Character.valueOf('O'), (ItemLike)Blocks.OBSIDIAN).define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('B'), (ItemLike)ModItems.REINFORCED_BATTERY.get()).define(Character.valueOf('S'), (ItemLike)ModItems.STEEL_INGOT.get()).unlockedBy("has_reinforced_battery", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.REINFORCED_BATTERY.get()))).save(recipeOutput, "bytebuddies:augment/geothermal_regulator");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.DYNAMO_COIL.get())).pattern(" R ").pattern("CIC").pattern(" R ").define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_copper", ModRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).save(recipeOutput, "bytebuddies:augment/dynamo_coil");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.MAGNETIC_CRESCENT.get())).pattern(" I ").pattern("R I").pattern("CB ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_BLOCK).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).save(recipeOutput, "bytebuddies:augment/magnetic_crescent");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.BUSTER_SWORD.get())).pattern(" S ").pattern("IEI").pattern(" T ").define(Character.valueOf('S'), (ItemLike)ModItems.STEEL_INGOT.get()).define(Character.valueOf('E'), (ItemLike)ModBlocks.STEEL_BLOCK.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('T'), (ItemLike)Items.STICK).unlockedBy("has_steel", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()))).save(recipeOutput, "bytebuddies:weapon/buster_sword");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.TERRABLADE.get())).pattern(" C ").pattern("GEG").pattern(" T ").define(Character.valueOf('C'), (ItemLike)ModItems.CHARGED_STEEL_INGOT.get()).define(Character.valueOf('E'), (ItemLike)ModBlocks.CHARGED_STEEL_BLOCK.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('T'), (ItemLike)Items.STICK).unlockedBy("has_charged", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHARGED_STEEL_INGOT.get()))).save(recipeOutput, "bytebuddies:weapon/terrablade");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModBlocks.DOCKING_STATION.get())).pattern("ACA").pattern("ABA").pattern("ATA").define(Character.valueOf('A'), (ItemLike)ModItems.ALUMINUM_INGOT.get()).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('T'), (ItemLike)ModItems.ADVANCED_BATTERY.get()).unlockedBy("has_advanced_battery", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ADVANCED_BATTERY.get()))).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).unlockedBy("has_aluminum", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ALUMINUM_INGOT.get()))).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).save(recipeOutput, "bytebuddies:machines/docking_station");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModBlocks.GENERATOR.get())).pattern("AFA").pattern("TBT").pattern("ACA").define(Character.valueOf('A'), (ItemLike)ModItems.ALUMINUM_INGOT.get()).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('F'), (ItemLike)Blocks.FURNACE).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('T'), (ItemLike)ModItems.ADVANCED_BATTERY.get()).unlockedBy("has_advanced_battery", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ADVANCED_BATTERY.get()))).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).unlockedBy("has_aluminum", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ALUMINUM_INGOT.get()))).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).save(recipeOutput, "bytebuddies:machines/generator");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModBlocks.SOLAR_PANEL.get())).pattern("SSS").pattern("TBT").pattern("ACA").define(Character.valueOf('S'), (ItemLike)ModItems.SOLAR_ARRAY.get()).define(Character.valueOf('A'), (ItemLike)ModItems.ALUMINUM_INGOT.get()).define(Character.valueOf('B'), (ItemLike)ModBlocks.BLUESTONE_BLOCK.get()).define(Character.valueOf('C'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('T'), (ItemLike)ModItems.ADVANCED_BATTERY.get()).unlockedBy("has_advanced_battery", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ADVANCED_BATTERY.get()))).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).unlockedBy("has_aluminum", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.ALUMINUM_INGOT.get()))).unlockedBy("has_bluestone_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLUESTONE_BLOCK.get()))).save(recipeOutput, "bytebuddies:machines/solar_panel");
        Map<String, baseColor> floppyTypes = Map.of("black", ModRecipeProvider.floppyBase((ItemLike)Items.BLACK_DYE, (ItemLike)Blocks.OBSIDIAN.asItem(), (ItemLike)Items.IRON_NUGGET), "blue", ModRecipeProvider.floppyBase((ItemLike)Items.BLUE_DYE, (ItemLike)Items.LAPIS_LAZULI, (ItemLike)Items.COMPASS), "cyan", ModRecipeProvider.floppyBase((ItemLike)Items.CYAN_DYE, (ItemLike)Items.GLASS_PANE, (ItemLike)Items.ENDER_PEARL), "green", ModRecipeProvider.floppyBase((ItemLike)Items.GREEN_DYE, (ItemLike)Items.QUARTZ, (ItemLike)Items.GLOWSTONE_DUST), "pink", ModRecipeProvider.floppyBase((ItemLike)Items.PINK_DYE, (ItemLike)Items.HONEYCOMB, (ItemLike)Items.AMETHYST_SHARD), "purple", ModRecipeProvider.floppyBase((ItemLike)Items.PURPLE_DYE, (ItemLike)Items.RABBIT_FOOT, (ItemLike)Items.GOLD_NUGGET), "red", ModRecipeProvider.floppyBase((ItemLike)Items.RED_DYE, (ItemLike)Items.BLAZE_POWDER, (ItemLike)Blocks.REDSTONE_BLOCK.asItem()), "yellow", ModRecipeProvider.floppyBase((ItemLike)Items.YELLOW_DYE, (ItemLike)Items.BONE_MEAL, (ItemLike)Blocks.COMPOSTER.asItem()));
        for (String color : ModItems.COLORS) {
            baseColor baseColor2 = floppyTypes.get(color);
            String copperKey = ModRecipeProvider.floppyKey("copper", color);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.floppyItem(copperKey)).pattern("DPD").pattern("AHB").pattern("RCR").define(Character.valueOf('D'), baseColor2.dye()).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('A'), baseColor2.relatableItemA()).define(Character.valueOf('B'), baseColor2.relatableItemB()).define(Character.valueOf('H'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_dye_" + color, ModRecipeProvider.has((ItemLike)baseColor2.dye())).unlockedBy("has_first_core_" + color, ModRecipeProvider.has((ItemLike)baseColor2.relatableItemA())).unlockedBy("has_second_core_" + color, ModRecipeProvider.has((ItemLike)baseColor2.relatableItemB())).unlockedBy("has_redstone", ModRecipeProvider.has((ItemLike)Items.REDSTONE)).save(recipeOutput, ModRecipeProvider.floppyId(copperKey));
            String ironKey = ModRecipeProvider.floppyKey("iron", color);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.floppyItem(ironKey)).pattern("IQI").pattern("KHK").pattern("GDG").define(Character.valueOf('I'), (ItemLike)ModItems.IRON_PLATING.get()).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).define(Character.valueOf('K'), this.floppyItem(copperKey)).define(Character.valueOf('H'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('D'), baseColor2.dye()).unlockedBy("has_" + copperKey, ModRecipeProvider.has((ItemLike)this.floppyItem(copperKey))).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).unlockedBy("has_iron_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.IRON_PLATING.get()))).save(recipeOutput, ModRecipeProvider.floppyId(ironKey));
            String goldKey = ModRecipeProvider.floppyKey("gold", color);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.floppyItem(goldKey)).pattern("PEP").pattern("KHK").pattern("PDP").define(Character.valueOf('P'), (ItemLike)ModItems.GOLD_PLATING.get()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('K'), this.floppyItem(ironKey)).define(Character.valueOf('H'), (ItemLike)ModItems.CHIP.get()).define(Character.valueOf('D'), baseColor2.dye()).unlockedBy("has_" + ironKey, ModRecipeProvider.has((ItemLike)this.floppyItem(ironKey))).unlockedBy("has_chip", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHIP.get()))).unlockedBy("has_gold_plating", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.GOLD_PLATING.get()))).save(recipeOutput, ModRecipeProvider.floppyId(goldKey));
        }
    }

    private ItemLike floppyItem(String registryKey) {
        return (ItemLike)ModItems.FLOPPY_DISKS.get(registryKey).get();
    }

    private static String floppyKey(String tier, String color) {
        return tier + "_" + color + "_floppy";
    }

    private static ResourceLocation floppyId(String registryKey) {
        String[] parts = registryKey.split("_");
        return ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)("floppy/" + parts[0] + "/" + parts[1]));
    }

    private static baseColor floppyBase(ItemLike dye, ItemLike relatableItemA, ItemLike relatableItemB) {
        return new baseColor(dye, relatableItemA, relatableItemB);
    }

    private static void nineBlockCycle(RecipeOutput out, ItemLike nugget, ItemLike ingot, ItemLike block, String keyPrefix) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot).pattern("NNN").pattern("NNN").pattern("NNN").define(Character.valueOf('N'), nugget).unlockedBy("has_" + ModRecipeProvider.idOf(nugget), ModRecipeProvider.has((ItemLike)nugget)).save(out, keyPrefix + "/ingot_from_nuggets");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (int)9).requires(ingot).unlockedBy("has_" + ModRecipeProvider.idOf(ingot), ModRecipeProvider.has((ItemLike)ingot)).save(out, keyPrefix + "/nuggets_from_ingot");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block).pattern("AAA").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), ingot).unlockedBy("has_" + ModRecipeProvider.idOf(ingot), ModRecipeProvider.has((ItemLike)ingot)).save(out, keyPrefix + "/block_from_ingots");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot, (int)9).requires(block).unlockedBy("has_" + ModRecipeProvider.idOf(block), ModRecipeProvider.has((ItemLike)block)).save(out, keyPrefix + "/ingots_from_block");
    }

    private static void smeltAndBlast(RecipeOutput out, ItemLike input, ItemLike output, float xp, int smeltTime, int blastTime, String keyPrefix) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xp, (int)smeltTime).unlockedBy("has_" + ModRecipeProvider.idOf(input), ModRecipeProvider.has((ItemLike)input)).save(out, keyPrefix + "/smelting");
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xp, (int)blastTime).unlockedBy("has_" + ModRecipeProvider.idOf(input), ModRecipeProvider.has((ItemLike)input)).save(out, keyPrefix + "/blasting");
    }

    private static String idOf(ItemLike like) {
        return like.asItem().builtInRegistryHolder().key().location().getPath();
    }

    private static void simpleShaped(RecipeOutput out, ItemLike result, int count, String key, String[] pattern, Object ... keys) {
        ShapedRecipeBuilder shapedRecipeBuilder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count);
        for (String row : pattern) {
            shapedRecipeBuilder = shapedRecipeBuilder.pattern(row);
        }
        for (int i = 0; i < keys.length; i += 2) {
            shapedRecipeBuilder = shapedRecipeBuilder.define((Character)keys[i], (ItemLike)keys[i + 1]);
        }
        shapedRecipeBuilder.unlockedBy("has_any_" + key, ModRecipeProvider.has((ItemLike)result)).save(out, key);
    }

    private record baseColor(ItemLike dye, ItemLike relatableItemA, ItemLike relatableItemB) {
    }
}

