/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class BuddyFollowOwnerGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    private LivingEntity owner;
    private final double speed;
    private final double startDist;
    private final double stopDist;
    private final boolean teleportIfStuck;

    public BuddyFollowOwnerGoal(ByteBuddyEntity byteBuddy, double speed, double startDist, double stopDist, boolean teleportIfStuck) {
        this.byteBuddy = byteBuddy;
        this.speed = speed;
        this.startDist = startDist;
        this.stopDist = stopDist;
        this.teleportIfStuck = teleportIfStuck;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        ServerPlayer owner = this.byteBuddy.getOwner(this.levelAsServer(this.byteBuddy));
        if (owner == null) {
            return false;
        }
        if (this.byteBuddy.getDock().isPresent()) {
            return false;
        }
        if (this.byteBuddy.distanceToSqr((Entity)owner) < this.startDist * this.startDist) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.owner == null || !this.owner.isAlive()) {
            return false;
        }
        return this.byteBuddy.distanceToSqr((Entity)this.owner) > this.stopDist * this.stopDist;
    }

    public void tick() {
        if (this.owner == null || !this.owner.isAlive() || this.owner.level() != this.byteBuddy.level()) {
            return;
        }
        if (this.byteBuddy.level() instanceof ServerLevel) {
            this.byteBuddy.getLookControl().setLookAt((Entity)this.owner, 15.0f, 15.0f);
            if (!this.byteBuddy.getNavigation().isInProgress()) {
                this.byteBuddy.getNavigation().moveTo((Entity)this.owner, this.speed);
            }
            double maxDist = 32.0;
            if (this.teleportIfStuck && this.byteBuddy.distanceToSqr((Entity)this.owner) > 1024.0 && this.tryTeleportNearOwner(this.owner, 2, 6)) {
                this.byteBuddy.getNavigation().stop();
            }
        }
    }

    private boolean tryTeleportNearOwner(LivingEntity owner, int minRadius, int maxRadius) {
        int tries = 12;
        double ownerX = owner.getX();
        double ownerY = owner.getY();
        double ownerZ = owner.getZ();
        for (int i = 0; i < 12; ++i) {
            double angle = Math.PI * 2 * (double)i / 12.0;
            int radius = minRadius + this.byteBuddy.getRandom().nextInt(Math.max(1, maxRadius - minRadius + 1));
            int dx = (int)Math.round(Math.cos(angle) * (double)radius);
            int dz = (int)Math.round(Math.sin(angle) * (double)radius);
            BlockPos basePos = BlockPos.containing((double)ownerX, (double)ownerY, (double)ownerZ).offset(dx, 0, dz);
            BlockPos safePos = this.findStandableColumnNear(basePos, 2);
            if (safePos == null || !ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.level(), safePos)) continue;
            this.byteBuddy.teleportTo((double)safePos.getX() + 0.5, safePos.getY(), (double)safePos.getZ() + 0.5);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findStandableColumnNear(BlockPos blockPos, int yScan) {
        for (int dy = -yScan; dy <= yScan; ++dy) {
            BlockPos standPos = blockPos.offset(0, dy, 0);
            if (!ByteBuddyEntity.isStandableTerrain(this.byteBuddy.level(), standPos)) continue;
            return standPos;
        }
        return null;
    }

    @Nullable
    private ServerLevel levelAsServer(ByteBuddyEntity byteBuddy) {
        ServerLevel serverLevel;
        Level level = byteBuddy.level();
        return level instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
    }
}

