/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class DepositToDockGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    @Nullable
    private BlockPos targetPos;
    @Nullable
    private BlockPos approachPos;
    private List<Approach> approachPlans = Collections.emptyList();
    private int anchorIndex = 0;
    @Nullable
    private Vec3 targetAnchor = null;
    private boolean edgeAnchored = false;
    private long nextActionTick = 0L;
    private static final int baseActionCooldown = 20;
    private BotDebug.GoalPhase currentPhase = BotDebug.GoalPhase.IDLE;
    private BotDebug.FailReason lastFail = BotDebug.FailReason.NONE;
    private long phaseStartedTick = 0L;
    private long phaseProgressTick = 0L;
    private int repathRetries = 0;
    private int anchorRotateRetries = 0;
    private static final int movingTimeout = 160;
    private static final int actingTimeout = 60;
    private double lastMoveDistSq = Double.POSITIVE_INFINITY;
    private double lastAnchorDistSq = Double.POSITIVE_INFINITY;
    private static final double reachDistanceMin = 0.95;
    private static final double verticalTolerance = 1.66;
    private static final double finalApproachDist = 1.66;
    private static final double microDistMin = 0.15;
    private static final double microDistMax = 0.28;
    @Nullable
    private BlockPos firePos = null;
    @Nullable
    private BlockState firePreState = null;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private boolean actionStarted = false;

    public DepositToDockGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        byteBuddy.setPathfindingMalus(PathType.WATER, 8.0f);
        byteBuddy.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
    }

    public boolean canUse() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() <= this.animationEnd;
            }
            return true;
        }
        if (this.byteBuddy.getDock().isEmpty()) {
            return false;
        }
        if (!this.isInventoryFull((IItemHandler)this.byteBuddy.getMainInv())) {
            return false;
        }
        if (!GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 1, 64)) {
            return false;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return false;
        }
        BlockPos dockPos = dockBlock.getBlockPos();
        Optional<DockPlan> plan = this.findDockPlan(dockPos);
        if (plan.isEmpty()) {
            return false;
        }
        this.targetPos = plan.get().targetPos();
        this.approachPos = plan.get().approachPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
        this.edgeAnchored = false;
        this.resetProgress();
        this.enterPhase(BotDebug.GoalPhase.MOVING, "approach dock " + this.approachPos.toShortString());
        return true;
    }

    public boolean canContinueToUse() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        return GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 1, 64);
    }

    public void stop() {
        this.clearTimedAnimation();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        super.stop();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        boolean withinReach;
        PathNavigation pathNavigation;
        Level level = this.byteBuddy.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.tickTimedAnimation();
        if (this.targetPos == null || this.approachPos == null) {
            return;
        }
        Vec3 targetCenter = this.targetPos.getCenter();
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            this.byteBuddy.getLookControl().setLookAt(targetCenter.x, targetCenter.y, targetCenter.z, 15.0f, 15.0f);
            return;
        }
        this.navigatePhases(serverLevel);
        if (this.targetAnchor != null) {
            double distToTarget = this.byteBuddy.position().distanceTo(this.targetAnchor);
            if (distToTarget > 1.66) {
                PathNavigation pathNavigation2 = this.byteBuddy.getNavigation();
                if (pathNavigation2 instanceof GroundPathNavigation) {
                    boolean needsNewPath;
                    GroundPathNavigation pathNavigation3 = (GroundPathNavigation)pathNavigation2;
                    Path currentPath = pathNavigation3.getPath();
                    boolean bl = needsNewPath = currentPath == null || currentPath.isDone() || this.approachPos == null || !currentPath.getTarget().equals((Object)this.approachPos);
                    if (needsNewPath) {
                        Path path;
                        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                        Path path2 = path = this.approachPos != null ? pathNavigation3.createPath(this.approachPos, 0) : null;
                        if (path != null) {
                            pathNavigation3.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
                            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                        } else {
                            this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                        }
                    }
                } else {
                    this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                }
                return;
            }
            if (!this.edgeAnchored) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                if (distToTarget <= 0.15) {
                    GoalUtil.lockToAnchor(this.byteBuddy, this.targetAnchor);
                    this.edgeAnchored = true;
                    this.markProgress();
                    BotDebug.log(this.byteBuddy, "DEPOSIT: locked anchor");
                } else {
                    this.byteBuddy.getNavigation().stop();
                    this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                    if (distToTarget + 0.001 < this.lastAnchorDistSq) {
                        this.lastAnchorDistSq = distToTarget;
                        this.markProgress();
                    }
                    BotDebug.log(this.byteBuddy, String.format("final-targetPos dH=%.3f to edge %s", distToTarget, this.approachPos.toShortString()));
                }
            } else {
                double distanceToTarget = this.byteBuddy.position().distanceTo(this.targetAnchor);
                if (distanceToTarget > 0.28) {
                    this.edgeAnchored = false;
                }
            }
        } else if (this.approachPos != null && (pathNavigation = this.byteBuddy.getNavigation()) instanceof GroundPathNavigation) {
            GroundPathNavigation pathNavigation4 = (GroundPathNavigation)pathNavigation;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            Path path = pathNavigation4.createPath(this.approachPos, 0);
            pathNavigation4.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            return;
        }
        Vec3 buddyPos = this.byteBuddy.position();
        boolean bl = withinReach = GoalUtil.hDistSq(buddyPos, targetCenter) <= 0.9025 && Math.abs(buddyPos.y - targetCenter.y) <= 1.66;
        if (withinReach) {
            if (this.animationEnd > 0L || this.currentPhase == BotDebug.GoalPhase.ACTING) {
                this.byteBuddy.getLookControl().setLookAt(targetCenter.x, targetCenter.y, targetCenter.z, 15.0f, 15.0f);
            } else {
                if (!GoalUtil.actionReady(serverLevel, this.nextActionTick)) {
                    return;
                }
                this.firePos = this.targetPos;
                this.firePreState = this.byteBuddy.level().getBlockState(this.targetPos);
                this.startTimedAnimation(GoalUtil.toTicks(2.6), GoalUtil.toTicks(1.8), this.targetPos, this.firePreState);
                BlockEntity blockEntity = serverLevel.getBlockEntity(this.firePos);
                if (blockEntity instanceof DockingStationBlockEntity) {
                    DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
                    serverLevel.setBlock(this.firePos, (BlockState)dockBlock.getBlockState().setValue((Property)DockingStationBlock.OPEN, (Comparable)Boolean.TRUE), 3);
                }
                BotDebug.log(this.byteBuddy, "DEPOSIT schedule now=" + serverLevel.getGameTime());
            }
        }
        if (this.targetAnchor != null && !this.edgeAnchored) {
            this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
        }
    }

    private void navigatePhases(ServerLevel serverLevel) {
        switch (this.currentPhase) {
            case MOVING: {
                this.handleMoving(serverLevel);
                break;
            }
            case ACTING: {
                this.handleActing();
                break;
            }
        }
    }

    private void handleMoving(ServerLevel serverLevel) {
        if (this.isWithinFinalApproach()) {
            this.renewPathAheadIfNeeded(serverLevel, 5);
            this.markProgress();
            return;
        }
        this.updateApproachProgress();
        this.renewPathAheadIfNeeded(serverLevel, 5);
        if (this.stalledFor(16)) {
            if (this.tryRecoverFromStall(serverLevel)) {
                this.markProgress();
            } else {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING stalled");
            }
            return;
        }
        if (this.timedOut(160)) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING timeout");
        }
    }

    private boolean isWithinFinalApproach() {
        if (this.edgeAnchored) {
            return true;
        }
        if (this.targetAnchor == null) {
            return false;
        }
        return Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.position(), this.targetAnchor)) <= 1.66;
    }

    private void updateApproachProgress() {
        if (this.approachPos != null) {
            Vec3 progressToTarget = this.targetAnchor != null ? this.targetAnchor : this.approachPos.getCenter();
            double distSq = GoalUtil.hDistSq(this.byteBuddy.position(), progressToTarget);
            if (distSq + 0.001 < this.lastMoveDistSq) {
                this.lastMoveDistSq = distSq;
                this.markProgress();
            }
        }
    }

    private void renewPathAheadIfNeeded(ServerLevel serverLevel, int lookahead) {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (!(pathNavigation instanceof GroundPathNavigation)) {
            return;
        }
        GroundPathNavigation navigation = (GroundPathNavigation)pathNavigation;
        Path path = navigation.getPath();
        if (path == null) {
            return;
        }
        if (serverLevel.getGameTime() % 5L != 0L) {
            return;
        }
        this.byteBuddy.renewPathAhead(serverLevel, path, lookahead);
    }

    private boolean tryRecoverFromStall(ServerLevel serverLevel) {
        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        if (this.repath()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: repath");
            return true;
        }
        if (this.rotateAnchor()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: rotate targetPos side");
            return true;
        }
        return false;
    }

    private void handleActing() {
        if (this.animationEnd > 0L) {
            this.markProgress();
            return;
        }
        if (this.timedOut(60)) {
            BotDebug.log(this.byteBuddy, "ACTING timeout; abort");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "abort deposit");
        }
    }

    private boolean repath() {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            Path path;
            GroundPathNavigation navigation = (GroundPathNavigation)pathNavigation;
            if (this.repathRetries++ >= 2) {
                return false;
            }
            if (this.approachPos == null) {
                return false;
            }
            if (this.byteBuddy.level() instanceof ServerLevel) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            if ((path = navigation.createPath(this.approachPos, 0)) == null) {
                return false;
            }
            navigation.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            return true;
        }
        return false;
    }

    private boolean rotateAnchor() {
        if (this.approachPlans.isEmpty() || this.targetPos == null) {
            return false;
        }
        if (this.anchorRotateRetries >= 3) {
            return false;
        }
        int n = this.approachPlans.size();
        for (int tries = 0; tries < n; ++tries) {
            Path path;
            Vec3 anchor;
            this.anchorIndex = (this.anchorIndex + 1) % n;
            Approach candidate = this.approachPlans.get(this.anchorIndex);
            BlockPos stand = candidate.targetPos();
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.level(), stand) || (anchor = candidate.approachAnchor()) == null) continue;
            PathNavigation pathNavigation = this.byteBuddy.getNavigation();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation navigation = (GroundPathNavigation)pathNavigation;
                v0 = navigation.createPath(stand, 0);
            } else {
                v0 = path = null;
            }
            if (path == null) continue;
            this.approachPos = stand;
            this.targetAnchor = anchor;
            this.edgeAnchored = false;
            if (this.byteBuddy.level() instanceof ServerLevel) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            this.byteBuddy.getNavigation().moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            pathNavigation = this.byteBuddy.level();
            if (pathNavigation instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            ++this.anchorRotateRetries;
            this.markProgress();
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
            return true;
        }
        return false;
    }

    private void startTimedAnimation(int totalTicks, int startTick, @Nullable BlockPos fireAt, @Nullable BlockState preState) {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.byteBuddy.getNavigation().stop();
            Vec3 deltaMovement = this.byteBuddy.getDeltaMovement();
            this.byteBuddy.setDeltaMovement(deltaMovement.x * 0.1, deltaMovement.y * 0.1, deltaMovement.z * 0.1);
            this.byteBuddy.setWorking(true);
            this.actionStarted = false;
            long currentTime = serverLevel.getGameTime();
            this.animationStart = currentTime + (long)Math.max(0, startTick);
            this.animationEnd = currentTime + (long)Math.max(1, totalTicks);
            this.firePos = fireAt;
            this.firePreState = preState;
            float speedMultiplier = Math.max(0.25f, this.byteBuddy.actionSpeedMultiplier());
            this.nextActionTick = currentTime + (long)Math.max(4, Math.round(20.0f / speedMultiplier));
            this.enterPhase(BotDebug.GoalPhase.ACTING, "animation: DEPOSIT");
        }
    }

    private void tickTimedAnimation() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.getGameTime();
            if (!this.actionStarted && currentTime >= this.animationStart && this.firePos != null && this.firePreState != null) {
                this.actionStarted = true;
                BotDebug.log(this.byteBuddy, "DEPOSIT anim: now=" + currentTime + " start=" + this.animationStart + " end=" + this.animationEnd + " fired=" + this.actionStarted + " firePos=" + (this.firePos != null));
                this.actionStarted = true;
                this.performDeposit(serverLevel, this.firePos);
                BlockEntity blockEntity = serverLevel.getBlockEntity(this.firePos);
                if (blockEntity instanceof DockingStationBlockEntity) {
                    DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
                    serverLevel.setBlock(this.firePos, (BlockState)dockBlock.getBlockState().setValue((Property)DockingStationBlock.OPEN, (Comparable)Boolean.FALSE), 3);
                }
            }
            if (this.currentPhase == BotDebug.GoalPhase.ACTING && this.animationEnd > 0L && currentTime >= this.animationEnd) {
                this.clearTimedAnimation();
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "DEPOSIT complete");
            }
        }
    }

    private void clearTimedAnimation() {
        this.actionStarted = false;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.byteBuddy.setWorking(false);
    }

    private Optional<DockPlan> findDockPlan(BlockPos dockPos) {
        Path path;
        BlockState blockState;
        Direction facing;
        BlockPos approachPos;
        Level level = this.byteBuddy.level();
        if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, approachPos = dockPos.relative(facing = (Direction)(blockState = level.getBlockState(dockPos)).getValue((Property)DockingStationBlock.FACING)))) {
            return Optional.empty();
        }
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
            v0 = pathNavigation2.createPath(approachPos, 0);
        } else {
            v0 = path = null;
        }
        if (path == null) {
            return Optional.empty();
        }
        Vec3 edgeAnchor = GoalUtil.getEdgeAnchor(dockPos, approachPos);
        if (edgeAnchor == null) {
            return Optional.empty();
        }
        this.approachPlans = List.of(new Approach(approachPos, edgeAnchor, GoalUtil.hDistSq(this.byteBuddy.position(), edgeAnchor), path));
        this.anchorIndex = 0;
        return Optional.of(new DockPlan(dockPos, approachPos, path));
    }

    private void performDeposit(ServerLevel serverLevel, BlockPos dockPos) {
        IItemHandler dockInventory = (IItemHandler)serverLevel.getCapability(Capabilities.ItemHandler.BLOCK, dockPos, null);
        if (dockInventory == null) {
            return;
        }
        int totalMoved = 0;
        for (int slot = 9; slot < this.byteBuddy.getMainInv().getSlots(); ++slot) {
            ItemStack itemRemainder;
            int insertedAmount;
            ItemStack stackInSlot = this.byteBuddy.getMainInv().getStackInSlot(slot);
            if (stackInSlot.isEmpty()) continue;
            ItemStack simulatedRemainder = this.tryInsertAll(dockInventory, stackInSlot, true);
            int insertableAmount = stackInSlot.getCount() - simulatedRemainder.getCount();
            if (insertableAmount <= 0 || (insertedAmount = insertableAmount - (itemRemainder = this.tryInsertAll(dockInventory, stackInSlot.copyWithCount(insertableAmount), false)).getCount()) <= 0) continue;
            this.byteBuddy.getMainInv().extractItem(slot, insertedAmount, false);
            totalMoved += insertedAmount;
        }
        if (totalMoved > 0) {
            this.byteBuddy.consumeEnergy(totalMoved);
            BotDebug.log(this.byteBuddy, "DEPOSIT: moved " + totalMoved + " items to dock");
        }
    }

    private ItemStack tryInsertAll(IItemHandler destinationInventory, ItemStack itemStack, boolean simulate) {
        ItemStack itemRemainder = itemStack.copy();
        for (int slot = 0; slot < destinationInventory.getSlots() && !(itemRemainder = destinationInventory.insertItem(slot, itemRemainder, simulate)).isEmpty(); ++slot) {
        }
        return itemRemainder;
    }

    private boolean isInventoryFull(IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void enterPhase(BotDebug.GoalPhase phase, String context) {
        this.currentPhase = phase;
        this.lastFail = BotDebug.FailReason.NONE;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
        if (phase == BotDebug.GoalPhase.MOVING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        }
        if (phase == BotDebug.GoalPhase.ACTING && this.byteBuddy.level() instanceof ServerLevel) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        BotDebug.log(this.byteBuddy, "DEPOSITOR: " + String.valueOf((Object)phase) + (String)(context.isEmpty() ? "" : " -> " + context));
    }

    private void clearTarget() {
        if (this.byteBuddy.level() instanceof ServerLevel) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.firePos = null;
        this.firePreState = null;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
    }

    private void failTask(BotDebug.FailReason reason, String context) {
        this.lastFail = reason;
        this.currentPhase = BotDebug.GoalPhase.IDLE;
        BotDebug.log(this.byteBuddy, "DEPOSITOR cannot start: " + String.valueOf((Object)reason) + (String)(context.isEmpty() ? "" : " (" + context + ")"));
        this.resetProgress();
        this.stop();
    }

    private void resetProgress() {
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        this.repathRetries = 0;
        this.anchorRotateRetries = 0;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private void markProgress() {
        this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private boolean stalledFor(int stallTime) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseProgressTick > (long)stallTime;
    }

    private boolean timedOut(int timeLimit) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseStartedTick > (long)timeLimit;
    }

    private record DockPlan(BlockPos targetPos, BlockPos approachPos, Path path) {
    }

    private record Approach(BlockPos targetPos, Vec3 approachAnchor, double distSq, Path path) {
    }
}

