/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class RandomWaveAtFriendGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    private final double radius;
    private final int cooldownTicks;
    private final int waveDurationTicks;
    private int cooldown;
    private int remaining;
    private LivingEntity target;

    public RandomWaveAtFriendGoal(ByteBuddyEntity byteBuddy, double radius, int cooldownTicks, int waveDurationTicks) {
        this.byteBuddy = byteBuddy;
        this.radius = radius;
        this.cooldownTicks = cooldownTicks;
        this.waveDurationTicks = waveDurationTicks;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean hasEyesOn(LivingEntity livingEntity) {
        Vec3 origin = this.byteBuddy.getEyePosition();
        Vec3 eyeDestination = livingEntity.getEyePosition();
        BlockHitResult hitResult = this.byteBuddy.level().clip(new ClipContext(origin, eyeDestination, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)this.byteBuddy));
        return hitResult.getType() == HitResult.Type.MISS;
    }

    private boolean inFov(LivingEntity livingEntity) {
        Vec3 dir;
        Vec3 look = this.byteBuddy.getViewVector(1.0f).normalize();
        return look.dot(dir = livingEntity.getEyePosition().subtract(this.byteBuddy.getEyePosition()).normalize()) > 0.2;
    }

    public boolean canUse() {
        if (this.byteBuddy.isSleeping() || this.byteBuddy.isWaving() || this.byteBuddy.isWaking()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        List candidates = this.byteBuddy.level().getEntitiesOfClass(LivingEntity.class, this.byteBuddy.getBoundingBox().inflate(this.radius), livingEntity -> livingEntity.isAlive() && livingEntity != this.byteBuddy && !(livingEntity instanceof Monster) && this.hasEyesOn((LivingEntity)livingEntity) && this.inFov((LivingEntity)livingEntity));
        if (candidates.isEmpty()) {
            return false;
        }
        if (this.byteBuddy.getRandom().nextInt(3) != 0) {
            return false;
        }
        this.target = (LivingEntity)candidates.get(this.byteBuddy.getRandom().nextInt(candidates.size()));
        this.remaining = this.waveDurationTicks;
        return this.target != null;
    }

    public void start() {
        this.byteBuddy.setWaving(true);
        this.byteBuddy.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
    }

    public boolean canContinueToUse() {
        return this.remaining > 0 && this.byteBuddy.isAlive() && !this.byteBuddy.isSleeping() && this.target != null && this.target.isAlive();
    }

    public void tick() {
        if (this.target != null) {
            this.byteBuddy.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        }
        if (--this.remaining <= 0) {
            // empty if block
        }
    }

    public boolean isInterruptable() {
        return false;
    }

    public void stop() {
        this.byteBuddy.setWaving(false);
        this.cooldown = this.cooldownTicks;
        this.target = null;
        this.remaining = 0;
    }
}

