/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.combat;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class BuddyOwnerHurtByTargetGoal
extends TargetGoal {
    private final ByteBuddyEntity byteBuddy;
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public BuddyOwnerHurtByTargetGoal(ByteBuddyEntity byteBuddy) {
        super((Mob)byteBuddy, false);
        this.byteBuddy = byteBuddy;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        ServerPlayer owner = this.byteBuddy.getOwner(this.levelAsServer());
        if (owner != null && this.byteBuddy.getDock().isEmpty()) {
            this.ownerLastHurtBy = owner.getLastHurtMob();
            int i = owner.getLastHurtMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        ServerPlayer livingentity = this.byteBuddy.getOwner(this.levelAsServer());
        if (livingentity != null) {
            this.timestamp = livingentity.getLastHurtMobTimestamp();
        }
        super.start();
    }

    public boolean isInterruptable() {
        return false;
    }

    @Nullable
    private ServerLevel levelAsServer() {
        ServerLevel serverLevel;
        Level level = this.byteBuddy.level();
        return level instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
    }
}

