/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.farmer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.InventoryUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class PlantGoal
extends Goal {
    private final ByteBuddyEntity byteBuddy;
    @Nullable
    private BlockPos targetPos;
    @Nullable
    private BlockPos approachPos;
    private List<Approach> approachPlans = Collections.emptyList();
    private int anchorIndex = 0;
    @Nullable
    private Vec3 targetAnchor = null;
    private boolean edgeAnchored = false;
    private long nextActionTick = 0L;
    private static final int baseActionCooldown = 20;
    private BotDebug.GoalPhase currentPhase = BotDebug.GoalPhase.IDLE;
    private BotDebug.FailReason lastFail = BotDebug.FailReason.NONE;
    private long phaseStartedTick = 0L;
    private long phaseProgressTick = 0L;
    private int repathRetries = 0;
    private int anchorRotateRetries = 0;
    private int targetReselectRetries = 0;
    private static final int seekingTimout = 20;
    private static final int movingTimeout = 160;
    private static final int actingTimeout = 60;
    private double lastMoveDistSq = Double.POSITIVE_INFINITY;
    private double lastAnchorDistSq = Double.POSITIVE_INFINITY;
    private static final double reachDistanceMin = 0.95;
    private static final double verticalTolerance = 1.25;
    private static final double finalApproachDist = 1.25;
    private static final double microDistMin = 0.08;
    private static final double microDistMax = 0.18;
    @Nullable
    private BlockPos claimedPlantPos = null;
    @Nullable
    private BlockState claimedPlantState = null;
    @Nullable
    private Item claimedPlantSeed = null;
    @Nullable
    private BlockPos firePos = null;
    @Nullable
    private BlockState firePreState = null;
    private static final int claimTimeOut = 120;
    private long nextClaimRenewPlant = 0L;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private boolean actionStarted = false;
    private static final int plantEnergyCost = 25;

    public PlantGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        byteBuddy.setPathfindingMalus(PathType.WATER, 8.0f);
        byteBuddy.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
    }

    public boolean canUse() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() < this.animationEnd;
            }
            return true;
        }
        if (this.targetPos != null) {
            return true;
        }
        if (this.byteBuddy.getBuddyRole() != ByteBuddyEntity.BuddyRole.FARMER) {
            this.failTask(BotDebug.FailReason.WRONG_ROLE, "role=" + String.valueOf((Object)this.byteBuddy.getBuddyRole()));
            return false;
        }
        if (this.byteBuddy.getDock().isEmpty()) {
            this.failTask(BotDebug.FailReason.NO_DOCK, "no station bound");
            return false;
        }
        if (!GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 25, 1)) {
            return false;
        }
        ByteBuddyEntity.PlantRequest plantRequest = this.byteBuddy.pollPlantRequest();
        PlantPlan plantPlan = null;
        if (plantRequest != null && (plantPlan = this.findPlantPlan(plantRequest.blockPos, plantRequest.seedItem, plantRequest.blockState, 0)) == null) {
            this.byteBuddy.requestImmediatePlant(plantRequest.blockPos, plantRequest.blockState, plantRequest.seedItem);
            return false;
        }
        if (plantPlan == null) {
            plantPlan = this.findPlantPlan(null, null, null, this.byteBuddy.effectiveRadius());
        }
        if (plantPlan != null) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
                if (!(dockBlock == null || this.claimedPlantPos != null && this.claimedPlantPos.equals((Object)plantPlan.plantPos()))) {
                    if (!dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.PLANT, plantPlan.plantPos(), this.byteBuddy.getUUID(), 120)) {
                        return false;
                    }
                    this.claimedPlantPos = plantPlan.plantPos();
                    this.nextClaimRenewPlant = serverLevel.getGameTime() + 5L;
                }
            }
            this.claimedPlantSeed = plantPlan.seedItem();
            this.claimedPlantState = plantPlan.plantState();
            this.targetPos = plantPlan.plantPos();
            this.approachPos = plantPlan.standPos();
            this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
            this.edgeAnchored = false;
            this.resetProgress();
            this.enterPhase(BotDebug.GoalPhase.MOVING, "to plant site " + this.targetPos.toShortString());
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        return GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 25, 1);
    }

    public void stop() {
        this.clearTimedAnimation();
        this.releasePlantClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        super.stop();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            boolean withinReachPlant;
            PathNavigation pathNavigation;
            BlockState desiredPlant;
            ServerLevel serverLevel = (ServerLevel)level;
            this.tickTimedAnimation();
            if (this.targetPos == null || this.approachPos == null) {
                return;
            }
            Vec3 cropCenter = this.targetPos.getCenter();
            if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
                this.byteBuddy.getLookControl().setLookAt(cropCenter.x, this.targetPos.getBottomCenter().y, cropCenter.z, 15.0f, 15.0f);
                return;
            }
            GoalUtil.renewClaimIfNeeded(this.byteBuddy, serverLevel, ByteBuddyEntity.TaskType.PLANT, this.claimedPlantPos, this.targetPos, serverLevel.getGameTime(), 5, 120, () -> this.nextClaimRenewPlant, ticks -> {
                this.nextClaimRenewPlant = ticks;
            });
            BlockState plantBlockState = this.byteBuddy.level().getBlockState(this.targetPos);
            Object object = this.claimedPlantState != null ? this.claimedPlantState : (desiredPlant = this.claimedPlantSeed != null ? PlantGoal.seedToPlantState(this.claimedPlantSeed) : null);
            if (!(this.currentPhase == BotDebug.GoalPhase.ACTING || desiredPlant != null && GoalUtil.canPlantAt(this.byteBuddy.level(), this.targetPos, desiredPlant))) {
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "plant site invalid, rescan");
                return;
            }
            this.navigatePhases(serverLevel);
            if (this.targetAnchor != null) {
                double distToTarget = this.byteBuddy.position().distanceTo(this.targetAnchor);
                if (distToTarget > 1.25) {
                    PathNavigation pathNavigation2 = this.byteBuddy.getNavigation();
                    if (pathNavigation2 instanceof GroundPathNavigation) {
                        boolean needsNewPath;
                        GroundPathNavigation pathNavigation3 = (GroundPathNavigation)pathNavigation2;
                        Path currentPath = pathNavigation3.getPath();
                        boolean bl = needsNewPath = currentPath == null || currentPath.isDone() || this.approachPos == null || !currentPath.getTarget().equals((Object)this.approachPos);
                        if (needsNewPath) {
                            Path path;
                            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                            Path path2 = path = this.approachPos != null ? pathNavigation3.createPath(this.approachPos, 0) : null;
                            if (path != null) {
                                pathNavigation3.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
                                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                            } else {
                                this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                            }
                        }
                    } else {
                        this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                    }
                    return;
                }
                if (!this.edgeAnchored) {
                    GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                    if (distToTarget <= 0.08) {
                        GoalUtil.lockToAnchor(this.byteBuddy, this.targetAnchor);
                        this.edgeAnchored = true;
                        this.markProgress();
                        BotDebug.log(this.byteBuddy, "PLANT: locked anchor");
                    } else {
                        this.byteBuddy.getNavigation().stop();
                        this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                        if (distToTarget + 0.001 < this.lastAnchorDistSq) {
                            this.lastAnchorDistSq = distToTarget;
                            this.markProgress();
                        }
                        BotDebug.log(this.byteBuddy, String.format("final-targetPos dH=%.3f to edge %s", distToTarget, this.approachPos.toShortString()));
                    }
                } else {
                    double distSq = Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.position(), this.targetAnchor));
                    if (distSq > 0.18) {
                        this.edgeAnchored = false;
                    }
                }
            } else if (this.approachPos != null && (pathNavigation = this.byteBuddy.getNavigation()) instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation4 = (GroundPathNavigation)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                Path path = pathNavigation4.createPath(this.approachPos, 0);
                pathNavigation4.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                return;
            }
            Vec3 buddyPos = this.byteBuddy.position();
            boolean bl = withinReachPlant = GoalUtil.hDistSq(buddyPos, cropCenter) <= 0.9025 && Math.abs(buddyPos.y - cropCenter.y) <= 1.25;
            if (!(this.currentPhase == BotDebug.GoalPhase.ACTING || desiredPlant != null && GoalUtil.canPlantAt(this.byteBuddy.level(), this.targetPos, desiredPlant))) {
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "plant site invalid, rescan");
                return;
            }
            if (withinReachPlant) {
                if (this.animationEnd > 0L || this.currentPhase == BotDebug.GoalPhase.ACTING) {
                    this.byteBuddy.getLookControl().setLookAt(cropCenter.x, this.targetPos.getBottomCenter().y, cropCenter.z, 15.0f, 15.0f);
                } else {
                    if (!GoalUtil.actionReady(serverLevel, this.nextActionTick)) {
                        return;
                    }
                    if (!this.verifyClaimOrAbort(serverLevel, ByteBuddyEntity.TaskType.PLANT, this.claimedPlantPos, this.targetPos)) {
                        return;
                    }
                    this.firePos = this.targetPos;
                    this.firePreState = plantBlockState;
                    int totalTicks = GoalUtil.toTicks(2.0);
                    int startTicks = GoalUtil.toTicks(0.4);
                    this.startTimedAnimation(totalTicks, startTicks, this.targetPos, plantBlockState);
                    BotDebug.log(this.byteBuddy, "PLANT schedule: now=" + serverLevel.getGameTime() + " start=" + (serverLevel.getGameTime() + (long)startTicks) + " end=" + (serverLevel.getGameTime() + (long)totalTicks) + " firePos=" + String.valueOf(this.firePos) + " preState=" + this.firePreState.getBlock().getName().getString());
                    return;
                }
            }
            if (this.targetAnchor != null && !this.edgeAnchored) {
                this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
            }
        }
    }

    private void navigatePhases(ServerLevel serverLevel) {
        switch (this.currentPhase) {
            case MOVING: {
                this.handleMoving(serverLevel);
                break;
            }
            case ACTING: {
                this.handleActing();
                break;
            }
            case SEEKING: {
                this.handleSeeking(serverLevel);
                break;
            }
        }
    }

    private void handleMoving(ServerLevel serverLevel) {
        if (this.isWithinFinalApproach()) {
            this.renewPathAheadIfNeeded(serverLevel, 5);
            this.markProgress();
            return;
        }
        this.updateApproachProgress();
        this.renewPathAheadIfNeeded(serverLevel, 5);
        if (this.stalledFor(16)) {
            if (this.tryRecoverFromStall(serverLevel)) {
                this.markProgress();
            } else {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING stalled, rescan");
            }
            return;
        }
        if (this.timedOut(160)) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING timeout, rescan");
        }
    }

    private boolean isWithinFinalApproach() {
        if (this.edgeAnchored) {
            return true;
        }
        if (this.targetAnchor == null) {
            return false;
        }
        return Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.position(), this.targetAnchor)) <= 1.25;
    }

    private void updateApproachProgress() {
        if (this.approachPos != null) {
            Vec3 progressToTarget = this.targetAnchor != null ? this.targetAnchor : this.approachPos.getCenter();
            double distSq = GoalUtil.hDistSq(this.byteBuddy.position(), progressToTarget);
            if (distSq + 0.001 < this.lastMoveDistSq) {
                this.lastMoveDistSq = distSq;
                this.markProgress();
            }
        }
    }

    private void renewPathAheadIfNeeded(ServerLevel serverLevel, int lookahead) {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (!(pathNavigation instanceof GroundPathNavigation)) {
            return;
        }
        GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
        Path path = pathNavigation2.getPath();
        if (path == null) {
            return;
        }
        if (serverLevel.getGameTime() % 5L != 0L) {
            return;
        }
        this.byteBuddy.renewPathAhead(serverLevel, path, lookahead);
    }

    private boolean tryRecoverFromStall(ServerLevel serverLevel) {
        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        if (this.repath()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: repath");
            return true;
        }
        if (this.rotateAnchor()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: rotate targetPos side");
            return true;
        }
        return false;
    }

    private void handleActing() {
        if (this.animationEnd > 0L) {
            this.markProgress();
            return;
        }
        if (this.timedOut(60)) {
            BotDebug.log(this.byteBuddy, "ACTING timeout; abort");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "abort act");
        }
    }

    private void handleSeeking(ServerLevel serverLevel) {
        if (!this.timedOut(20)) {
            return;
        }
        if (this.targetReselectRetries++ < 2) {
            PlantPlan plantPlan = this.findPlantPlan(null, null, null, this.byteBuddy.effectiveRadius());
            if (plantPlan != null) {
                DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
                if (dockBlock != null && !dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.PLANT, plantPlan.plantPos(), this.byteBuddy.getUUID(), 120)) {
                    this.enterPhase(BotDebug.GoalPhase.SEEKING, "seek retry (claim failed)");
                    return;
                }
                this.claimedPlantPos = plantPlan.plantPos();
                this.nextClaimRenewPlant = serverLevel.getGameTime() + 5L;
                this.claimedPlantSeed = plantPlan.seedItem();
                this.claimedPlantState = plantPlan.plantState();
                this.targetPos = plantPlan.plantPos();
                this.approachPos = plantPlan.standPos();
                this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
                this.resetProgress();
                this.enterPhase(BotDebug.GoalPhase.MOVING, "retry seek -> moving");
            } else {
                this.enterPhase(BotDebug.GoalPhase.IDLE, "seek timeout, no target");
            }
        } else {
            this.enterPhase(BotDebug.GoalPhase.IDLE, "seek timeout (exhausted)");
        }
    }

    @Nullable
    private PlantPlan findPlantPlan(@Nullable BlockPos plantPos, @Nullable Item plantSeed, @Nullable BlockState prefPlantState, int effectiveRadius) {
        BlockPos dockBlockPos = this.byteBuddy.getDock().orElse(null);
        if (dockBlockPos == null) {
            return null;
        }
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
            if (plantPos != null && prefPlantState != null) {
                if (!(dockBlock == null || this.claimedPlantPos != null && this.claimedPlantPos.equals((Object)plantPos))) {
                    if (!dockBlock.tryClaim(serverLevel, ByteBuddyEntity.TaskType.PLANT, plantPos, this.byteBuddy.getUUID(), 120)) {
                        return null;
                    }
                    this.claimedPlantPos = plantPos;
                    this.nextClaimRenewPlant = serverLevel.getGameTime() + 5L;
                }
                if (!GoalUtil.canPlantAt(level, plantPos, prefPlantState)) {
                    return null;
                }
                BlockPos[] sides = new BlockPos[]{plantPos.east(), plantPos.west(), plantPos.south(), plantPos.north()};
                BlockPos bestStand = null;
                Path bestPath = null;
                double bestDist = Double.POSITIVE_INFINITY;
                BlockPos[] blockPosArray = this.byteBuddy.getNavigation();
                if (blockPosArray instanceof GroundPathNavigation) {
                    GroundPathNavigation pathNavigation = (GroundPathNavigation)blockPosArray;
                    for (BlockPos side : sides) {
                        double horizontalDist;
                        Path path;
                        if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, side) || (path = pathNavigation.createPath(side, 0)) == null || !((horizontalDist = GoalUtil.hDistSq(this.byteBuddy.position(), side.getCenter())) < bestDist)) continue;
                        bestDist = horizontalDist;
                        bestStand = side;
                        bestPath = path;
                    }
                }
                if (bestStand == null) {
                    bestStand = plantPos;
                    bestPath = null;
                }
                Item useSeed = plantSeed != null ? plantSeed : null;
                return new PlantPlan(plantPos.immutable(), useSeed, prefPlantState, bestStand, bestPath);
            }
            ItemStackHandler inventory = this.byteBuddy.getMainInv();
            ArrayList<Item> seeds = new ArrayList<Item>();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                Item itemInSlot;
                BlockState seedCandidate;
                ItemStack stackInSlot = inventory.getStackInSlot(i);
                if (stackInSlot.isEmpty() || (seedCandidate = PlantGoal.seedToPlantState(itemInSlot = stackInSlot.getItem())) == null) continue;
                seeds.add(itemInSlot);
            }
            if (seeds.isEmpty()) {
                return null;
            }
            BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos();
            for (int y = -1; y <= 2; ++y) {
                for (int dx = -effectiveRadius; dx <= effectiveRadius; ++dx) {
                    for (int dz = -effectiveRadius; dz <= effectiveRadius; ++dz) {
                        origin.set(dockBlockPos.getX() + dx, dockBlockPos.getY() + y, dockBlockPos.getZ() + dz);
                        if (dockBlock != null && dockBlock.isReserved(serverLevel, ByteBuddyEntity.TaskType.PLANT, (BlockPos)origin)) continue;
                        for (Item seed : seeds) {
                            BlockState plantState = PlantGoal.seedToPlantState(seed);
                            if (plantState == null || !GoalUtil.canPlantAt(level, (BlockPos)origin, plantState)) continue;
                            BlockPos[] sides = new BlockPos[]{origin.east(), origin.west(), origin.south(), origin.north()};
                            BlockPos.MutableBlockPos bestStand = null;
                            Path bestPath = null;
                            double bestDist = Double.POSITIVE_INFINITY;
                            BlockPos[] blockPosArray = this.byteBuddy.getNavigation();
                            if (blockPosArray instanceof GroundPathNavigation) {
                                GroundPathNavigation pathNavigation = (GroundPathNavigation)blockPosArray;
                                for (BlockPos side : sides) {
                                    double horizontalDist;
                                    Path path;
                                    if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, side) || (path = pathNavigation.createPath(side, 0)) == null || !((horizontalDist = GoalUtil.hDistSq(this.byteBuddy.position(), side.getCenter())) < bestDist)) continue;
                                    bestDist = horizontalDist;
                                    bestStand = side;
                                    bestPath = path;
                                }
                            }
                            if (bestStand == null) {
                                bestStand = origin;
                                bestPath = null;
                            }
                            return new PlantPlan(origin.immutable(), seed, plantState, (BlockPos)bestStand, bestPath);
                        }
                    }
                }
            }
        }
        return null;
    }

    private void performPlant(BlockPos blockPos) {
        boolean soilPlantable;
        boolean canPlantHere;
        Level level = this.byteBuddy.level();
        if (this.claimedPlantState == null || this.claimedPlantSeed == null) {
            BotDebug.log(this.byteBuddy, "no queued plant info at " + blockPos.toShortString());
            this.failTask(BotDebug.FailReason.NO_TARGET, "no queued plant info at " + blockPos.toShortString());
            return;
        }
        ItemStack seedStack = InventoryUtil.findItem(this.byteBuddy.getMainInv(), this.claimedPlantSeed);
        if (seedStack.isEmpty()) {
            BotDebug.log(this.byteBuddy, "no seed item (" + String.valueOf(this.claimedPlantSeed) + ") for replant at " + blockPos.toShortString());
            this.failTask(BotDebug.FailReason.NO_TARGET, "no seed item (" + String.valueOf(this.claimedPlantSeed) + ") for replant at " + blockPos.toShortString());
            return;
        }
        BlockState blockBelow = level.getBlockState(blockPos.below());
        TriState canSustainPlant = blockBelow.canSustainPlant((BlockGetter)level, blockPos.below(), Direction.UP, this.claimedPlantState);
        boolean bl = canPlantHere = canSustainPlant.isDefault() ? this.claimedPlantState.canSurvive((LevelReader)level, blockPos) : canSustainPlant.isTrue();
        if (!canPlantHere) {
            BotDebug.log(this.byteBuddy, "cannot plant here (plantPos/conditions) at " + blockPos.toShortString());
            this.failTask(BotDebug.FailReason.NO_TARGET, "cannot plant here (plantPos/conditions) at " + blockPos.toShortString());
            return;
        }
        BlockState aboveSoil = level.getBlockState(blockPos);
        boolean bl2 = soilPlantable = aboveSoil.isAir() || aboveSoil.getCollisionShape((BlockGetter)level, blockPos).isEmpty();
        if (!soilPlantable) {
            BotDebug.log(this.byteBuddy, "space not clear for plant at " + blockPos.toShortString());
            this.failTask(BotDebug.FailReason.NO_TARGET, "space not clear for plant at " + blockPos.toShortString());
            return;
        }
        if (GoalUtil.canPlantAt(level, blockPos, this.claimedPlantState)) {
            if (!this.byteBuddy.consumeEnergy(25)) {
                this.failTask(BotDebug.FailReason.OUT_OF_ENERGY, "need=25");
                this.releasePlantClaim();
                return;
            }
            level.playSound(null, blockPos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 0.8f + level.random.nextFloat() * 0.4f, 0.9f + level.random.nextFloat() * 0.2f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int particlePoints = 12;
                for (int i = 0; i < particlePoints; ++i) {
                    double particleInterval = Math.PI * 2 * (double)i / (double)particlePoints;
                    serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)this.claimedPlantSeed)), (double)blockPos.getX() + 0.5 + Math.cos(particleInterval) * 0.5, (double)blockPos.getY() + 0.125, (double)blockPos.getZ() + 0.5 + Math.sin(particleInterval) * 0.5, 1, 0.0, 0.0, 0.0, 0.05);
                }
            }
            level.setBlock(blockPos, this.claimedPlantState, 3);
            seedStack.shrink(1);
            this.byteBuddy.onTaskSuccess(ByteBuddyEntity.TaskType.PLANT, blockPos);
            this.releasePlantClaim();
            this.claimedPlantState = null;
            this.claimedPlantSeed = null;
            this.claimedPlantPos = null;
            return;
        }
        this.failTask(BotDebug.FailReason.NO_TARGET, "cannot plant here (plantPos/conditions) at " + blockPos.toShortString());
    }

    @Nullable
    private static BlockState seedToPlantState(Item seedItem) {
        if (seedItem instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)seedItem;
            Block block = blockItem.getBlock();
            if (block instanceof CropBlock) {
                return block.defaultBlockState();
            }
            if (block instanceof BushBlock) {
                return block.defaultBlockState();
            }
        }
        return null;
    }

    private boolean repath() {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            Path path;
            GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
            if (this.repathRetries++ >= 2) {
                return false;
            }
            if (this.approachPos == null) {
                return false;
            }
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            if ((path = pathNavigation2.createPath(this.approachPos, 0)) == null) {
                return false;
            }
            pathNavigation2.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            Level level2 = this.byteBuddy.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            return true;
        }
        return false;
    }

    private boolean rotateAnchor() {
        if (this.approachPlans.isEmpty() || this.targetPos == null) {
            return false;
        }
        if (this.anchorRotateRetries >= 3) {
            return false;
        }
        int approaches = this.approachPlans.size();
        for (int tries = 0; tries < approaches; ++tries) {
            ServerLevel serverLevel;
            Vec3 anchor;
            this.anchorIndex = (this.anchorIndex + 1) % approaches;
            Approach approachCandidates = this.approachPlans.get(this.anchorIndex);
            BlockPos standPos = approachCandidates.targetPos();
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.level(), standPos) || (anchor = approachCandidates.approachAnchor()) == null) continue;
            Path path = null;
            PathNavigation pathNavigation = this.byteBuddy.getNavigation();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                path = pathNavigation2.createPath(standPos, 0);
            }
            if (path == null) continue;
            this.approachPos = standPos;
            this.targetAnchor = anchor;
            this.edgeAnchored = false;
            pathNavigation = this.byteBuddy.level();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            this.byteBuddy.getNavigation().moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            pathNavigation = this.byteBuddy.level();
            if (pathNavigation instanceof ServerLevel) {
                serverLevel = (ServerLevel)pathNavigation;
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            }
            ++this.anchorRotateRetries;
            this.markProgress();
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
            return true;
        }
        return false;
    }

    private void startTimedAnimation(int totalTicks, int startTick, @Nullable BlockPos fireAt, @Nullable BlockState preState) {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.byteBuddy.getNavigation().stop();
            Vec3 deltaMovement = this.byteBuddy.getDeltaMovement();
            this.byteBuddy.setDeltaMovement(deltaMovement.x * 0.1, deltaMovement.y * 0.1, deltaMovement.z * 0.1);
            this.byteBuddy.setSlamming(true);
            this.actionStarted = false;
            long currentTime = serverLevel.getGameTime();
            this.animationStart = currentTime + (long)Math.max(0, startTick);
            this.animationEnd = currentTime + (long)Math.max(1, totalTicks);
            this.firePos = fireAt;
            this.firePreState = preState;
            float speedMul = Math.max(0.25f, this.byteBuddy.actionSpeedMultiplier());
            this.nextActionTick = currentTime + (long)Math.max(4, Math.round(20.0f / speedMul));
            this.enterPhase(BotDebug.GoalPhase.ACTING, "animation: PLANT fire@" + startTick + " end@" + totalTicks);
        }
    }

    private void tickTimedAnimation() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.getGameTime();
            if (!this.actionStarted && currentTime >= this.animationStart && this.firePos != null && this.firePreState != null) {
                this.actionStarted = true;
                BotDebug.log(this.byteBuddy, "PLANT anim: now=" + currentTime + " start=" + this.animationStart + " end=" + this.animationEnd + " fired=" + this.actionStarted + " firePos=" + (this.firePos != null));
                this.performPlant(this.firePos);
            }
            if (this.currentPhase == BotDebug.GoalPhase.ACTING && this.animationEnd > 0L && currentTime >= this.animationEnd) {
                this.clearTimedAnimation();
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "PLANT: complete");
            }
        }
    }

    private void clearTimedAnimation() {
        this.actionStarted = false;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.byteBuddy.setSlamming(false);
    }

    private boolean verifyClaimOrAbort(ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, @Nullable BlockPos claimedPos, @Nullable BlockPos currentTaskPos) {
        if (claimedPos == null) {
            return false;
        }
        if (currentTaskPos != null && !currentTaskPos.equals((Object)claimedPos)) {
            return false;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (dockBlock == null) {
            return false;
        }
        boolean buddyReserved = dockBlock.isReservedBy(serverLevel, taskType, claimedPos, this.byteBuddy.getUUID());
        if (!buddyReserved) {
            BotDebug.log(this.byteBuddy, "lost " + String.valueOf((Object)taskType) + " claim at " + claimedPos.toShortString() + " \u2014 aborting");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "claim lost; rescan");
        }
        return buddyReserved;
    }

    private void releasePlantClaim() {
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(this.byteBuddy);
        if (this.claimedPlantPos != null && dockBlock != null) {
            dockBlock.releaseClaim(ByteBuddyEntity.TaskType.PLANT, this.claimedPlantPos, this.byteBuddy.getUUID());
        }
        this.claimedPlantPos = null;
    }

    private void enterPhase(BotDebug.GoalPhase phase, String context) {
        Level level;
        this.currentPhase = phase;
        this.lastFail = BotDebug.FailReason.NONE;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
        if (phase == BotDebug.GoalPhase.MOVING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        }
        if (phase == BotDebug.GoalPhase.SEEKING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.targetReselectRetries = 0;
        }
        if (phase == BotDebug.GoalPhase.ACTING && (level = this.byteBuddy.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        BotDebug.log(this.byteBuddy, "FARMER: " + String.valueOf((Object)phase) + (String)(context.isEmpty() ? "" : " -> " + context));
    }

    private void clearTarget() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        this.releasePlantClaim();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.firePos = null;
        this.firePreState = null;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
    }

    private void failTask(BotDebug.FailReason reason, String context) {
        this.lastFail = reason;
        this.currentPhase = BotDebug.GoalPhase.IDLE;
        BotDebug.log(this.byteBuddy, "FARMER cannot start: " + String.valueOf((Object)reason) + (String)(context.isEmpty() ? "" : " (" + context + ")"));
        this.resetProgress();
        this.stop();
    }

    private void resetProgress() {
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        this.repathRetries = 0;
        this.anchorRotateRetries = 0;
        this.targetReselectRetries = 0;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private void markProgress() {
        this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private boolean stalledFor(int stallTime) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseProgressTick > (long)stallTime;
    }

    private boolean timedOut(int timeLimit) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseStartedTick > (long)timeLimit;
    }

    private record PlantPlan(BlockPos plantPos, Item seedItem, BlockState plantState, BlockPos standPos, @Nullable Path path) {
    }

    private record Approach(BlockPos targetPos, Vec3 approachAnchor, double distSq, Path path) {
    }
}

