/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.ai.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.GoalUtil;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class HaulerGoal
extends Goal {
    private static final int buddyHaulStart = 9;
    private final ByteBuddyEntity byteBuddy;
    @Nullable
    private BlockPos targetPos;
    @Nullable
    private BlockPos approachPos;
    private List<Approach> approachPlans = Collections.emptyList();
    private int anchorIndex = 0;
    @Nullable
    private Vec3 targetAnchor = null;
    private boolean edgeAnchored = false;
    private Step step = Step.TO_SOURCE;
    private boolean stepInitialized = false;
    private long nextActionTick = 0L;
    private static final int baseActionCooldown = 20;
    private BotDebug.GoalPhase currentPhase = BotDebug.GoalPhase.IDLE;
    private BotDebug.FailReason lastFail = BotDebug.FailReason.NONE;
    private long phaseStartedTick = 0L;
    private long phaseProgressTick = 0L;
    private int repathRetries = 0;
    private int anchorRotateRetries = 0;
    private int targetReselectRetries = 0;
    private static final int seekingTimout = 20;
    private static final int movingTimeout = 160;
    private static final int actingTimeout = 60;
    private double lastMoveDistSq = Double.POSITIVE_INFINITY;
    private double lastAnchorDistSq = Double.POSITIVE_INFINITY;
    private static final double reachDistanceMin = 0.95;
    private static final double verticalTolerance = 1.66;
    private static final double finalApproachDist = 1.66;
    private static final double microDistMin = 0.15;
    private static final double microDistMax = 0.28;
    @Nullable
    private BlockPos claimedHaulPos = null;
    @Nullable
    private BlockPos firePos = null;
    @Nullable
    private BlockState firePreState = null;
    private static final int claimTimeOut = 120;
    private long nextClaimRenewHaul = 0L;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private boolean actionStarted = false;

    public HaulerGoal(ByteBuddyEntity byteBuddy) {
        this.byteBuddy = byteBuddy;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        byteBuddy.setPathfindingMalus(PathType.WATER, 8.0f);
        byteBuddy.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
    }

    public boolean canUse() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() <= this.animationEnd;
            }
            return true;
        }
        if (this.byteBuddy.getBuddyRole() != ByteBuddyEntity.BuddyRole.STORAGE) {
            this.failTask(BotDebug.FailReason.WRONG_ROLE, "role=" + String.valueOf((Object)this.byteBuddy.getBuddyRole()));
            return false;
        }
        if (!GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 1, 128)) {
            return false;
        }
        BlockPos source = this.byteBuddy.getFirstPos();
        BlockPos dest = this.byteBuddy.getSecondPos();
        if (source == null || dest == null) {
            this.failTask(BotDebug.FailReason.NO_TARGET, "clipboard missing positions");
            return false;
        }
        if (this.targetPos == null) {
            Optional<HaulPlan> plan;
            if (!this.stepInitialized) {
                this.step = this.decideFirstStep();
                this.stepInitialized = true;
            }
            if ((plan = this.findHaulPlan(this.step == Step.TO_SOURCE ? source : dest)).isEmpty()) {
                return false;
            }
            this.targetPos = plan.get().targetPos();
            this.approachPos = plan.get().approachPos();
            this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
            this.edgeAnchored = false;
            this.resetProgress();
            this.enterPhase(BotDebug.GoalPhase.MOVING, "approach " + String.valueOf((Object)this.step) + " " + this.approachPos.toShortString());
        }
        return true;
    }

    public boolean canContinueToUse() {
        if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return serverLevel.getGameTime() <= this.animationEnd;
            }
            return true;
        }
        if (this.targetPos == null) {
            return false;
        }
        return GoalUtil.ensureUse(this.byteBuddy, ToolUtil.ToolType.EMPTY_HAND, 1, 128);
    }

    public void stop() {
        this.clearTimedAnimation();
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        super.stop();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            boolean withinReach;
            PathNavigation pathNavigation;
            ServerLevel serverLevel = (ServerLevel)level;
            this.tickTimedAnimation();
            if (this.targetPos == null || this.approachPos == null) {
                return;
            }
            Vec3 targetCenter = this.targetPos.getCenter();
            if (this.currentPhase == BotDebug.GoalPhase.ACTING) {
                this.byteBuddy.getLookControl().setLookAt(targetCenter.x, this.targetPos.getBottomCenter().y, targetCenter.z, 15.0f, 15.0f);
                return;
            }
            GoalUtil.renewClaimIfNeeded(this.byteBuddy, serverLevel, ByteBuddyEntity.TaskType.HAUL, this.claimedHaulPos, this.targetPos, serverLevel.getGameTime(), 5, 120, () -> this.nextClaimRenewHaul, ticks -> {
                this.nextClaimRenewHaul = ticks;
            });
            BlockEntity blockEntity = serverLevel.getBlockEntity(this.targetPos);
            if (blockEntity != null) {
                if (!this.targetStillViable(this.step, blockEntity, serverLevel, this.targetPos)) {
                    this.swapStepAndRetarget(this.byteBuddy);
                    return;
                }
            } else {
                this.clearTarget();
                return;
            }
            this.navigatePhases(serverLevel, this.byteBuddy);
            if (this.targetAnchor != null) {
                double distToTarget = this.byteBuddy.position().distanceTo(this.targetAnchor);
                if (distToTarget > 1.66) {
                    PathNavigation pathNavigation2 = this.byteBuddy.getNavigation();
                    if (pathNavigation2 instanceof GroundPathNavigation) {
                        boolean needsNewPath;
                        GroundPathNavigation pathNavigation3 = (GroundPathNavigation)pathNavigation2;
                        Path currentPath = pathNavigation3.getPath();
                        boolean bl = needsNewPath = currentPath == null || currentPath.isDone() || this.approachPos == null || !currentPath.getTarget().equals((Object)this.approachPos);
                        if (needsNewPath) {
                            Path path;
                            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                            Path path2 = path = this.approachPos != null ? pathNavigation3.createPath(this.approachPos, 0) : null;
                            if (path != null) {
                                pathNavigation3.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
                                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                            } else {
                                this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                            }
                        }
                    } else {
                        this.byteBuddy.getNavigation().moveTo(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                    }
                    return;
                }
                if (!this.edgeAnchored) {
                    GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                    if (distToTarget <= 0.15) {
                        GoalUtil.lockToAnchor(this.byteBuddy, this.targetAnchor);
                        this.edgeAnchored = true;
                        this.markProgress();
                        BotDebug.log(this.byteBuddy, "HAUL: locked anchor");
                    } else {
                        this.byteBuddy.getNavigation().stop();
                        this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
                        if (distToTarget + 0.001 < this.lastAnchorDistSq) {
                            this.lastAnchorDistSq = distToTarget;
                            this.markProgress();
                        }
                        BotDebug.log(this.byteBuddy, String.format("final-targetPos dH=%.3f to edge %s", distToTarget, this.approachPos.toShortString()));
                    }
                } else {
                    double distanceToTarget = this.byteBuddy.position().distanceTo(this.targetAnchor);
                    if (distanceToTarget > 0.28) {
                        this.edgeAnchored = false;
                    }
                }
            } else if (this.approachPos != null && (pathNavigation = this.byteBuddy.getNavigation()) instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation4 = (GroundPathNavigation)pathNavigation;
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                Path path = pathNavigation4.createPath(this.approachPos, 0);
                pathNavigation4.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
                GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
                return;
            }
            Vec3 buddyPos = this.byteBuddy.position();
            boolean bl = withinReach = buddyPos.distanceToSqr(targetCenter) <= 0.9025 && Math.abs(buddyPos.y - targetCenter.y) <= 1.66;
            if (withinReach) {
                if (this.animationEnd > 0L || this.currentPhase == BotDebug.GoalPhase.ACTING) {
                    this.byteBuddy.getLookControl().setLookAt(targetCenter.x, targetCenter.y, targetCenter.z, 15.0f, 15.0f);
                } else {
                    if (!GoalUtil.actionReady(serverLevel, this.nextActionTick)) {
                        return;
                    }
                    this.firePos = this.targetPos;
                    this.firePreState = this.byteBuddy.level().getBlockState(this.targetPos);
                    this.startTimedAnimation(GoalUtil.toTicks(2.6), GoalUtil.toTicks(1.8), this.targetPos, this.firePreState);
                    BlockEntity blockEntity2 = serverLevel.getBlockEntity(this.firePos);
                    if (blockEntity2 instanceof DockingStationBlockEntity) {
                        DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity2;
                        serverLevel.setBlock(this.firePos, (BlockState)dockBlock.getBlockState().setValue((Property)DockingStationBlock.OPEN, (Comparable)Boolean.TRUE), 3);
                    }
                    BotDebug.log(this.byteBuddy, "HAUL schedule " + String.valueOf((Object)this.step) + " now=" + serverLevel.getGameTime());
                }
            }
            if (this.targetAnchor != null && !this.edgeAnchored) {
                this.byteBuddy.getMoveControl().setWantedPosition(this.targetAnchor.x, this.targetAnchor.y, this.targetAnchor.z, (double)this.byteBuddy.actionSpeedMultiplier());
            }
        }
    }

    private Step decideFirstStep() {
        boolean hasAnyItems = this.hasAnyItems((IItemHandler)this.byteBuddy.getMainInv());
        return hasAnyItems ? Step.TO_DEST : Step.TO_SOURCE;
    }

    private Optional<HaulPlan> findHaulPlan(BlockPos blockPos) {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<Approach> plans = this.buildApproachPlans(level, blockPos);
            if (plans.isEmpty()) {
                return Optional.empty();
            }
            this.claimedHaulPos = blockPos.immutable();
            this.nextClaimRenewHaul = serverLevel.getGameTime() + 5L;
            this.approachPlans = plans;
            this.anchorIndex = 0;
            Approach firstApproach = plans.get(0);
            return Optional.of(new HaulPlan(blockPos, firstApproach.targetPos(), firstApproach.path()));
        }
        return Optional.empty();
    }

    private List<Approach> buildApproachPlans(Level level, BlockPos targetPos) {
        BlockPos[] sides;
        ArrayList<Approach> approachList = new ArrayList<Approach>(4);
        for (BlockPos approachPos : sides = new BlockPos[]{targetPos.east(), targetPos.west(), targetPos.south(), targetPos.north()}) {
            Path path;
            Vec3 edgeAnchor;
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, level, approachPos) || (edgeAnchor = GoalUtil.getEdgeAnchor(targetPos, approachPos)) == null) continue;
            PathNavigation pathNavigation = this.byteBuddy.getNavigation();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation pathNavigation2 = (GroundPathNavigation)pathNavigation;
                v0 = pathNavigation2.createPath(approachPos, 0);
            } else {
                v0 = path = null;
            }
            if (path == null) continue;
            double distSq = GoalUtil.hDistSq(this.byteBuddy.position(), edgeAnchor);
            approachList.add(new Approach(approachPos, edgeAnchor, distSq, path));
        }
        approachList.sort(Comparator.comparingDouble(Approach::distSq));
        return approachList;
    }

    private void planForCurrentStep(ByteBuddyEntity byteBuddy) {
        BlockPos sourcePos = byteBuddy.getFirstPos();
        BlockPos destinationPos = byteBuddy.getSecondPos();
        if (sourcePos == null || destinationPos == null) {
            this.enterPhase(BotDebug.GoalPhase.IDLE, "clipboard missing positions");
            return;
        }
        BlockPos targetPos = this.step == Step.TO_SOURCE ? sourcePos : destinationPos;
        Optional<HaulPlan> plan = this.findHaulPlan(targetPos);
        if (plan.isEmpty()) {
            this.enterPhase(BotDebug.GoalPhase.IDLE, "no approach");
            return;
        }
        this.targetPos = plan.get().targetPos();
        this.approachPos = plan.get().approachPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
        this.edgeAnchored = false;
        this.resetProgress();
        this.enterPhase(BotDebug.GoalPhase.MOVING, "retarget " + String.valueOf((Object)this.step) + " -> " + this.approachPos.toShortString());
    }

    private boolean targetStillViable(Step step, BlockEntity blockEntity, ServerLevel serverLevel, BlockPos blockPos) {
        if (step == Step.TO_SOURCE) {
            IItemHandler sourceInventory = (IItemHandler)serverLevel.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, null);
            if (sourceInventory == null) {
                return false;
            }
            if (this.findExtractableSlot(sourceInventory, blockEntity) < 0) {
                return false;
            }
            return this.buddyHasRoomForAnyFrom(sourceInventory);
        }
        return this.hasAnyItems((IItemHandler)this.byteBuddy.getMainInv());
    }

    private boolean buddyHasRoomForAnyFrom(IItemHandler sourceInventory) {
        ItemStackHandler buddyInventory = this.byteBuddy.getMainInv();
        for (int i = 0; i < sourceInventory.getSlots(); ++i) {
            ItemStack simulated;
            ItemStack stackInSlot = sourceInventory.getStackInSlot(i);
            if (stackInSlot.isEmpty() || (simulated = this.tryInsertAllRespectingBuddy((IItemHandler)buddyInventory, stackInSlot, true)).getCount() >= stackInSlot.getCount()) continue;
            return true;
        }
        return false;
    }

    private void swapStepAndRetarget(ByteBuddyEntity byteBuddy) {
        BlockPos sourcePos = byteBuddy.getFirstPos();
        BlockPos destinationPos = byteBuddy.getSecondPos();
        if (sourcePos == null || destinationPos == null) {
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "clipboard invalid");
            return;
        }
        this.step = this.step == Step.TO_SOURCE ? Step.TO_DEST : Step.TO_SOURCE;
        BlockPos newTarget = this.step == Step.TO_SOURCE ? sourcePos : destinationPos;
        Optional<HaulPlan> plan = this.findHaulPlan(newTarget);
        if (plan.isEmpty()) {
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "no approach");
            return;
        }
        this.targetPos = plan.get().targetPos();
        this.approachPos = plan.get().approachPos();
        this.targetAnchor = GoalUtil.getEdgeAnchor(this.targetPos, this.approachPos);
        this.edgeAnchored = false;
        this.resetProgress();
        this.enterPhase(BotDebug.GoalPhase.MOVING, "retarget " + String.valueOf((Object)this.step) + " -> " + this.approachPos.toShortString());
    }

    private void navigatePhases(ServerLevel serverLevel, ByteBuddyEntity byteBuddy) {
        switch (this.currentPhase) {
            case MOVING: {
                this.handleMoving(serverLevel);
                break;
            }
            case ACTING: {
                this.handleActing();
                break;
            }
            case SEEKING: {
                this.handleSeeking(byteBuddy);
                break;
            }
        }
    }

    private void handleMoving(ServerLevel serverLevel) {
        if (this.isWithinFinalApproach()) {
            this.renewPathAheadIfNeeded(serverLevel, 5);
            this.markProgress();
            return;
        }
        this.updateApproachProgress();
        this.renewPathAheadIfNeeded(serverLevel, 5);
        if (this.stalledFor(16)) {
            if (this.tryRecoverFromStall(serverLevel)) {
                this.markProgress();
            } else {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
                this.clearTarget();
                this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING stalled, rescan");
            }
            return;
        }
        if (this.timedOut(160)) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "MOVING timeout, rescan");
        }
    }

    private boolean isWithinFinalApproach() {
        if (this.edgeAnchored) {
            return true;
        }
        if (this.targetAnchor == null) {
            return false;
        }
        return Math.sqrt(GoalUtil.hDistSq(this.byteBuddy.position(), this.targetAnchor)) <= 1.66;
    }

    private void updateApproachProgress() {
        if (this.approachPos != null) {
            Vec3 progressToTarget = this.targetAnchor != null ? this.targetAnchor : this.approachPos.getCenter();
            double distSq = GoalUtil.hDistSq(this.byteBuddy.position(), progressToTarget);
            if (distSq + 0.001 < this.lastMoveDistSq) {
                this.lastMoveDistSq = distSq;
                this.markProgress();
            }
        }
    }

    private void renewPathAheadIfNeeded(ServerLevel serverLevel, int lookahead) {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (!(pathNavigation instanceof GroundPathNavigation)) {
            return;
        }
        GroundPathNavigation nav = (GroundPathNavigation)pathNavigation;
        Path path = nav.getPath();
        if (path == null) {
            return;
        }
        if (serverLevel.getGameTime() % 5L != 0L) {
            return;
        }
        this.byteBuddy.renewPathAhead(serverLevel, path, lookahead);
    }

    private boolean tryRecoverFromStall(ServerLevel serverLevel) {
        GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        if (this.repath()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: repath");
            return true;
        }
        if (this.rotateAnchor()) {
            GoalUtil.reserveCurrentPathIfAny(serverLevel, this.byteBuddy, 5);
            BotDebug.log(this.byteBuddy, "MOVING: rotate targetPos side");
            return true;
        }
        return false;
    }

    private void handleActing() {
        if (this.animationEnd > 0L) {
            this.markProgress();
            return;
        }
        if (this.timedOut(60)) {
            BotDebug.log(this.byteBuddy, "ACTING timeout; abort");
            this.clearTarget();
            this.enterPhase(BotDebug.GoalPhase.IDLE, "abort act");
        }
    }

    private void handleSeeking(ByteBuddyEntity byteBuddy) {
        if (!this.timedOut(20)) {
            return;
        }
        this.swapStepAndRetarget(byteBuddy);
    }

    private boolean repath() {
        PathNavigation pathNavigation = this.byteBuddy.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            Path path;
            GroundPathNavigation nav = (GroundPathNavigation)pathNavigation;
            if (this.repathRetries++ >= 2) {
                return false;
            }
            if (this.approachPos == null) {
                return false;
            }
            if (this.byteBuddy.level() instanceof ServerLevel) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            if ((path = nav.createPath(this.approachPos, 0)) == null) {
                return false;
            }
            nav.moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            Level level = this.byteBuddy.level();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                GoalUtil.reserveCurrentPathIfAny(sl, this.byteBuddy, 5);
            }
            return true;
        }
        return false;
    }

    private boolean rotateAnchor() {
        if (this.approachPlans.isEmpty() || this.targetPos == null) {
            return false;
        }
        if (this.anchorRotateRetries >= 3) {
            return false;
        }
        int n = this.approachPlans.size();
        for (int tries = 0; tries < n; ++tries) {
            Path path;
            Vec3 anchor;
            this.anchorIndex = (this.anchorIndex + 1) % n;
            Approach cand = this.approachPlans.get(this.anchorIndex);
            BlockPos stand = cand.targetPos();
            if (!ByteBuddyEntity.isStandableForMove(this.byteBuddy, this.byteBuddy.level(), stand) || (anchor = cand.approachAnchor()) == null) continue;
            PathNavigation pathNavigation = this.byteBuddy.getNavigation();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation nav = (GroundPathNavigation)pathNavigation;
                v0 = nav.createPath(stand, 0);
            } else {
                v0 = path = null;
            }
            if (path == null) continue;
            this.approachPos = stand;
            this.targetAnchor = anchor;
            this.edgeAnchored = false;
            if (this.byteBuddy.level() instanceof ServerLevel) {
                GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
            }
            this.byteBuddy.getNavigation().moveTo(path, (double)this.byteBuddy.actionSpeedMultiplier());
            pathNavigation = this.byteBuddy.level();
            if (pathNavigation instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)pathNavigation;
                GoalUtil.reserveCurrentPathIfAny(sl, this.byteBuddy, 5);
            }
            ++this.anchorRotateRetries;
            this.markProgress();
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
            return true;
        }
        return false;
    }

    private void startTimedAnimation(int totalTicks, int startTick, @Nullable BlockPos fireAt, @Nullable BlockState preState) {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.byteBuddy.getNavigation().stop();
            Vec3 deltaMovement = this.byteBuddy.getDeltaMovement();
            this.byteBuddy.setDeltaMovement(deltaMovement.x * 0.1, deltaMovement.y * 0.1, deltaMovement.z * 0.1);
            this.byteBuddy.setWorking(true);
            this.actionStarted = false;
            long currentTime = serverLevel.getGameTime();
            this.animationStart = currentTime + (long)Math.max(0, startTick);
            this.animationEnd = currentTime + (long)Math.max(1, totalTicks);
            this.firePos = fireAt;
            this.firePreState = preState;
            float speedMultiplier = Math.max(0.25f, this.byteBuddy.actionSpeedMultiplier());
            this.nextActionTick = currentTime + (long)Math.max(4, Math.round(20.0f / speedMultiplier));
            this.enterPhase(BotDebug.GoalPhase.ACTING, "animation: HAUL " + String.valueOf((Object)this.step));
        }
    }

    private void tickTimedAnimation() {
        Level level = this.byteBuddy.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            long currentTime = serverLevel.getGameTime();
            if (!this.actionStarted && currentTime >= this.animationStart && this.firePos != null && this.firePreState != null) {
                this.actionStarted = true;
                BotDebug.log(this.byteBuddy, "HAUL anim: now=" + currentTime + " start=" + this.animationStart + " end=" + this.animationEnd + " fired=" + this.actionStarted + " firePos=" + (this.firePos != null));
                this.performHaul(this.step, serverLevel, this.firePos);
                BlockEntity blockEntity = serverLevel.getBlockEntity(this.firePos);
                if (blockEntity instanceof DockingStationBlockEntity) {
                    DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
                    serverLevel.setBlock(this.firePos, (BlockState)dockBlock.getBlockState().setValue((Property)DockingStationBlock.OPEN, (Comparable)Boolean.FALSE), 3);
                }
            }
            if (this.currentPhase == BotDebug.GoalPhase.ACTING && this.animationEnd > 0L && currentTime >= this.animationEnd) {
                this.clearTimedAnimation();
                this.clearTarget();
                this.planForCurrentStep(this.byteBuddy);
            }
        }
    }

    private void clearTimedAnimation() {
        this.actionStarted = false;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.byteBuddy.setWorking(false);
    }

    private void performHaul(Step step, ServerLevel serverLevel, BlockPos blockPos) {
        if (step == Step.TO_SOURCE) {
            IItemHandler sourceInventory = (IItemHandler)serverLevel.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, null);
            if (sourceInventory == null) {
                return;
            }
            int sourceSlot = this.findExtractableSlot(sourceInventory, serverLevel.getBlockEntity(blockPos));
            if (sourceSlot < 0) {
                return;
            }
            ItemStack simulatedExtract = sourceInventory.extractItem(sourceSlot, 64, true);
            if (simulatedExtract.isEmpty()) {
                return;
            }
            ItemStack simulatedRemainder = this.tryInsertAllRespectingBuddy((IItemHandler)this.byteBuddy.getMainInv(), simulatedExtract, true);
            int insertableAmount = simulatedExtract.getCount() - simulatedRemainder.getCount();
            if (insertableAmount <= 0) {
                this.step = Step.TO_DEST;
                return;
            }
            if (!this.byteBuddy.consumeEnergy(insertableAmount)) {
                return;
            }
            ItemStack actuallyExtracted = sourceInventory.extractItem(sourceSlot, insertableAmount, false);
            if (actuallyExtracted.isEmpty()) {
                return;
            }
            ItemStack itemRemainder = this.tryInsertAllRespectingBuddy((IItemHandler)this.byteBuddy.getMainInv(), actuallyExtracted, false);
            int insertedAmount = actuallyExtracted.getCount() - itemRemainder.getCount();
            if (insertedAmount > 0) {
                BotDebug.log(this.byteBuddy, "HAUL: took " + insertedAmount + "x " + actuallyExtracted.getDisplayName().getString());
                this.step = Step.TO_DEST;
            }
            if (!itemRemainder.isEmpty()) {
                for (int slot = 0; slot < sourceInventory.getSlots() && !itemRemainder.isEmpty(); ++slot) {
                    itemRemainder = sourceInventory.insertItem(slot, itemRemainder, false);
                }
                if (!itemRemainder.isEmpty()) {
                    Containers.dropItemStack((Level)serverLevel, (double)((double)blockPos.getX() + 0.5), (double)(blockPos.getY() + 1), (double)((double)blockPos.getZ() + 0.5), (ItemStack)itemRemainder);
                }
            }
            return;
        }
        IItemHandler targetInventory = (IItemHandler)serverLevel.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, null);
        if (targetInventory == null) {
            return;
        }
        ItemStackHandler buddy = this.byteBuddy.getMainInv();
        for (int i = 9; i < buddy.getSlots(); ++i) {
            ItemStack toSend;
            ItemStack itemRemainder;
            int movedAmount;
            ItemStack stackInSlot = buddy.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            ItemStack simulatedDeposit = this.tryInsertAll(targetInventory, stackInSlot, true);
            int movableAmount = stackInSlot.getCount() - simulatedDeposit.getCount();
            if (movableAmount <= 0 || !this.byteBuddy.consumeEnergy(movableAmount)) continue;
            BlockEntity insertedAmount = serverLevel.getBlockEntity(blockPos);
            if (insertedAmount instanceof DockingStationBlockEntity) {
                DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)insertedAmount;
                serverLevel.setBlock(blockPos, (BlockState)dockBlock.getBlockState().setValue((Property)DockingStationBlock.OPEN, (Comparable)Boolean.TRUE), 3);
            }
            if ((movedAmount = movableAmount - (itemRemainder = this.tryInsertAll(targetInventory, toSend = stackInSlot.copyWithCount(movableAmount), false)).getCount()) > 0) {
                buddy.extractItem(i, movedAmount, false);
                BotDebug.log(this.byteBuddy, "HAUL: delivered " + movedAmount + "x " + stackInSlot.getDisplayName().getString());
                this.step = Step.TO_SOURCE;
                return;
            }
            this.byteBuddy.getEnergyStorage().receiveEnergy(movableAmount, false);
        }
        this.step = Step.TO_SOURCE;
    }

    private int findExtractableSlot(IItemHandler sourceInventory, BlockEntity blockEntity) {
        if (blockEntity instanceof DockingStationBlockEntity) {
            for (int i = 2; i < sourceInventory.getSlots(); ++i) {
                ItemStack itemStack = sourceInventory.getStackInSlot(i);
                if (itemStack.isEmpty()) continue;
                return i;
            }
        } else {
            for (int i = 0; i < sourceInventory.getSlots(); ++i) {
                ItemStack itemStack = sourceInventory.getStackInSlot(i);
                if (itemStack.isEmpty()) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean hasAnyItems(IItemHandler inventory) {
        for (int i = 9; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private ItemStack tryInsertAll(IItemHandler destinationInventory, ItemStack itemStack, boolean simulate) {
        ItemStack remainder = itemStack.copy();
        for (int slot = 0; slot < destinationInventory.getSlots() && !(remainder = destinationInventory.insertItem(slot, remainder, simulate)).isEmpty(); ++slot) {
        }
        return remainder;
    }

    private ItemStack tryInsertAllRespectingBuddy(IItemHandler destinationInventory, ItemStack itemStack, boolean simulate) {
        if (destinationInventory == this.byteBuddy.getMainInv()) {
            ItemStack remainder = itemStack.copy();
            for (int slot = 9; slot < destinationInventory.getSlots() && !(remainder = destinationInventory.insertItem(slot, remainder, simulate)).isEmpty(); ++slot) {
            }
            return remainder;
        }
        return this.tryInsertAll(destinationInventory, itemStack, simulate);
    }

    private void enterPhase(BotDebug.GoalPhase phase, String context) {
        this.currentPhase = phase;
        this.lastFail = BotDebug.FailReason.NONE;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
        if (phase == BotDebug.GoalPhase.MOVING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.lastMoveDistSq = Double.POSITIVE_INFINITY;
            this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        }
        if (phase == BotDebug.GoalPhase.SEEKING) {
            this.repathRetries = 0;
            this.anchorRotateRetries = 0;
            this.targetReselectRetries = 0;
        }
        if (phase == BotDebug.GoalPhase.ACTING && this.byteBuddy.level() instanceof ServerLevel) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        BotDebug.log(this.byteBuddy, "HAULER: " + String.valueOf((Object)phase) + (String)(context.isEmpty() ? "" : " -> " + context));
    }

    private void clearTarget() {
        if (this.byteBuddy.level() instanceof ServerLevel) {
            GoalUtil.releaseCurrentPathIfAny(this.byteBuddy);
        }
        this.targetPos = null;
        this.approachPos = null;
        this.targetAnchor = null;
        this.edgeAnchored = false;
        this.firePos = null;
        this.firePreState = null;
        this.approachPlans = Collections.emptyList();
        this.anchorIndex = 0;
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
    }

    private void failTask(BotDebug.FailReason reason, String context) {
        this.lastFail = reason;
        this.currentPhase = BotDebug.GoalPhase.IDLE;
        BotDebug.log(this.byteBuddy, "HAULER cannot start: " + String.valueOf((Object)reason) + (String)(context.isEmpty() ? "" : " (" + context + ")"));
        this.resetProgress();
        this.stop();
    }

    private void resetProgress() {
        this.lastMoveDistSq = Double.POSITIVE_INFINITY;
        this.lastAnchorDistSq = Double.POSITIVE_INFINITY;
        this.repathRetries = 0;
        this.anchorRotateRetries = 0;
        this.targetReselectRetries = 0;
        this.phaseStartedTick = this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private void markProgress() {
        this.phaseProgressTick = GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy);
    }

    private boolean stalledFor(int stallTime) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseProgressTick > (long)stallTime;
    }

    private boolean timedOut(int timeLimit) {
        return GoalUtil.getCurrentTime((LivingEntity)this.byteBuddy) - this.phaseStartedTick > (long)timeLimit;
    }

    private static enum Step {
        TO_SOURCE,
        TO_DEST;

    }

    private record HaulPlan(BlockPos targetPos, BlockPos approachPos, Path path) {
    }

    private record Approach(BlockPos targetPos, Vec3 approachAnchor, double distSq, Path path) {
    }
}

