/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.bytebuddies.entity.ModEntities;
import net.turtleboi.bytebuddies.particle.ModParticles;
import org.jetbrains.annotations.NotNull;

public class SwordSweepEntity
extends Projectile {
    int lifespan = 40;
    private float projectileDamage = 0.0f;
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    private static final float originalWidth = 0.625f;
    private static final float originalHeight = 2.0f;
    private float entityWidth = 0.625f;
    private float entityHeight = 2.0f;
    private boolean traveling = false;
    private double travelDistance = 1.0;
    private double traveledDistance = 0.0;
    private int lastSize = -1;
    private static final EntityDataAccessor<Float> DATA_WIDTH = SynchedEntityData.defineId(SwordSweepEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT = SynchedEntityData.defineId(SwordSweepEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public SwordSweepEntity(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
    }

    public SwordSweepEntity(Level level) {
        this(ModEntities.SWORD_SWEEP.get(), level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_WIDTH, (Object)Float.valueOf(0.625f));
        builder.define(DATA_HEIGHT, (Object)Float.valueOf(2.0f));
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> dataValues) {
        super.onSyncedDataUpdated(dataValues);
        if (dataValues == DATA_WIDTH || dataValues == DATA_HEIGHT) {
            this.entityWidth = ((Float)this.entityData.get(DATA_WIDTH)).floatValue();
            this.entityHeight = ((Float)this.entityData.get(DATA_HEIGHT)).floatValue();
            this.setOldPosAndRot();
            this.refreshDimensions();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            for (int i = 0; i < 1; ++i) {
                this.level().addParticle((ParticleOptions)ModParticles.SUPERCHARGED_PARTICLE.get(), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.3))) {
            if (entity == this.getOwner() || !(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (this.hitEntities.contains(entity.getUUID())) continue;
            target.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.getProjectileDamage());
            this.hitEntities.add(entity.getUUID());
        }
        Vec3 deltaMovement = this.getDeltaMovement();
        double nextX = this.getX() + deltaMovement.x;
        double nextY = this.getY() + deltaMovement.y;
        double nextZ = this.getZ() + deltaMovement.z;
        double decelRate = -0.125;
        double minSpeed = 0.125;
        Vec3 adjustedDelta = deltaMovement.scale(1.0 + decelRate);
        double speed = adjustedDelta.length();
        if (speed < minSpeed) {
            if (speed > 1.0E-9) {
                adjustedDelta = adjustedDelta.scale(minSpeed / speed);
            } else {
                Vec3 fallback = deltaMovement.lengthSqr() > 1.0E-12 ? deltaMovement : this.getLookAngle();
                adjustedDelta = fallback.normalize().scale(minSpeed);
            }
        }
        if (!this.traveling) {
            int tickToStop;
            double initialSpeed = this.getDeltaMovement().length();
            double decelFactorPerTick = 1.0 + decelRate;
            if (initialSpeed > minSpeed) {
                tickToStop = (int)Math.ceil(Math.log(minSpeed / initialSpeed) / Math.log(decelFactorPerTick));
                tickToStop = Math.max(0, Math.min(tickToStop, this.getLifespan()));
            } else {
                tickToStop = 0;
            }
            double distanceBeforeStop = 0.0;
            if (tickToStop > 0) {
                distanceBeforeStop = initialSpeed * (1.0 - Math.pow(decelFactorPerTick, tickToStop)) / (1.0 - decelFactorPerTick);
            }
            int remainingTicks = Math.max(0, this.getLifespan() - tickToStop);
            double distanceAfterStop = (double)remainingTicks * minSpeed;
            this.travelDistance = Math.max(1.0E-6, distanceBeforeStop + distanceAfterStop);
            this.traveledDistance = 0.0;
            this.traveling = true;
        }
        this.traveledDistance += adjustedDelta.length();
        this.setDeltaMovement(adjustedDelta);
        this.hasImpulse = true;
        this.setPos(nextX, nextY, nextZ);
        this.updateSizeFromScale();
        if (this.tickCount > this.lifespan) {
            this.discard();
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)this.entityWidth, (float)this.entityHeight);
    }

    private void updateSizeFromScale() {
        float scaleMultiplier = this.getScaleMultiplier();
        float targetWidth = 0.625f * scaleMultiplier;
        float targetHeight = 2.0f * scaleMultiplier;
        int scale = Mth.floor((float)(scaleMultiplier * 32.0f));
        if (!this.level().isClientSide && scale != this.lastSize) {
            this.lastSize = scale;
            this.entityData.set(DATA_WIDTH, (Object)Float.valueOf(targetWidth));
            this.entityData.set(DATA_HEIGHT, (Object)Float.valueOf(targetHeight));
            this.entityWidth = targetWidth;
            this.entityHeight = targetHeight;
            this.refreshDimensions();
        }
    }

    private float getScaleMultiplier() {
        double distanceProgress = this.travelDistance <= 0.0 ? 1.0 : Mth.clamp((double)(this.traveledDistance / this.travelDistance), (double)0.0, (double)1.0);
        float progress = (float)distanceProgress;
        return progress * 2.0f + 0.25f;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setProjectileDamage(float projectileDamage) {
        this.projectileDamage = projectileDamage;
    }

    public float getProjectileDamage() {
        return this.projectileDamage;
    }

    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)result);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
    }

    protected void onHitBlock(BlockHitResult result) {
    }
}

