/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.turtleboi.bytebuddies.entity.animations.ByteBuddyAnimations;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import org.jetbrains.annotations.NotNull;

public class ByteBuddyModel<T extends Entity>
extends HierarchicalModel<T>
implements ArmedModel {
    public static final ModelLayerLocation BYTEBUDDY_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"bytebuddy"), "main");
    private final ModelPart bytebuddy;
    private final ModelPart head;
    private final ModelPart display;
    private final ModelPart displayBg;
    private final ModelPart displayFace;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ByteBuddyModel(ModelPart root) {
        this.bytebuddy = root.getChild("bytebuddy");
        this.head = this.bytebuddy.getChild("head");
        this.display = this.head.getChild("display");
        this.displayBg = this.display.getChild("displayBg");
        this.displayFace = this.display.getChild("displayFace");
        this.rightArm = this.bytebuddy.getChild("rightArm");
        this.leftArm = this.bytebuddy.getChild("leftArm");
        this.rightLeg = this.bytebuddy.getChild("rightLeg");
        this.leftLeg = this.bytebuddy.getChild("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bytebuddy = partdefinition.addOrReplaceChild("bytebuddy", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = bytebuddy.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition display = head.addOrReplaceChild("display", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.05f));
        display.addOrReplaceChild("displayBg", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -1.95f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        display.addOrReplaceChild("displayFace", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -2.05f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        PartDefinition rightArm = bytebuddy.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(16, 16).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-4.5f, (float)0.0f));
        PartDefinition leftArm = bytebuddy.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(16, 16).mirror().addBox(0.0f, -1.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)-4.5f, (float)0.0f));
        PartDefinition rightLeg = bytebuddy.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.25f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-1.75f, (float)0.0f));
        PartDefinition leftLeg = bytebuddy.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.0f, -1.25f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-1.75f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(@NotNull Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        ByteBuddyEntity byteBuddy = (ByteBuddyEntity)entity;
        if (!byteBuddy.isSleeping()) {
            if (byteBuddy.isWaking()) {
                this.animate(byteBuddy.wakeUpState, ByteBuddyAnimations.WAKE_UP_ANIMATION, ageInTicks, 1.0f);
            }
            if (!byteBuddy.isWaking()) {
                this.applyHeadRotation(netHeadYaw, headPitch);
                this.animateWalk(ByteBuddyAnimations.WALKING_ANIMATION, limbSwing, limbSwingAmount, 2.0f, 2.4f);
                this.animate(byteBuddy.idleAnimationState, ByteBuddyAnimations.IDLE_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isWaving()) {
                this.animate(byteBuddy.waveState, ByteBuddyAnimations.WAVING_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isWorking()) {
                this.animate(byteBuddy.workingState, ByteBuddyAnimations.WORK_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isSlamming()) {
                this.animate(byteBuddy.slamState, ByteBuddyAnimations.SLAM_ANIMATION, ageInTicks, 1.0f);
            }
            if (byteBuddy.isSlicing()) {
                this.animate(byteBuddy.sliceState, ByteBuddyAnimations.SLICE_ANIMATION, ageInTicks, 1.0f);
            }
        } else {
            this.animate(byteBuddy.sleepPoseState, ByteBuddyAnimations.INACTIVE_ANIMATION, ageInTicks, 1.0f);
        }
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch) {
        pNetHeadYaw = Mth.clamp((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.bytebuddy.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.bytebuddy;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.bytebuddy.translateAndRotate(poseStack);
        float scale = 0.63f;
        ModelPart armPart = arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
        armPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -5.0f * scale * 0.0625f, scale * 0.0625f);
        poseStack.scale(scale, scale, scale);
    }

    public void setDisplayVisibility(boolean bgVisible, boolean faceVisible) {
        this.displayBg.visible = bgVisible;
        this.displayFace.visible = faceVisible;
    }

    public void translateToDisplay(PoseStack pose) {
        this.bytebuddy.translateAndRotate(pose);
        this.head.translateAndRotate(pose);
        this.display.translateAndRotate(pose);
    }

    public void renderDisplayBg(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.displayBg.render(poseStack, vertexConsumer, light, overlay, color);
    }
}

