/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.entity.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.turtleboi.bytebuddies.client.renderer.util.VertexBuilder;
import net.turtleboi.bytebuddies.entity.entities.SwordSweepEntity;

public class SwordSweepRenderer
extends EntityRenderer<SwordSweepEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"bytebuddies", (String)"textures/entity/terrablade_sweep.png");

    public SwordSweepRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SwordSweepEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        float fadeMultiplier;
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TEXTURE));
        int baseAlpha = 196;
        float lifespanPercent = ((float)entity.tickCount + partialTicks) / (float)entity.getLifespan();
        if (lifespanPercent <= 0.9f) {
            fadeMultiplier = 1.0f;
        } else {
            float fade = (lifespanPercent - 0.9f) / 0.1f;
            fadeMultiplier = 1.0f - Mth.clamp((float)fade, (float)0.0f, (float)1.0f);
        }
        int vertexAlpha = Mth.clamp((int)Math.round((float)baseAlpha * fadeMultiplier), (int)0, (int)255);
        poseStack.pushPose();
        poseStack.translate(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        this.createBladeSweep(entity, poseStack, vertexConsumer, 0.03125f * entity.getBbHeight(), vertexAlpha);
        poseStack.popPose();
    }

    private void createBladeSweep(SwordSweepEntity entity, PoseStack poseStack, VertexConsumer vertexConsumer, float scale, int vertexAlpha) {
        poseStack.pushPose();
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        float xTilt = Mth.randomBetween((RandomSource)RandomSource.create((long)entity.getUUID().getLeastSignificantBits()), (float)-30.0f, (float)30.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(xTilt));
        this.drawQuad(poseStack, vertexConsumer, vertexAlpha);
        poseStack.popPose();
    }

    private void drawQuad(PoseStack poseStack, VertexConsumer vertexConsumer, int vertexAlpha) {
        PoseStack.Pose pose = poseStack.last();
        int width = 10;
        int height = 32;
        float halfWidth = (float)width / 2.0f;
        float halfHeight = (float)height / 2.0f;
        VertexBuilder.vertex(pose, vertexConsumer, -halfWidth, -halfHeight, 0.0f, 0.0f, 0.0f, 1, 255, 255, 255, vertexAlpha);
        VertexBuilder.vertex(pose, vertexConsumer, halfWidth, -halfHeight, 0.0f, 1.0f, 0.0f, 1, 255, 255, 255, vertexAlpha);
        VertexBuilder.vertex(pose, vertexConsumer, halfWidth, halfHeight, 0.0f, 1.0f, 1.0f, 1, 255, 255, 255, vertexAlpha);
        VertexBuilder.vertex(pose, vertexConsumer, -halfWidth, halfHeight, 0.0f, 0.0f, 1.0f, 1, 255, 255, 255, vertexAlpha);
        VertexBuilder.vertex(pose, vertexConsumer, -halfWidth, halfHeight, 0.0f, 0.0f, 1.0f, -1, 255, 255, 255, vertexAlpha);
        VertexBuilder.vertex(pose, vertexConsumer, halfWidth, halfHeight, 0.0f, 1.0f, 1.0f, -1, 255, 255, 255, vertexAlpha);
        VertexBuilder.vertex(pose, vertexConsumer, halfWidth, -halfHeight, 0.0f, 1.0f, 0.0f, -1, 255, 255, 255, vertexAlpha);
        VertexBuilder.vertex(pose, vertexConsumer, -halfWidth, -halfHeight, 0.0f, 0.0f, 0.0f, -1, 255, 255, 255, vertexAlpha);
    }

    public ResourceLocation getTextureLocation(SwordSweepEntity entity) {
        return TEXTURE;
    }
}

