/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.turtleboi.bytebuddies.block.ModBlocks;
import net.turtleboi.bytebuddies.component.ModDataComponents;
import net.turtleboi.bytebuddies.effects.ModEffects;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.item.custom.ClipboardItem;
import net.turtleboi.bytebuddies.item.custom.TerrabladeItem;

@EventBusSubscriber(modid="bytebuddies")
public class ModEvents {
    private static final int chargeRadius = 3;

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() instanceof ByteBuddyEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Post event) {
        DamageSource source;
        Entity entity;
        ByteBuddyEntity byteBuddyEntity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ByteBuddyEntity) {
            byteBuddyEntity = (ByteBuddyEntity)livingEntity;
        }
        if ((livingEntity = event.getSource().getEntity()) instanceof ByteBuddyEntity) {
            byteBuddyEntity = (ByteBuddyEntity)livingEntity;
        }
        if ((entity = (source = event.getSource()).getEntity()) instanceof LivingEntity) {
            LivingEntity charge2;
            LivingEntity attacker = (LivingEntity)entity;
            ItemStack weapon = attacker.getMainHandItem();
            if (weapon.getItem() instanceof TerrabladeItem) {
                float damageDealt = event.getOriginalDamage();
                int charge2 = (Integer)weapon.getOrDefault((DataComponentType)ModDataComponents.CHARGE.get(), (Object)0);
                int newCharge = Math.min(charge2 + Math.round(damageDealt), 100);
                weapon.set((DataComponentType)ModDataComponents.CHARGE.get(), (Object)newCharge);
            }
            if ((charge2 = event.getEntity()) instanceof LivingEntity) {
                ByteBuddyEntity byteBuddy;
                LivingEntity victim = charge2;
                Level level = victim.level();
                if (victim.hasEffect(ModEffects.SUPERCHARGED)) {
                    if (victim instanceof Player) {
                        Player player = (Player)victim;
                        attacker.hurt(level.damageSources().playerAttack(player), 6.0f);
                    } else {
                        attacker.hurt(level.damageSources().mobAttack(victim), 6.0f);
                    }
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(ModEffects.STUNNED, 100);
                    attacker.addEffect(mobEffectInstance, (Entity)victim);
                }
                if (victim instanceof ByteBuddyEntity && (byteBuddy = (ByteBuddyEntity)victim).getAugmentEffects().shockOnHit()) {
                    byteBuddy.onMeleeHit(attacker);
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(ModEffects.STUNNED, 100);
                    attacker.addEffect(mobEffectInstance, (Entity)victim);
                }
            }
        }
    }

    @SubscribeEvent
    private static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof ClipboardItem) {
            ClipboardItem clipboard = (ClipboardItem)item;
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.CONSUME);
            if (!event.getLevel().isClientSide()) {
                clipboard.handleClick(event.getEntity(), stack, event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LightningBolt)) {
            return;
        }
        LightningBolt lightning = (LightningBolt)entity;
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos center = lightning.blockPosition();
        ModEvents.chargeNearbyBlocks(level, center, 3);
        ModEvents.chargeNearbyItemEntities(level, center, 3);
    }

    private static void chargeNearbyBlocks(ServerLevel level, BlockPos center, int radius) {
        BlockPos min = center.offset(-radius, -1, -radius);
        BlockPos max = center.offset(radius, 1, radius);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            BlockState state = level.getBlockState(pos);
            if (!state.is((Block)ModBlocks.STEEL_BLOCK.get())) continue;
            level.setBlockAndUpdate(pos, ((Block)ModBlocks.CHARGED_STEEL_BLOCK.get()).defaultBlockState());
        }
    }

    private static void chargeNearbyItemEntities(ServerLevel level, BlockPos center, int radius) {
        AABB boundingBox = new AABB(center).inflate((double)radius);
        for (ItemEntity itemEntity : level.getEntitiesOfClass(ItemEntity.class, boundingBox)) {
            Item chargedItem;
            ItemStack itemStack = itemEntity.getItem();
            if (itemStack.isEmpty() || (chargedItem = ModEvents.mapSteelToCharged(itemStack.getItem())) == null) continue;
            ItemStack chargedOutPut = new ItemStack((ItemLike)chargedItem, itemStack.getCount());
            chargedOutPut.applyComponents(itemStack.getComponents());
            itemEntity.setItem(chargedOutPut);
        }
    }

    private static Item mapSteelToCharged(Item item) {
        if (item == ModItems.STEEL_INGOT.get()) {
            return (Item)ModItems.CHARGED_STEEL_INGOT.get();
        }
        if (item == ModItems.STEEL_NUGGET.get()) {
            return (Item)ModItems.CHARGED_STEEL_NUGGET.get();
        }
        if (item == ((Block)ModBlocks.STEEL_BLOCK.get()).asItem()) {
            return ((Block)ModBlocks.CHARGED_STEEL_BLOCK.get()).asItem();
        }
        return null;
    }
}

