/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.init.ModTags;
import net.turtleboi.bytebuddies.item.ModItems;
import net.turtleboi.bytebuddies.util.AttributeModifierUtil;

public class AugmentItem
extends Item {
    public AugmentItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public static final class AugmentEffects {
        private boolean propellerEnabled = false;
        private boolean aquaEnabled = false;
        private boolean solarEnabled = false;
        private boolean geothermalEnabled = false;
        private boolean magnetEnabled = false;
        private boolean gyroEnabled = false;
        private boolean arcWelderEnabled = false;
        private boolean dynamoEnabled = false;
        private boolean fireResistant = false;
        private boolean shockOnHit = false;
        private boolean enderLinkEnabled = false;
        private double solarChargePerSecond = 0.0;
        private double geothermalChargePerSecond = 0.0;
        private double dynamoChargePerMeter = 0.0;
        private double magnetRadiusBlocks = 0.0;
        private int extraStorageSlots = 0;
        private double armorBonus = 0.0;
        private double moveSpeedMultiplier = 1.0;
        private double knockbackResistBonus = 0.0;
        private double selfRepairPerSecond = 0.0;
        private int momentumTicks = 0;
        private double momentumSpeedMultiplier = 1.0;
        private ByteBuddyEntity.ChassisMaterial chassisMaterial = ByteBuddyEntity.ChassisMaterial.ALUMINUM;

        public void recomputeFrom(ItemStackHandler buddyInventory, ByteBuddyEntity byteBuddy) {
            this.propellerEnabled = false;
            this.aquaEnabled = false;
            this.solarEnabled = false;
            this.geothermalEnabled = false;
            this.magnetEnabled = false;
            this.gyroEnabled = false;
            this.arcWelderEnabled = false;
            this.dynamoEnabled = false;
            this.fireResistant = false;
            this.shockOnHit = false;
            this.enderLinkEnabled = false;
            this.solarChargePerSecond = 0.0;
            this.geothermalChargePerSecond = 0.0;
            this.dynamoChargePerMeter = 0.0;
            this.magnetRadiusBlocks = 0.0;
            this.extraStorageSlots = 0;
            this.armorBonus = 0.0;
            this.moveSpeedMultiplier = 1.0;
            this.knockbackResistBonus = 0.0;
            this.selfRepairPerSecond = 0.0;
            this.momentumTicks = 0;
            this.momentumSpeedMultiplier = 1.0;
            this.chassisMaterial = ByteBuddyEntity.ChassisMaterial.ALUMINUM;
            for (int slot = 1; slot < 3; ++slot) {
                ItemStack stack = buddyInventory.getStackInSlot(slot);
                if (stack.isEmpty()) continue;
                if (stack.is(ModTags.Items.PLATING)) {
                    if (stack.is((Item)ModItems.REINFORCED_CHARGED_STEEL_PLATING.get())) {
                        this.chassisMaterial = ByteBuddyEntity.ChassisMaterial.CHARGED_STEEL;
                        this.armorBonus = 16.0;
                        this.moveSpeedMultiplier = 1.05;
                        this.shockOnHit = true;
                        continue;
                    }
                    if (stack.is((Item)ModItems.REINFORCED_NETHERITE_PLATING.get())) {
                        this.chassisMaterial = ByteBuddyEntity.ChassisMaterial.NETHERITE;
                        this.armorBonus = 20.0;
                        this.moveSpeedMultiplier = 0.75;
                        this.fireResistant = true;
                        this.knockbackResistBonus += 0.25;
                        continue;
                    }
                    if (stack.is((Item)ModItems.REINFORCED_STEEL_PLATING.get())) {
                        this.chassisMaterial = ByteBuddyEntity.ChassisMaterial.STEEL;
                        this.armorBonus = 12.0;
                        this.moveSpeedMultiplier = 0.85;
                        continue;
                    }
                    if (!stack.is((Item)ModItems.REINFORCED_IRON_PLATING.get())) continue;
                    this.chassisMaterial = ByteBuddyEntity.ChassisMaterial.IRON;
                    this.armorBonus = 6.0;
                    this.moveSpeedMultiplier = 0.95;
                    continue;
                }
                if (stack.is(ModTags.Items.STORAGE_CELL)) {
                    if (stack.is((Item)ModItems.ENDERLINK_STORAGE_CELL.get())) {
                        this.extraStorageSlots = 18;
                        this.enderLinkEnabled = true;
                        continue;
                    }
                    if (stack.is((Item)ModItems.ADVANCED_STORAGE_CELL.get())) {
                        this.extraStorageSlots = 18;
                        this.moveSpeedMultiplier *= 0.88;
                        continue;
                    }
                    if (!stack.is((Item)ModItems.BASIC_STORAGE_CELL.get())) continue;
                    this.extraStorageSlots = 9;
                    this.moveSpeedMultiplier *= 0.95;
                    continue;
                }
                if (stack.is((Item)ModItems.PROPELLER_UNIT.get())) {
                    this.propellerEnabled = true;
                    this.moveSpeedMultiplier *= 0.92;
                    continue;
                }
                if (stack.is((Item)ModItems.AQUATIC_MOTOR.get())) {
                    this.aquaEnabled = true;
                    continue;
                }
                if (stack.is((Item)ModItems.SOLAR_ARRAY.get())) {
                    this.solarEnabled = true;
                    this.solarChargePerSecond += 5.0;
                    continue;
                }
                if (stack.is((Item)ModItems.GEOTHERMAL_REGULATOR.get())) {
                    this.geothermalEnabled = true;
                    this.geothermalChargePerSecond += 5.0;
                    continue;
                }
                if (stack.is((Item)ModItems.MAGNETIC_CRESCENT.get())) {
                    this.magnetEnabled = true;
                    this.magnetRadiusBlocks = Math.max(this.magnetRadiusBlocks, 5.0);
                    continue;
                }
                if (stack.is((Item)ModItems.DYNAMO_COIL.get())) {
                    this.dynamoEnabled = true;
                    this.dynamoChargePerMeter += 0.6;
                    this.momentumTicks = Math.max(this.momentumTicks, 25);
                    this.momentumSpeedMultiplier = Math.max(this.momentumSpeedMultiplier, 1.15);
                    continue;
                }
                if (stack.is((Item)ModItems.ARC_WELDER.get())) {
                    this.arcWelderEnabled = true;
                    this.selfRepairPerSecond += 0.5;
                    continue;
                }
                if (!stack.is((Item)ModItems.GYROSCOPIC_STABILIZER.get())) continue;
                this.gyroEnabled = true;
                this.knockbackResistBonus += 0.25;
            }
            this.moveSpeedMultiplier = Mth.clamp((double)this.moveSpeedMultiplier, (double)0.6, (double)1.85);
            AttributeModifierUtil.applyPermanentModifier((LivingEntity)byteBuddy, (Holder<Attribute>)Attributes.ARMOR, "augment_armor", this.armorBonus, AttributeModifier.Operation.ADD_VALUE);
            AttributeModifierUtil.applyPermanentModifier((LivingEntity)byteBuddy, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, "augment_speed_mul", this.moveSpeedMultiplier - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            AttributeModifierUtil.applyPermanentModifier((LivingEntity)byteBuddy, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, "augment_kb_resist", this.knockbackResistBonus, AttributeModifier.Operation.ADD_VALUE);
        }

        public boolean propellerEnabled() {
            return this.propellerEnabled;
        }

        public boolean aquaEnabled() {
            return this.aquaEnabled;
        }

        public boolean solarEnabled() {
            return this.solarEnabled;
        }

        public boolean geothermalEnabled() {
            return this.geothermalEnabled;
        }

        public boolean magnetEnabled() {
            return this.magnetEnabled;
        }

        public boolean gyroEnabled() {
            return this.gyroEnabled;
        }

        public boolean arcWelderEnabled() {
            return this.arcWelderEnabled;
        }

        public boolean dynamoEnabled() {
            return this.dynamoEnabled;
        }

        public boolean fireResistant() {
            return this.fireResistant;
        }

        public boolean shockOnHit() {
            return this.shockOnHit;
        }

        public boolean enderLinkEnabled() {
            return this.enderLinkEnabled;
        }

        public double solarChargePerSecond() {
            return this.solarChargePerSecond;
        }

        public double geothermalChargePerSecond() {
            return this.geothermalChargePerSecond;
        }

        public double dynamoChargePerMeter() {
            return this.dynamoChargePerMeter;
        }

        public double magnetRadiusBlocks() {
            return this.magnetRadiusBlocks;
        }

        public int extraStorageSlots() {
            return this.extraStorageSlots;
        }

        public double selfRepairPerSecond() {
            return this.selfRepairPerSecond;
        }

        public int momentumTicks() {
            return this.momentumTicks;
        }

        public double momentumSpeedMultiplier() {
            return this.momentumSpeedMultiplier;
        }

        public ByteBuddyEntity.ChassisMaterial getChassisMaterial() {
            return this.chassisMaterial;
        }
    }
}

