/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.turtleboi.bytebuddies.ByteBuddies;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public class BatteryItem
extends Item {
    private static final String KEY_ENERGY = "bytebuddies:energy";
    private final int capacity;
    private final int ioRate;
    private final String tierName;

    public BatteryItem(Item.Properties properties, String tierName, int capacity, int ioRate) {
        super(properties.stacksTo(1));
        this.tierName = tierName;
        this.capacity = capacity;
        this.ioRate = ioRate;
    }

    public int getEnergy(ItemStack stack) {
        CustomData dataComponents = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (dataComponents == null) {
            return 0;
        }
        CompoundTag nbtData = dataComponents.copyTag();
        return nbtData.contains(KEY_ENERGY) ? Math.max(0, nbtData.getInt(KEY_ENERGY)) : 0;
    }

    public void setEnergy(ItemStack batteryStack, int energyValue) {
        energyValue = Math.max(0, Math.min(this.capacity, energyValue));
        CustomData dataComponents = (CustomData)batteryStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag nbtData = dataComponents != null ? dataComponents.copyTag() : new CompoundTag();
        nbtData.putInt(KEY_ENERGY, energyValue);
        batteryStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtData));
    }

    public int extract(ItemStack batteryStack, int energyValue, boolean transferable) {
        int batteryEnergy = this.getEnergy(batteryStack);
        int extractableEnergy = Math.min(this.ioRate, Math.min(energyValue, batteryEnergy));
        if (!transferable && extractableEnergy > 0) {
            this.setEnergy(batteryStack, batteryEnergy - extractableEnergy);
        }
        return extractableEnergy;
    }

    public int receive(ItemStack batteryStack, int energyValue, boolean transferable) {
        int batteryEnergy = this.getEnergy(batteryStack);
        int receivableEnergy = Math.min(this.ioRate, Math.min(energyValue, this.capacity - batteryEnergy));
        if (!transferable && receivableEnergy > 0) {
            this.setEnergy(batteryStack, batteryEnergy + receivableEnergy);
        }
        return receivableEnergy;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getIoRate() {
        return this.ioRate;
    }

    public InteractionResult interactLivingEntity(ItemStack batteryStack, Player player, LivingEntity target, InteractionHand interactionHand) {
        if (target instanceof ByteBuddyEntity) {
            ByteBuddyEntity bot = (ByteBuddyEntity)target;
            if (player.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            int batteryEnergy = this.getEnergy(batteryStack);
            if (batteryEnergy <= 0) {
                player.displayClientMessage((Component)Component.literal((String)"Battery is empty").withStyle(ChatFormatting.RED), true);
                ByteBuddies.LOGGER.info("[ByteBuddies] battery: empty (tier={})", (Object)this.tierName);
                return InteractionResult.CONSUME;
            }
            int missingEnergy = bot.getEnergyStorage().getMaxEnergyStored() - bot.getEnergyStorage().getEnergyStored();
            if (missingEnergy <= 0) {
                player.displayClientMessage((Component)Component.literal((String)"Bot is already full").withStyle(ChatFormatting.YELLOW), true);
                return InteractionResult.CONSUME;
            }
            int transferableEnergy = Math.min(this.ioRate, Math.min(batteryEnergy, missingEnergy));
            int extractableEnergy = this.extract(batteryStack, transferableEnergy, false);
            int receivableEnergy = bot.getEnergyStorage().receiveEnergy(extractableEnergy, false);
            if (receivableEnergy < extractableEnergy) {
                this.setEnergy(batteryStack, this.getEnergy(batteryStack) + (extractableEnergy - receivableEnergy));
            }
            player.displayClientMessage((Component)Component.literal((String)("Transferred " + receivableEnergy + " FE to bot")), true);
            ByteBuddies.LOGGER.info("[ByteBuddies] battery\u2192bot: tier={} gave={}FE remain={}FE bot={}/{}", new Object[]{this.tierName, receivableEnergy, this.getEnergy(batteryStack), bot.getEnergyStorage().getEnergyStored(), bot.getEnergyStorage().getMaxEnergyStored()});
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (!level.isClientSide) {
            player.displayClientMessage((Component)Component.literal((String)(this.batteryTier() + " " + this.getEnergy(itemInHand) + " / " + this.capacity + " FE")), true);
        }
        return InteractionResultHolder.success((Object)itemInHand);
    }

    public static void buddyDrainBatteries(ByteBuddyEntity byteBuddy) {
        int receivedEnergy;
        int neededEnergy;
        BatteryItem batteryItem;
        int pulledEnergy;
        Item item;
        ItemStack batteryInSlot;
        int missingEnergy = byteBuddy.getEnergyStorage().getMaxEnergyStored() - byteBuddy.getEnergyStorage().getEnergyStored();
        if (missingEnergy >= 0 && !(batteryInSlot = byteBuddy.getMainInv().getStackInSlot(byteBuddy.getBatterySlot())).isEmpty() && (item = batteryInSlot.getItem()) instanceof BatteryItem && (pulledEnergy = (batteryItem = (BatteryItem)item).extract(batteryInSlot, neededEnergy = Math.min(missingEnergy, batteryItem.getIoRate()), false)) > 0 && (receivedEnergy = byteBuddy.getEnergyStorage().receiveEnergy(pulledEnergy, false)) < pulledEnergy) {
            batteryItem.setEnergy(batteryInSlot, batteryItem.getEnergy(batteryInSlot) + (pulledEnergy - receivedEnergy));
        }
    }

    public static void dockBlockDrainBatteries(BlockEntity blockEntity) {
        int receivedEnergy;
        int neededEnergy;
        BatteryItem batteryItem;
        int pulledEnergy;
        Item item;
        ItemStack stackInSlot;
        DockingStationBlockEntity dockBlock;
        int missingEnergy;
        if (blockEntity instanceof DockingStationBlockEntity && (missingEnergy = (dockBlock = (DockingStationBlockEntity)blockEntity).getEnergyStorage().getMaxEnergyStored() - dockBlock.getEnergyStorage().getEnergyStored()) >= 0 && !(stackInSlot = dockBlock.getBatteryStack()).isEmpty() && (item = stackInSlot.getItem()) instanceof BatteryItem && (pulledEnergy = (batteryItem = (BatteryItem)item).extract(stackInSlot, neededEnergy = Math.min(missingEnergy, batteryItem.getIoRate()), false)) > 0 && (receivedEnergy = dockBlock.getEnergyStorage().receiveEnergy(pulledEnergy, false)) < pulledEnergy) {
            batteryItem.setEnergy(stackInSlot, batteryItem.getEnergy(stackInSlot) + (pulledEnergy - receivedEnergy));
        }
    }

    public void appendHoverText(ItemStack batteryStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(batteryStack, context, tooltip, flag);
        tooltip.add((Component)Component.literal((String)(this.batteryTier() + " Capacity: " + this.capacity + " FE")).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)("Charge: " + this.getEnergy(batteryStack) + " FE")).withStyle(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.literal((String)("I/O per use: " + this.ioRate + " FE")).withStyle(ChatFormatting.DARK_AQUA));
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        float fullEnergyBar = (float)this.getEnergy(stack) / (float)this.capacity;
        return Math.round(13.0f * fullEnergyBar);
    }

    public int getBarColor(ItemStack batteryStack) {
        return 3073744;
    }

    private String batteryTier() {
        return switch (this.tierName) {
            case "simple" -> "Simple Battery";
            case "advanced" -> "Advanced Battery";
            case "biocell" -> "Biocell Battery";
            case "reinforced" -> "Reinforced Battery";
            case "supercharged" -> "Super-Charged Battery";
            default -> "Battery";
        };
    }
}

